/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.block.obj;

import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class JSLeavesBlock
extends LeavesBlock {
    private static final int INTERNAL_MAX_DISTANCE = 14;
    private static final int VANILLA_MAX_DISTANCE = 7;

    public JSLeavesBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        level.setBlock(pos, JSLeavesBlock.updateDistance(state, (LevelAccessor)level, pos), 3);
    }

    private static BlockState updateDistance(BlockState state, LevelAccessor level, BlockPos pos) {
        int dist = JSLeavesBlock.check6Neighbors(level, pos);
        if (dist >= 7) {
            dist = JSLeavesBlock.check26Neighbors(level, pos);
        }
        int scaled = (int)Math.ceil((double)dist / 2.0);
        return (BlockState)state.setValue((Property)DISTANCE, (Comparable)Integer.valueOf(Math.min(scaled, 7)));
    }

    private static int check6Neighbors(LevelAccessor level, BlockPos pos) {
        int dist = 14;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (Direction dir : Direction.values()) {
            mutable.setWithOffset((Vec3i)pos, dir);
            dist = Math.min(dist, JSLeavesBlock.getDistanceAt(level.getBlockState((BlockPos)mutable)) + 1);
            if (dist == 1) break;
        }
        return dist;
    }

    private static int check26Neighbors(LevelAccessor level, BlockPos pos) {
        BlockPos neighbor;
        int dist = 14;
        Iterator iterator = BlockPos.betweenClosed((BlockPos)pos.offset(-1, -1, -1), (BlockPos)pos.offset(1, 1, 1)).iterator();
        while (iterator.hasNext() && ((neighbor = (BlockPos)iterator.next()).equals((Object)pos) || (dist = Math.min(dist, JSLeavesBlock.getDistanceAt(level.getBlockState(neighbor)) + 1)) != 1)) {
        }
        return dist;
    }

    private static int getDistanceAt(BlockState neighbor) {
        if (neighbor.is(BlockTags.LOGS)) {
            return 0;
        }
        if (neighbor.getBlock() instanceof LeavesBlock && neighbor.hasProperty((Property)DISTANCE)) {
            return (Integer)neighbor.getValue((Property)DISTANCE) * 2;
        }
        return 14;
    }
}

