/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.block.obj.group;

import com.google.common.base.Supplier;
import java.util.ArrayList;
import java.util.Collection;
import jp.jurassicsaga.server.base.block.JSBlocks;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class ColoredRegistries {
    public final Supplier<Block> BLACK;
    public final Supplier<Block> BLUE;
    public final Supplier<Block> BROWN;
    public final Supplier<Block> CYAN;
    public final Supplier<Block> GREEN;
    public final Supplier<Block> GREY;
    public final Supplier<Block> LIGHTBLUE;
    public final Supplier<Block> LIGHTGREY;
    public final Supplier<Block> LIME;
    public final Supplier<Block> MAGENTA;
    public final Supplier<Block> ORANGE;
    public final Supplier<Block> PINK;
    public final Supplier<Block> PURPLE;
    public final Supplier<Block> RED;
    public final Supplier<Block> WHITE;
    public final Supplier<Block> YELLOW;
    private final String name;
    private final Supplier<Block> blockSupplier;
    private final Item.Properties properties;

    public ColoredRegistries(String baseName, Supplier<Block> blockSupplier, Item.Properties properties) {
        this.name = baseName;
        this.blockSupplier = blockSupplier;
        this.properties = properties;
        this.BLACK = this.createRegistry("_black");
        this.BLUE = this.createRegistry("_blue");
        this.BROWN = this.createRegistry("_brown");
        this.CYAN = this.createRegistry("_cyan");
        this.GREEN = this.createRegistry("_green");
        this.GREY = this.createRegistry("_grey");
        this.LIGHTBLUE = this.createRegistry("_lightblue");
        this.LIGHTGREY = this.createRegistry("_lightgrey");
        this.LIME = this.createRegistry("_lime");
        this.MAGENTA = this.createRegistry("_magenta");
        this.ORANGE = this.createRegistry("_orange");
        this.PINK = this.createRegistry("_pink");
        this.PURPLE = this.createRegistry("_purple");
        this.RED = this.createRegistry("_red");
        this.WHITE = this.createRegistry("_white");
        this.YELLOW = this.createRegistry("_yellow");
    }

    private Supplier<Block> createRegistry(String color) {
        return JSBlocks.registerBlockWItem(this.name + color, this.blockSupplier, this.properties);
    }

    public Collection<ItemLike> collect() {
        return this.stacks(this.BLACK, this.BLACK, this.BROWN, this.CYAN, this.GREEN, this.GREEN, this.LIGHTBLUE, this.LIGHTGREY, this.LIME, this.MAGENTA, this.ORANGE, this.PINK, this.PURPLE, this.RED, this.WHITE, this.YELLOW);
    }

    @SafeVarargs
    private ArrayList<ItemLike> stacks(Supplier<Block> ... stacks) {
        ArrayList<ItemLike> stacksList = new ArrayList<ItemLike>();
        for (Supplier<Block> stack : stacks) {
            stacksList.add(this.stack(stack));
        }
        return stacksList;
    }

    private ItemLike stack(Supplier<Block> block) {
        return ((Block)block.get()).asItem();
    }

    public String getName() {
        return this.name;
    }
}

