/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.block.obj.group;

import com.google.common.base.Supplier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import jp.jurassicsaga.server.base.block.JSBlocks;
import jp.jurassicsaga.server.base.block.obj.JSLeavesBlock;
import jp.jurassicsaga.server.base.block.obj.vanilla.JSCeilingHangingSignBlock;
import jp.jurassicsaga.server.base.block.obj.vanilla.JSStandingSignBlock;
import jp.jurassicsaga.server.base.block.obj.vanilla.JSWallHangingSignBlock;
import jp.jurassicsaga.server.base.block.obj.vanilla.JSWallSignBlock;
import jp.jurassicsaga.server.base.block.obj.vanilla_overrides.JSButton;
import jp.jurassicsaga.server.base.block.obj.vanilla_overrides.JSDoor;
import jp.jurassicsaga.server.base.block.obj.vanilla_overrides.JSPressurePlate;
import jp.jurassicsaga.server.base.block.obj.vanilla_overrides.JSStair;
import jp.jurassicsaga.server.base.block.obj.vanilla_overrides.JSTrapdoor;
import jp.jurassicsaga.server.base.item.JSItems;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DoubleHighBlockItem;
import net.minecraft.world.item.HangingSignItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;

public class WoodRegistries {
    public final Supplier<Block> BLOCK;
    public final Supplier<Block> SLAB;
    public final Supplier<Block> STAIRS;
    public final Supplier<Block> FENCE;
    public final Supplier<Block> FENCE_GATE;
    public final Supplier<Block> LOG;
    public final Supplier<Block> WOOD;
    public final Supplier<Block> STRIPPED_WOOD;
    public final Supplier<Block> STRIPPED_LOG;
    public final Supplier<Block> DOOR;
    public final Supplier<Block> BUTTON;
    public final Supplier<Block> PRESSURE_PLATE;
    public final Supplier<Block> TRAPDOOR;
    public final Supplier<Block> SIGN;
    public final Supplier<Item> SIGN_ITEM;
    public final Supplier<Block> WALL_SIGN;
    public final Supplier<Block> HANGING_SIGN;
    public final Supplier<Block> HANGING_SIGN_WALL;
    public final Supplier<Item> HANGING_SIGN_ITEM;
    public final Supplier<Block> LEAVES;
    public final WoodType woodType;
    public final BlockSetType woodSetType;

    public WoodRegistries(String name, MapColor color, Item.Properties empty) {
        this.woodSetType = BlockSetType.register((BlockSetType)new BlockSetType(name, true, true, true, BlockSetType.PressurePlateSensitivity.EVERYTHING, SoundType.WOOD, SoundEvents.WOODEN_DOOR_CLOSE, SoundEvents.WOODEN_DOOR_OPEN, SoundEvents.WOODEN_TRAPDOOR_CLOSE, SoundEvents.WOODEN_TRAPDOOR_CLOSE, SoundEvents.WOODEN_PRESSURE_PLATE_CLICK_OFF, SoundEvents.WOODEN_PRESSURE_PLATE_CLICK_ON, SoundEvents.WOODEN_BUTTON_CLICK_OFF, SoundEvents.WOODEN_BUTTON_CLICK_ON));
        this.woodType = WoodType.register((WoodType)new WoodType("jurassicsaga:" + name, this.woodSetType));
        this.BLOCK = JSBlocks.BLOCKS.register(name, () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS).mapColor(color)));
        this.SLAB = JSBlocks.BLOCKS.register(name + "_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_SLAB).mapColor(color)));
        this.STAIRS = JSBlocks.BLOCKS.register(name + "_stairs", () -> new JSStair(((Block)this.BLOCK.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_STAIRS).mapColor(color)));
        this.FENCE = JSBlocks.BLOCKS.register(name + "_fence", () -> new FenceBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_FENCE).mapColor(color)));
        this.FENCE_GATE = JSBlocks.BLOCKS.register(name + "_fence_gate", () -> new FenceGateBlock(this.woodType, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_FENCE_GATE).mapColor(color)));
        this.STRIPPED_LOG = JSBlocks.BLOCKS.register("stripped_" + name + "_log", () -> new RotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STRIPPED_OAK_LOG).mapColor(color)));
        this.LOG = JSBlocks.BLOCKS.register(name + "_log", () -> new RotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LOG).mapColor(color)));
        this.WOOD = JSBlocks.BLOCKS.register(name + "_wood", () -> new RotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_WOOD).mapColor(color)));
        this.STRIPPED_WOOD = JSBlocks.BLOCKS.register("stripped_" + name + "_wood", () -> new RotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STRIPPED_OAK_WOOD).mapColor(color)));
        this.DOOR = JSBlocks.BLOCKS.register(name + "_door", () -> new JSDoor(this.woodSetType, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_DOOR).mapColor(color)));
        this.BUTTON = JSBlocks.BLOCKS.register(name + "_button", () -> new JSButton(this.woodSetType, 30, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_BUTTON).mapColor(color)));
        this.PRESSURE_PLATE = JSBlocks.BLOCKS.register(name + "_pressure_plate", () -> new JSPressurePlate(this.woodSetType, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PRESSURE_PLATE).mapColor(color)));
        this.SIGN = JSBlocks.BLOCKS.register(name + "_sign", () -> new JSStandingSignBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_SIGN).mapColor(color), this.woodType));
        this.TRAPDOOR = JSBlocks.BLOCKS.register(name + "_trapdoor", () -> new JSTrapdoor(this.woodSetType, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_TRAPDOOR).mapColor(color)));
        this.WALL_SIGN = JSBlocks.BLOCKS.register(name + "_wall_sign", () -> new JSWallSignBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_WALL_SIGN).mapColor(color), this.woodType));
        this.HANGING_SIGN = JSBlocks.BLOCKS.register(name + "_hanging_sign", () -> new JSCeilingHangingSignBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_HANGING_SIGN).mapColor(color), this.woodType));
        this.HANGING_SIGN_WALL = JSBlocks.BLOCKS.register(name + "_hanging_wall_sign", () -> new JSWallHangingSignBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_WALL_HANGING_SIGN).mapColor(color), this.woodType));
        this.LEAVES = JSBlocks.BLOCKS.register(name + "_leaves", WoodRegistries::leaves);
        JSItems.registerItem(name, (Supplier<Item>)((Supplier)() -> new BlockItem((Block)this.BLOCK.get(), empty)));
        JSItems.registerItem(name + "_slab", (Supplier<Item>)((Supplier)() -> new BlockItem((Block)this.SLAB.get(), empty)));
        JSItems.registerItem(name + "_stairs", (Supplier<Item>)((Supplier)() -> new BlockItem((Block)this.STAIRS.get(), empty)));
        JSItems.registerItem(name + "_fence", (Supplier<Item>)((Supplier)() -> new BlockItem((Block)this.FENCE.get(), empty)));
        JSItems.registerItem(name + "_fence_gate", (Supplier<Item>)((Supplier)() -> new BlockItem((Block)this.FENCE_GATE.get(), empty)));
        JSItems.registerItem("stripped_" + name + "_log", (Supplier<Item>)((Supplier)() -> new BlockItem((Block)this.STRIPPED_LOG.get(), empty)));
        JSItems.registerItem(name + "_log", (Supplier<Item>)((Supplier)() -> new BlockItem((Block)this.LOG.get(), empty)));
        JSItems.registerItem(name + "_wood", (Supplier<Item>)((Supplier)() -> new BlockItem((Block)this.WOOD.get(), empty)));
        JSItems.registerItem("stripped_" + name + "_wood", (Supplier<Item>)((Supplier)() -> new BlockItem((Block)this.STRIPPED_WOOD.get(), empty)));
        JSItems.registerItem(name + "_button", (Supplier<Item>)((Supplier)() -> new BlockItem((Block)this.BUTTON.get(), empty)));
        JSItems.registerItem(name + "_pressure_plate", (Supplier<Item>)((Supplier)() -> new BlockItem((Block)this.PRESSURE_PLATE.get(), empty)));
        JSItems.registerItem(name + "_trapdoor", (Supplier<Item>)((Supplier)() -> new BlockItem((Block)this.TRAPDOOR.get(), empty)));
        this.SIGN_ITEM = JSItems.registerItem(name + "_sign", (Supplier<Item>)((Supplier)() -> new SignItem(empty, (Block)this.SIGN.get(), (Block)this.WALL_SIGN.get())));
        this.HANGING_SIGN_ITEM = JSItems.registerItem(name + "_hanging_sign", (Supplier<Item>)((Supplier)() -> new HangingSignItem((Block)this.HANGING_SIGN.get(), (Block)this.HANGING_SIGN_WALL.get(), empty)));
        JSItems.registerItem(name + "_door", (Supplier<Item>)((Supplier)() -> new DoubleHighBlockItem((Block)this.DOOR.get(), empty)));
        JSItems.registerItem(name + "_leaves", (Supplier<Item>)((Supplier)() -> new BlockItem((Block)this.LEAVES.get(), empty)));
    }

    public static Block leaves() {
        return new JSLeavesBlock(BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).strength(0.2f).randomTicks().sound(SoundType.GRASS).noOcclusion().isValidSpawn((pState, pLevel, pPos, pValue) -> pValue == EntityType.OCELOT || pValue == EntityType.PARROT).isSuffocating((pState, pLevel, pPos) -> false).isViewBlocking((pState, pLevel, pPos) -> false).ignitedByLava().pushReaction(PushReaction.DESTROY).isRedstoneConductor((pState, pLevel, pPos) -> false));
    }

    public Collection<ItemLike> collect() {
        ArrayList<ItemLike> list = this.stacks(this.BLOCK, this.SLAB, this.STAIRS, this.FENCE, this.FENCE_GATE, this.STRIPPED_LOG, this.LOG, this.STRIPPED_WOOD, this.WOOD, this.DOOR, this.BUTTON, this.PRESSURE_PLATE, this.TRAPDOOR, this.LEAVES);
        list.add((ItemLike)this.SIGN_ITEM.get());
        list.add((ItemLike)this.HANGING_SIGN_ITEM.get());
        return list;
    }

    public void init() {
        FireBlock fireblock = (FireBlock)Blocks.FIRE;
        fireblock.setFlammable((Block)this.BLOCK.get(), 5, 20);
        fireblock.setFlammable((Block)this.SLAB.get(), 5, 20);
        fireblock.setFlammable((Block)this.STAIRS.get(), 5, 20);
        fireblock.setFlammable((Block)this.FENCE.get(), 5, 20);
        fireblock.setFlammable((Block)this.FENCE_GATE.get(), 5, 20);
        fireblock.setFlammable((Block)this.STRIPPED_LOG.get(), 5, 20);
        fireblock.setFlammable((Block)this.STRIPPED_WOOD.get(), 5, 20);
        fireblock.setFlammable((Block)this.WOOD.get(), 5, 20);
        fireblock.setFlammable((Block)this.DOOR.get(), 5, 20);
        fireblock.setFlammable((Block)this.BUTTON.get(), 5, 20);
        fireblock.setFlammable((Block)this.PRESSURE_PLATE.get(), 5, 20);
        fireblock.setFlammable((Block)this.TRAPDOOR.get(), 5, 20);
        fireblock.setFlammable((Block)this.LEAVES.get(), 5, 20);
        AxeItem.STRIPPABLES = new HashMap(AxeItem.STRIPPABLES);
        AxeItem.STRIPPABLES.put((Block)this.LOG.get(), (Block)this.STRIPPED_LOG.get());
        AxeItem.STRIPPABLES.put((Block)this.WOOD.get(), (Block)this.STRIPPED_WOOD.get());
        AxeItem.STRIPPABLES = Collections.unmodifiableMap(AxeItem.STRIPPABLES);
    }

    private ArrayList<ItemLike> stacks(Supplier<Block> ... stacks) {
        ArrayList<ItemLike> stacksList = new ArrayList<ItemLike>();
        for (Supplier<Block> stack : stacks) {
            stacksList.add(this.stack(stack));
        }
        return stacksList;
    }

    private ItemLike stack(Supplier<Block> block) {
        return ((Block)block.get()).asItem();
    }

    public Supplier<Block> getBLOCK() {
        return this.BLOCK;
    }

    public Supplier<Block> getSLAB() {
        return this.SLAB;
    }

    public Supplier<Block> getSTAIRS() {
        return this.STAIRS;
    }

    public Supplier<Block> getFENCE() {
        return this.FENCE;
    }

    public Supplier<Block> getFENCE_GATE() {
        return this.FENCE_GATE;
    }

    public Supplier<Block> getLOG() {
        return this.LOG;
    }

    public Supplier<Block> getWOOD() {
        return this.WOOD;
    }

    public Supplier<Block> getSTRIPPED_WOOD() {
        return this.STRIPPED_WOOD;
    }

    public Supplier<Block> getSTRIPPED_LOG() {
        return this.STRIPPED_LOG;
    }

    public Supplier<Block> getDOOR() {
        return this.DOOR;
    }

    public Supplier<Block> getBUTTON() {
        return this.BUTTON;
    }

    public Supplier<Block> getPRESSURE_PLATE() {
        return this.PRESSURE_PLATE;
    }

    public Supplier<Block> getTRAPDOOR() {
        return this.TRAPDOOR;
    }

    public Supplier<Block> getSIGN() {
        return this.SIGN;
    }

    public Supplier<Item> getSIGN_ITEM() {
        return this.SIGN_ITEM;
    }

    public Supplier<Block> getWALL_SIGN() {
        return this.WALL_SIGN;
    }

    public Supplier<Block> getHANGING_SIGN() {
        return this.HANGING_SIGN;
    }

    public Supplier<Block> getHANGING_SIGN_WALL() {
        return this.HANGING_SIGN_WALL;
    }

    public Supplier<Item> getHANGING_SIGN_ITEM() {
        return this.HANGING_SIGN_ITEM;
    }

    public Supplier<Block> getLEAVES() {
        return this.LEAVES;
    }

    public WoodType getWoodType() {
        return this.woodType;
    }

    public BlockSetType getWoodSetType() {
        return this.woodSetType;
    }
}

