/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.entity.obj.other;

import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.entity.JSEntities;
import jp.jurassicsaga.server.base.entity.obj.other.IJSRangedAttack;
import jp.jurassicsaga.server.base.particle.JSParticles;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class VenomSpit
extends Projectile {
    private JSAnimalBase base;

    public VenomSpit(EntityType<? extends VenomSpit> entityType, Level level) {
        super(entityType, level);
    }

    public VenomSpit(Level level, JSAnimalBase spitter) {
        this((EntityType<? extends VenomSpit>)((EntityType)JSEntities.VENOM_SPIT.get()), level);
        this.setOwner((Entity)spitter);
        this.base = spitter;
        this.setPos(spitter.getX() - (double)(spitter.getBbWidth() + 1.0f) * 0.5 * (double)Mth.sin((float)(spitter.yBodyRot * ((float)Math.PI / 180))), spitter.getEyeY() - (double)0.1f, spitter.getZ() + (double)(spitter.getBbWidth() + 1.0f) * 0.5 * (double)Mth.cos((float)(spitter.yBodyRot * ((float)Math.PI / 180))));
    }

    protected double getDefaultGravity() {
        return 0.06;
    }

    public void tick() {
        super.tick();
        Vec3 vec3 = this.getDeltaMovement();
        HitResult hitresult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, x$0 -> this.canHitEntity((Entity)x$0));
        if (hitresult.getType() != HitResult.Type.MISS) {
            this.hitTargetOrDeflectSelf(hitresult);
        }
        double d0 = this.getX() + vec3.x;
        double d1 = this.getY() + vec3.y;
        double d2 = this.getZ() + vec3.z;
        this.updateRotation();
        float f = 0.99f;
        if (this.level().getBlockStates(this.getBoundingBox()).noneMatch(BlockBehaviour.BlockStateBase::isAir)) {
            this.discard();
        } else if (this.isInWaterOrBubble()) {
            this.discard();
        } else {
            this.setDeltaMovement(vec3.scale((double)0.99f));
            this.applyGravity();
            this.setPos(d0, d1, d2);
        }
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        Entity entity = this.getOwner();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity;
            LivingEntity a = (LivingEntity)entity;
            Entity entity2 = result.getEntity();
            if (entity2 instanceof LivingEntity && (livingEntity = (LivingEntity)entity2).getType() != a.getType()) {
                JSAnimalBase jSAnimalBase;
                livingEntity.addEffect(new MobEffectInstance(MobEffects.DARKNESS, 260, 5, false, false));
                livingEntity.addEffect(new MobEffectInstance(MobEffects.POISON, 20, 1, false, false));
                livingEntity.addEffect(new MobEffectInstance(MobEffects.DIG_SLOWDOWN, 260, 1, false, false));
                livingEntity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 260, 3, false, false));
                if (this.base != null && (jSAnimalBase = this.base) instanceof IJSRangedAttack) {
                    IJSRangedAttack attack = (IJSRangedAttack)((Object)jSAnimalBase);
                    attack.onSuccess();
                }
            }
        }
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        if (!this.level().isClientSide) {
            this.discard();
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void recreateFromPacket(ClientboundAddEntityPacket packet) {
        super.recreateFromPacket(packet);
        double d0 = packet.getXa();
        double d1 = packet.getYa();
        double d2 = packet.getZa();
        for (int i = 0; i < 7; ++i) {
            double d3 = 0.4 + 0.1 * (double)i;
            this.level().addParticle((ParticleOptions)JSParticles.VENOM_SPIT.get(), this.getX(), this.getY(), this.getZ(), d0 * d3, d1, d2 * d3);
        }
        this.setDeltaMovement(d0, d1, d2);
    }
}

