/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.entity.obj.physics;

import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public abstract class PhysicsEntity
extends Entity {
    private Vec3 angularVelocity = Vec3.ZERO;
    private float zRot = 0.0f;
    private float zRotOld = 0.0f;
    public final float[] rawXRotHistory = new float[3];
    public final float[] rawYRotHistory = new float[3];
    public final float[] rawZRotHistory = new float[3];
    private float lastXRot;
    private float lastYRot;
    private float lastZRot;
    private float xAccum;
    private float yAccum;
    private float zAccum;

    public PhysicsEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public void tick() {
        super.tick();
        double gravity = this.getPhysicsGravity();
        double bounciness = this.getBounciness();
        double friction = this.getFriction();
        double angularDrag = this.getAngularDrag();
        double smoothFactor = this.getPhysicsSmoothing();
        Vec3 velocity = this.getDeltaMovement();
        Vec3 pushForce = Vec3.ZERO;
        double pushStrength = 0.05;
        List nearbyEntities = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(1.0), e -> e != this);
        for (Entity other : nearbyEntities) {
            Vec3 diff = this.position().subtract(other.position());
            double dist = diff.lengthSqr();
            if (!(dist > 0.0) || !(dist < 1.0)) continue;
            Vec3 pushDir = diff.normalize();
            double factor = 1.0 - dist;
            pushForce = pushForce.add(pushDir.scale(pushStrength * factor));
        }
        velocity = velocity.add(pushForce);
        if (this.level().getFluidState(this.blockPosition()) == Fluids.EMPTY.defaultFluidState()) {
            velocity = velocity.add(0.0, -gravity, 0.0);
        }
        this.move(MoverType.SELF, velocity);
        if (this.horizontalCollision) {
            double impactFactor = Mth.clamp((double)(Math.abs(velocity.y) * 0.5), (double)0.5, (double)1.5);
            double bounce = bounciness * impactFactor;
            velocity = new Vec3(-velocity.x * bounce, velocity.y, -velocity.z * bounce);
            this.angularVelocity = this.angularVelocity.add(this.getRandom().nextDouble(), (velocity.x + velocity.z) * 20.0, this.getRandom().nextDouble());
        }
        if (this.verticalCollision && velocity.y < 0.0) {
            double impactFactor = Mth.clamp((double)Math.abs(velocity.y), (double)0.5, (double)2.0);
            double bounce = bounciness * impactFactor;
            velocity = new Vec3(velocity.x, -velocity.y * bounce, velocity.z);
            this.angularVelocity = this.angularVelocity.add((velocity.z - velocity.x) * 10.0, this.getRandom().nextDouble() * 180.0, (velocity.x + velocity.z) * 10.0);
        }
        double angularSpeed = this.angularVelocity.length();
        double angularFriction = 1.0 - Mth.clamp((double)Math.pow(angularSpeed * 4.0, 2.0), (double)0.0, (double)1.0);
        angularFriction = Mth.clamp((double)angularFriction, (double)angularDrag, (double)0.98);
        this.angularVelocity = this.angularVelocity.add(velocity.z * 5.0, 0.0, -velocity.x * 5.0);
        boolean setYRot = true;
        this.angularVelocity = new Vec3(this.lerp(this.angularVelocity.x, this.angularVelocity.x, smoothFactor), this.lerp(this.angularVelocity.y, this.angularVelocity.y, smoothFactor), this.lerp(this.angularVelocity.z, this.angularVelocity.z, smoothFactor));
        if (this.verticalCollision && velocity.y < 0.5) {
            this.angularVelocity = new Vec3(Mth.lerp((double)0.1f, (double)this.angularVelocity.x, (double)0.0), this.angularVelocity.y * angularDrag, Mth.lerp((double)0.1f, (double)this.angularVelocity.z, (double)0.0));
            this.setXRot(Mth.lerp((float)0.1f, (float)this.getXRot(), (float)0.0f));
            this.setZRot(Mth.lerp((float)0.1f, (float)this.getZRot(), (float)0.0f));
            setYRot = false;
        } else {
            this.angularVelocity = this.angularVelocity.multiply(angularDrag, angularDrag, angularDrag);
        }
        this.angularVelocity = this.angularVelocity.multiply(angularFriction, angularFriction, angularFriction);
        double speed = velocity.length();
        double dynamicFriction = friction;
        if (this.verticalCollision && this.onGround()) {
            dynamicFriction = 0.7;
        } else {
            dynamicFriction = 1.0 - Mth.clamp((double)Math.pow(speed * 4.0, 2.0), (double)0.0, (double)1.0);
            dynamicFriction = Mth.clamp((double)dynamicFriction, (double)friction, (double)0.98);
        }
        velocity = velocity.multiply(dynamicFriction, dynamicFriction, dynamicFriction);
        this.setDeltaMovement(velocity);
        this.zRotOld = this.zRot;
        if (setYRot) {
            this.setXRot(this.getXRot() + (float)this.angularVelocity.x);
            this.setYRot(this.getYRot() + (float)this.angularVelocity.y);
            this.setZRot(this.getZRot() + (float)this.angularVelocity.z);
        }
        this.setParams();
    }

    private void setParams() {
        this.xAccum += this.getWrappedDelta(this.getXRot(), this.lastXRot);
        this.yAccum += this.getWrappedDelta(this.getYRot(), this.lastYRot);
        this.zAccum += this.getWrappedDelta(this.getZRot(), this.lastZRot);
        this.lastXRot = this.getXRot();
        this.lastYRot = this.getYRot();
        this.lastZRot = this.getZRot();
        this.rawXRotHistory[2] = this.rawXRotHistory[1];
        this.rawXRotHistory[1] = this.rawXRotHistory[0];
        this.rawXRotHistory[0] = this.xAccum;
        this.rawYRotHistory[2] = this.rawYRotHistory[1];
        this.rawYRotHistory[1] = this.rawYRotHistory[0];
        this.rawYRotHistory[0] = this.yAccum;
        this.rawZRotHistory[2] = this.rawZRotHistory[1];
        this.rawZRotHistory[1] = this.rawZRotHistory[0];
        this.rawZRotHistory[0] = this.zAccum;
    }

    private float getWrappedDelta(float current, float last) {
        return Mth.wrapDegrees((float)(current - last));
    }

    protected double getPhysicsSmoothing() {
        return 0.2;
    }

    protected double getAngularDrag() {
        return 0.92;
    }

    protected double getFriction() {
        return 0.96;
    }

    protected double getBounciness() {
        return 0.8;
    }

    protected double getPhysicsGravity() {
        return 0.15;
    }

    private double lerp(double a, double b, double f) {
        return a + f * (b - a);
    }

    public void updateSwimming() {
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SynchedEntityData.Builder builder) {
    }

    protected void readAdditionalSaveData(@NotNull CompoundTag compound) {
    }

    protected void addAdditionalSaveData(@NotNull CompoundTag compound) {
    }

    public void setAngularVelocity(Vec3 angularVelocity) {
        this.angularVelocity = angularVelocity;
    }

    public void setZRot(float zRot) {
        this.zRot = zRot;
    }

    public float getZRot() {
        return this.zRot;
    }

    public float getZRotOld() {
        return this.zRotOld;
    }
}

