/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.generic.gene.obj;

import java.util.ArrayList;
import java.util.List;
import jp.jurassicsaga.server.base.generic.gene.JSGene;
import jp.jurassicsaga.server.base.generic.gene.JSGenetics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;

public class JSGeneDataHolder {
    protected final List<JSGene> GENE_SET = new ArrayList<JSGene>();

    public void loadFromNbt(CompoundTag nbt) {
        String geneString;
        int size = nbt.getInt("js.genetic_data.size");
        for (int i = 1; i <= size && !(geneString = nbt.getString("js.genetic_data." + i)).isEmpty(); ++i) {
            JSGene gene = JSGenetics.getGene(ResourceLocation.bySeparator((String)geneString, (char)':'));
            this.GENE_SET.add(gene);
        }
    }

    public void saveToNbt(CompoundTag nbt) {
        int curId = 0;
        for (JSGene jsGene : this.GENE_SET) {
            nbt.putString("js.genetic_data." + ++curId, jsGene.getRegisteredLocation().toString());
        }
        nbt.putInt("js.genetic_data.size", curId);
    }

    public List<JSGene> getGENE_SET() {
        return this.GENE_SET;
    }
}

