/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.generic.networking.obj;

import io.netty.buffer.ByteBuf;
import jp.jurassicsaga.JSCommon;
import jp.jurassicsaga.server.base.entity.obj.other.PaddockSignEntity;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import travelers.server.packet.TravelersPacketsHandler;
import travelers.util.helper.PlatformHelper;

public record UpdatePaddockSign(ResourceLocation registryName, String animal, int entityId) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<UpdatePaddockSign> TYPE = new CustomPacketPayload.Type(JSCommon.createId("paddock_sign"));
    public static final StreamCodec<ByteBuf, UpdatePaddockSign> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, UpdatePaddockSign::registryName, (StreamCodec)ByteBufCodecs.STRING_UTF8, UpdatePaddockSign::animal, (StreamCodec)ByteBufCodecs.INT, UpdatePaddockSign::entityId, UpdatePaddockSign::new);

    public static TravelersPacketsHandler<UpdatePaddockSign> createHandler() {
        return new TravelersPacketsHandler<UpdatePaddockSign>(){

            public void serverPacket(CustomPacketPayload packet) {
                UpdatePaddockSign updatePaddockSign = (UpdatePaddockSign)packet;
                ResourceKey type = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)updatePaddockSign.registryName());
                try {
                    Entity entity;
                    ServerLevel level = PlatformHelper.properties.getServer().getLevel(type);
                    if (level != null && (entity = level.getEntity(updatePaddockSign.entityId)) instanceof PaddockSignEntity) {
                        PaddockSignEntity e = (PaddockSignEntity)entity;
                        e.setAnimal(updatePaddockSign.animal);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

