/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.item;

import com.google.common.base.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.util.ExtraCodecs;
import travelers.util.helper.TravelersRegistry;

public class JSDataComponents {
    public static final TravelersRegistry<DataComponentType<?>> DATA_COMPONENTS = new TravelersRegistry(BuiltInRegistries.DATA_COMPONENT_TYPE, "jurassicsaga");
    public static final Supplier<DataComponentType<Integer>> SPAWN_TYPE = JSDataComponents.registerComponentType("spawnegg_type", builder -> builder.persistent(ExtraCodecs.intRange((int)0, (int)3)).networkSynchronized(ByteBufCodecs.VAR_INT).cacheEncoding());
    public static final Supplier<DataComponentType<Integer>> DNA_QUALITY = JSDataComponents.registerComponentType("dna_quality", builder -> builder.persistent(ExtraCodecs.NON_NEGATIVE_INT).networkSynchronized(ByteBufCodecs.INT).cacheEncoding());
    public static final Supplier<DataComponentType<String>> VARIANT = JSDataComponents.registerComponentType("variant", builder -> builder.persistent(ExtraCodecs.NON_EMPTY_STRING).networkSynchronized(ByteBufCodecs.STRING_UTF8).cacheEncoding());
    public static final Supplier<DataComponentType<String>> SPECIES_NAME = JSDataComponents.registerComponentType("entity_name", builder -> builder.persistent(ExtraCodecs.NON_EMPTY_STRING).networkSynchronized(ByteBufCodecs.STRING_UTF8).cacheEncoding());
    public static final Supplier<DataComponentType<Integer>> FULL_CONTAINER = JSDataComponents.registerComponentType("container_full", builder -> builder.persistent(ExtraCodecs.NON_NEGATIVE_INT).networkSynchronized(ByteBufCodecs.INT).cacheEncoding());
    public static final Supplier<DataComponentType<CompoundTag>> GENE_DATA = JSDataComponents.registerComponentType("gene_id_1", builder -> builder.persistent(CompoundTag.CODEC).networkSynchronized(ByteBufCodecs.COMPOUND_TAG).cacheEncoding());
    public static final Supplier<DataComponentType<Integer>> GENE_EXTRACTOR_TRIES = JSDataComponents.registerComponentType("gene_extractor_tries", builder -> builder.persistent(ExtraCodecs.NON_NEGATIVE_INT).networkSynchronized(ByteBufCodecs.INT).cacheEncoding());

    public static void init() {
    }

    public static <D> Supplier<DataComponentType<D>> registerComponentType(String name, UnaryOperator<DataComponentType.Builder<D>> builder) {
        Supplier data = DATA_COMPONENTS.register(name, () -> ((DataComponentType.Builder)builder.apply(DataComponentType.builder())).build());
        return () -> (DataComponentType)data.get();
    }
}

