/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.item.obj.egg;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.function.Supplier;
import jp.jurassicsaga.JSCommon;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalGrowthStage;
import jp.jurassicsaga.server.base.animal.obj.JSAnimal;
import jp.jurassicsaga.server.base.generic.gene.JSGene;
import jp.jurassicsaga.server.base.generic.gene.JSGeneUtil;
import jp.jurassicsaga.server.base.generic.gene.obj.JSGeneData;
import jp.jurassicsaga.server.base.generic.obj.AnimalAttachment;
import jp.jurassicsaga.server.base.item.JSDataComponents;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import travelers.client.TravelersClient;

public class GenderSpawnEgg
extends SpawnEggItem
implements AnimalAttachment {
    private static final List<GenderSpawnEgg> MOD_EGGS = new ArrayList<GenderSpawnEgg>();
    private static final DispenseItemBehavior DEFAULT_DISPENSE_BEHAVIOR = (source, stack) -> {
        Direction face = (Direction)source.state().getValue((Property)DispenserBlock.FACING);
        EntityType type = ((SpawnEggItem)stack.getItem()).getType(stack);
        try {
            Entity base = type.spawn(source.level(), stack, null, source.pos().relative(face), MobSpawnType.DISPENSER, face != Direction.UP, false);
            if (base instanceof JSAnimalBase) {
                JSAnimalBase entity = (JSAnimalBase)base;
                Item patt0$temp = stack.getItem();
                if (patt0$temp instanceof GenderSpawnEgg) {
                    GenderSpawnEgg spawnEgg = (GenderSpawnEgg)patt0$temp;
                    Object id = stack.get((DataComponentType)JSDataComponents.SPAWN_TYPE.get());
                    int integer = SpawnEggMode.BOTH.id;
                    if (id != null) {
                        if (id instanceof Integer) {
                            Integer integer1 = (Integer)id;
                            integer = integer1;
                        }
                    } else {
                        stack.set((DataComponentType)JSDataComponents.SPAWN_TYPE.get(), (Object)SpawnEggMode.BOTH.id);
                    }
                    SpawnEggMode mode = SpawnEggMode.getMode(integer);
                    if (mode != SpawnEggMode.BOTH) {
                        entity.getModules().getGeneticModule().setMale(mode == SpawnEggMode.MALE);
                    } else {
                        entity.getModules().getGeneticModule().setMale(entity.getRandom().nextBoolean());
                    }
                    entity.getModules().getGrowthStageModule().setMax();
                    entity.getModules().getMetabolismModule().setMax();
                    JSGeneData data = JSGeneUtil.readFromStack(stack);
                    data.setDataOwnerName(spawnEgg.animal.getAnimalAttributes().getModId() + ":" + spawnEgg.animal.getAnimalAttributes().getAnimalName());
                    entity.getModules().getGeneticModule().setGeneData(data);
                    entity.getModules().getGeneticModule().hatch();
                }
            }
        }
        catch (Exception exception) {
            DispenseItemBehavior.LOGGER.error("Error while dispensing spawn egg from dispenser at {}", (Object)source.pos(), (Object)exception);
            return ItemStack.EMPTY;
        }
        stack.shrink(1);
        source.level().gameEvent((Holder)GameEvent.ENTITY_PLACE, source.pos(), GameEvent.Context.of((BlockState)source.state()));
        return stack;
    };
    private final Supplier<? extends EntityType<? extends JSAnimalBase>> typeSupplier;
    public final int backGroundColorMale;
    public final int highlightColorMale;
    public final int backgroundColorFemale;
    public final int highlightColorFemale;
    private final JSAnimal<?> animal;

    public GenderSpawnEgg(JSAnimal<?> animal, Supplier<? extends EntityType<? extends JSAnimalBase>> type, int backgroundColor, int highlightColor, int backGroundColorMale, int highlightColorMale, Item.Properties props) {
        super(type.get(), backgroundColor, highlightColor, props);
        this.typeSupplier = type;
        this.backgroundColorFemale = backgroundColor;
        this.highlightColorFemale = highlightColor;
        this.backGroundColorMale = backGroundColorMale;
        this.highlightColorMale = highlightColorMale;
        this.animal = animal;
        MOD_EGGS.add(this);
    }

    public static SpawnEggMode getSpawnEggMode(Object id) {
        SpawnEggMode curMode;
        int integer = SpawnEggMode.BOTH.id;
        if (id != null && id instanceof Integer) {
            Integer integer1 = (Integer)id;
            integer = integer1;
        }
        SpawnEggMode mode = curMode = SpawnEggMode.getMode(integer);
        if (curMode == SpawnEggMode.BOTH) {
            mode = TravelersClient.clientTicks % 64 > 32 ? SpawnEggMode.MALE : SpawnEggMode.FEMALE;
        }
        return mode;
    }

    private static void showTitle(ServerPlayer serverPlayer, SpawnEggMode mode) {
        MutableComponent textComponent = Component.translatable((String)mode.getTranslationKey()).withStyle(ChatFormatting.GOLD);
        ClientboundSetActionBarTextPacket actionBarPacket = new ClientboundSetActionBarTextPacket((Component)textComponent);
        serverPlayer.connection.send((Packet)actionBarPacket);
    }

    public static void registerDispense() {
        for (GenderSpawnEgg modEgg : MOD_EGGS) {
            DispenseItemBehavior dispenseBehavior = modEgg.createDispenseBehavior();
            if (dispenseBehavior == null) continue;
            DispenserBlock.registerBehavior((ItemLike)modEgg, (DispenseItemBehavior)dispenseBehavior);
        }
    }

    @NotNull
    public ItemStack getDefaultInstance() {
        ItemStack stack = super.getDefaultInstance();
        stack.set((DataComponentType)JSDataComponents.SPAWN_TYPE.get(), (Object)SpawnEggMode.BOTH.id);
        JSGeneData genes = this.animal.getAnimalAttributes().getGeneticProperties().getSpawnGenetics();
        genes.setBaseQuality(100);
        return JSGeneUtil.writeToStack(stack, genes);
    }

    @NotNull
    public ItemStack getDefaultInstanceNoData() {
        ItemStack stack = super.getDefaultInstance();
        stack.set((DataComponentType)JSDataComponents.SPAWN_TYPE.get(), (Object)SpawnEggMode.BOTH.id);
        return stack;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.jurassicsaga.version").append(String.valueOf(this.animal.getAnimalAttributes().getMiscProperties().getVersion())).withStyle(ChatFormatting.DARK_GRAY));
        if (stack.isEmpty()) {
            return;
        }
        JSGeneData data = JSGeneUtil.readFromStack(stack);
        if (data.geneDataHolder.getGENE_SET().isEmpty()) {
            return;
        }
        if (!JSCommon.isShiftKeyDown && !tooltipFlag.isAdvanced()) {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.jurassicsaga.shift_hint").withStyle(ChatFormatting.BLUE));
        } else if (!data.geneDataHolder.getGENE_SET().isEmpty()) {
            tooltipComponents.add((Component)Component.literal((String)"Genes:"));
            int geneId = 0;
            for (JSGene gene : data.geneDataHolder.getGENE_SET()) {
                tooltipComponents.add((Component)Component.literal((String)(++geneId + ". ")).append((Component)gene.getTranslatableObject()).withStyle(gene.getToolTipColour()));
            }
        }
    }

    @NotNull
    public InteractionResult useOn(UseOnContext pContext) {
        Level level = pContext.getLevel();
        if (!(level instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        ItemStack itemstack = pContext.getItemInHand();
        BlockPos blockpos = pContext.getClickedPos();
        Direction direction = pContext.getClickedFace();
        BlockState blockstate = level.getBlockState(blockpos);
        Player player = pContext.getPlayer();
        if (player == null) {
            return InteractionResult.PASS;
        }
        BlockPos blockpos1 = blockstate.getCollisionShape((BlockGetter)level, blockpos).isEmpty() ? blockpos : blockpos.relative(direction);
        EntityType entitytype = this.getType(itemstack);
        JSAnimalBase entity = (JSAnimalBase)entitytype.spawn((ServerLevel)level, itemstack, pContext.getPlayer(), blockpos1, MobSpawnType.SPAWN_EGG, true, !Objects.equals(blockpos, blockpos1) && direction == Direction.UP);
        if (entity != null) {
            Object id = itemstack.get((DataComponentType)JSDataComponents.SPAWN_TYPE.get());
            int integer = SpawnEggMode.BOTH.id;
            if (id != null) {
                if (id instanceof Integer) {
                    Integer integer1 = (Integer)id;
                    integer = integer1;
                }
            } else {
                itemstack.set((DataComponentType)JSDataComponents.SPAWN_TYPE.get(), (Object)SpawnEggMode.BOTH.id);
            }
            SpawnEggMode mode = SpawnEggMode.getMode(integer);
            if (mode != SpawnEggMode.BOTH) {
                entity.getModules().getGeneticModule().setMale(mode == SpawnEggMode.MALE);
            } else {
                entity.getModules().getGeneticModule().setMale(entity.getRandom().nextBoolean());
            }
            if (player.isShiftKeyDown()) {
                entity.getModules().getGrowthStageModule().setGrowthStage(AnimalGrowthStage.BABY);
                entity.getModules().getGrowthStageModule().setGrowthProgress(0);
            } else {
                entity.getModules().getGrowthStageModule().setMax();
            }
            entity.getModules().getMetabolismModule().setMax();
            JSGeneData data = JSGeneUtil.readFromStack(itemstack);
            data.setDataOwnerName(this.animal.getAnimalAttributes().getModId() + ":" + this.animal.getAnimalAttributes().getAnimalName());
            entity.getModules().getGeneticModule().setGeneData(data);
            entity.getModules().getGeneticModule().hatch();
            itemstack.shrink(1);
            level.gameEvent((Entity)pContext.getPlayer(), (Holder)GameEvent.ENTITY_PLACE, blockpos);
        }
        return InteractionResult.CONSUME;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level pLevel, Player pPlayer, @NotNull InteractionHand pHand) {
        ItemStack itemstack = pPlayer.getItemInHand(pHand);
        BlockHitResult blockhitresult = GenderSpawnEgg.getPlayerPOVHitResult((Level)pLevel, (Player)pPlayer, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (pPlayer.isShiftKeyDown() && blockhitresult.getType() != HitResult.Type.BLOCK) {
            if (!pLevel.isClientSide()) {
                Object id = itemstack.get((DataComponentType)JSDataComponents.SPAWN_TYPE.get());
                int integer = SpawnEggMode.BOTH.id;
                if (id != null && id instanceof Integer) {
                    Integer integer1 = (Integer)id;
                    integer = integer1;
                }
                SpawnEggMode mode = SpawnEggMode.getMode(integer);
                itemstack.set((DataComponentType)JSDataComponents.SPAWN_TYPE.get(), (Object)SpawnEggMode.nextMode((SpawnEggMode)mode).id);
                if (pPlayer instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)pPlayer;
                    GenderSpawnEgg.showTitle(serverPlayer, SpawnEggMode.nextMode(mode));
                }
            }
            return InteractionResultHolder.pass((Object)itemstack);
        }
        if (blockhitresult.getType() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.pass((Object)itemstack);
        }
        if (!(pLevel instanceof ServerLevel)) {
            return InteractionResultHolder.success((Object)itemstack);
        }
        BlockPos blockpos = blockhitresult.getBlockPos();
        if (!(pLevel.getBlockState(blockpos).getBlock() instanceof LiquidBlock)) {
            return InteractionResultHolder.pass((Object)itemstack);
        }
        if (pLevel.mayInteract(pPlayer, blockpos) && pPlayer.mayUseItemAt(blockpos, blockhitresult.getDirection(), itemstack)) {
            EntityType entitytype = this.getType(itemstack);
            JSAnimalBase entity = (JSAnimalBase)entitytype.spawn((ServerLevel)pLevel, itemstack, pPlayer, blockpos, MobSpawnType.SPAWN_EGG, false, false);
            if (entity == null) {
                return InteractionResultHolder.pass((Object)itemstack);
            }
            Object id = itemstack.get((DataComponentType)JSDataComponents.SPAWN_TYPE.get());
            int integer = SpawnEggMode.BOTH.id;
            if (id != null) {
                if (id instanceof Integer) {
                    Integer integer1 = (Integer)id;
                    integer = integer1;
                }
            } else {
                itemstack.set((DataComponentType)JSDataComponents.SPAWN_TYPE.get(), (Object)SpawnEggMode.BOTH.id);
            }
            SpawnEggMode mode = SpawnEggMode.getMode(integer);
            if (mode != SpawnEggMode.BOTH) {
                entity.getModules().getGeneticModule().setMale(mode == SpawnEggMode.MALE);
            } else {
                entity.getModules().getGeneticModule().setMale(entity.getRandom().nextBoolean());
            }
            if (pPlayer.isShiftKeyDown()) {
                entity.getModules().getGrowthStageModule().setGrowthStage(AnimalGrowthStage.BABY);
                entity.getModules().getGrowthStageModule().setGrowthProgress(0);
            } else {
                entity.getModules().getGrowthStageModule().setMax();
            }
            entity.getModules().getMetabolismModule().setMax();
            JSGeneData data = JSGeneUtil.readFromStack(itemstack);
            data.setDataOwnerName(this.animal.getAnimalAttributes().getModId() + ":" + this.animal.getAnimalAttributes().getAnimalName());
            entity.getModules().getGeneticModule().setGeneData(data);
            entity.getModules().getGeneticModule().hatch();
            itemstack.consume(1, (LivingEntity)pPlayer);
            pPlayer.awardStat(Stats.ITEM_USED.get((Object)this));
            pLevel.gameEvent((Entity)pPlayer, (Holder)GameEvent.ENTITY_PLACE, entity.position());
            return InteractionResultHolder.consume((Object)itemstack);
        }
        return InteractionResultHolder.fail((Object)itemstack);
    }

    @Nullable
    protected DispenseItemBehavior createDispenseBehavior() {
        return DEFAULT_DISPENSE_BEHAVIOR;
    }

    @Override
    public JSAnimal<?> getAnimal() {
        return this.animal;
    }

    public static List<GenderSpawnEgg> getMOD_EGGS() {
        return MOD_EGGS;
    }

    public static enum SpawnEggMode {
        BOTH(0, "tooltip.jurassicsaga.genderspawnegg.both"),
        MALE(1, "tooltip.jurassicsaga.genderspawnegg.male"),
        FEMALE(2, "tooltip.jurassicsaga.genderspawnegg.female");

        private static final Random random;
        private final int id;
        private final String translationKey;

        private SpawnEggMode(int id, String translationKey) {
            this.id = id;
            this.translationKey = translationKey;
        }

        public static SpawnEggMode nextMode(SpawnEggMode currentMode) {
            switch (currentMode.ordinal()) {
                case 1: {
                    return FEMALE;
                }
                case 0: {
                    return MALE;
                }
            }
            return BOTH;
        }

        public static SpawnEggMode getMode(int mode) {
            for (SpawnEggMode value : SpawnEggMode.values()) {
                if (value.id != mode) continue;
                return value;
            }
            return BOTH;
        }

        public int getId() {
            return this.id;
        }

        public String getTranslationKey() {
            return this.translationKey;
        }

        static {
            random = new Random();
        }
    }
}

