/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.item.obj.genetics;

import java.util.List;
import java.util.Locale;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.generic.gene.JSGeneUtil;
import jp.jurassicsaga.server.base.generic.gene.JSGenetics;
import jp.jurassicsaga.server.base.generic.gene.obj.JSGeneData;
import jp.jurassicsaga.server.base.generic.gene.obj.JSPlantData;
import jp.jurassicsaga.server.base.generic.obj.SampleColour;
import jp.jurassicsaga.server.base.item.JSDataComponents;
import jp.jurassicsaga.server.base.item.obj.JSItemExtension;
import jp.jurassicsaga.server.base.item.obj.genetics.GeneticsItem;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomModelData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class SyringeItem
extends GeneticsItem
implements JSItemExtension {
    public SyringeItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public ItemStack getDefaultInstance() {
        ItemStack stack = super.getDefaultInstance();
        stack.set((DataComponentType)JSDataComponents.FULL_CONTAINER.get(), (Object)0);
        stack.set(DataComponents.CUSTOM_MODEL_DATA, (Object)SampleColour.EMPTY.model());
        return stack;
    }

    @Override
    public void appendHoverText(ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        boolean empty = (Integer)stack.getOrDefault((DataComponentType)JSDataComponents.FULL_CONTAINER.get(), (Object)0) == 0 && ((CustomModelData)stack.getOrDefault(DataComponents.CUSTOM_MODEL_DATA, (Object)new CustomModelData(0))).value() == 0;
        boolean dirty = ((CustomModelData)stack.getOrDefault(DataComponents.CUSTOM_MODEL_DATA, (Object)new CustomModelData(0))).value() == SampleColour.DIRTY.ordinal();
        boolean hasNone = ((String)stack.getOrDefault((DataComponentType)JSDataComponents.SPECIES_NAME.get(), (Object)"none")).equals("none");
        if (dirty) {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.jurassicsaga.syringe_clean_hint").withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.ITALIC));
        } else if (empty || hasNone) {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.jurassicsaga.syringe_use_hint").withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.ITALIC));
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.jurassicsaga.syringe_analyze_hint").withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.ITALIC));
        }
    }

    @NotNull
    public String getDescriptionId(ItemStack stack) {
        CustomModelData md = (CustomModelData)stack.getOrDefault(DataComponents.CUSTOM_MODEL_DATA, (Object)new CustomModelData(0));
        boolean dirty = ((CustomModelData)stack.getOrDefault(DataComponents.CUSTOM_MODEL_DATA, (Object)new CustomModelData(0))).value() == SampleColour.DIRTY.ordinal();
        boolean hasNone = ((String)stack.getOrDefault((DataComponentType)JSDataComponents.SPECIES_NAME.get(), (Object)"")).isEmpty();
        if (dirty) {
            return "item.jurassicsaga." + String.valueOf((Object)SampleColour.DIRTY) + "_syringe";
        }
        if (hasNone) {
            return "item.jurassicsaga." + String.valueOf((Object)SampleColour.EMPTY) + "_syringe";
        }
        return "item.jurassicsaga." + String.valueOf((Object)SampleColour.RED) + "_syringe";
    }

    @NotNull
    public InteractionResult interactLivingEntity(@NotNull ItemStack stack, @NotNull Player player, @NotNull LivingEntity interactionTarget, @NotNull InteractionHand usedHand) {
        if (!player.level().isClientSide && interactionTarget.isAlive()) {
            JSAnimalBase animal;
            boolean empty;
            ItemStack syringe = new ItemStack((ItemLike)this, 1);
            boolean bl = empty = (Integer)stack.getOrDefault((DataComponentType)JSDataComponents.FULL_CONTAINER.get(), (Object)0) == 0 && ((CustomModelData)stack.getOrDefault(DataComponents.CUSTOM_MODEL_DATA, (Object)new CustomModelData(0))).value() == 0;
            if (!empty) {
                return InteractionResult.FAIL;
            }
            if (interactionTarget instanceof JSAnimalBase && (animal = (JSAnimalBase)interactionTarget).getAnimal().getItems().getCoin() != null) {
                JSGeneData data = animal.getModules().getGeneticModule().getGeneData();
                JSGeneUtil.writeToStack(syringe, data);
                syringe.set((DataComponentType)JSDataComponents.FULL_CONTAINER.get(), (Object)1);
                syringe.set(DataComponents.CUSTOM_MODEL_DATA, (Object)animal.getAnimal().getAnimalAttributes().getItemProperties().getSampleColour().model());
                syringe.set((DataComponentType)JSDataComponents.SPECIES_NAME.get(), (Object)(animal.getAnimal().getAnimalAttributes().getModId() + ":" + animal.getAnimal().getAnimalAttributes().getAnimalName().toLowerCase(Locale.ROOT)));
                player.getInventory().add(syringe);
                stack.shrink(1);
                return InteractionResult.sidedSuccess((boolean)player.level().isClientSide);
            }
            if (JSGenetics.ENTITY_DEFAULT_GENE_DATA.containsKey(interactionTarget.getType())) {
                JSGeneData data = JSGenetics.ENTITY_DEFAULT_GENE_DATA.get(interactionTarget.getType()).geneData();
                JSGeneUtil.writeToStack(syringe, data);
                syringe.set((DataComponentType)JSDataComponents.FULL_CONTAINER.get(), (Object)1);
                syringe.set(DataComponents.CUSTOM_MODEL_DATA, (Object)SampleColour.RED.model());
                ResourceLocation key = BuiltInRegistries.ENTITY_TYPE.getKey((Object)interactionTarget.getType());
                syringe.set((DataComponentType)JSDataComponents.SPECIES_NAME.get(), (Object)(key.getNamespace() + ":" + key.getPath()));
                player.getInventory().add(syringe);
                stack.shrink(1);
                return InteractionResult.sidedSuccess((boolean)player.level().isClientSide);
            }
        }
        return InteractionResult.PASS;
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockPos pos = context.getClickedPos();
        BlockState state = context.getLevel().getBlockState(pos);
        ResourceLocation name = BuiltInRegistries.BLOCK.getKey((Object)state.getBlock());
        JSPlantData data = JSGenetics.PLANT_GENETIC_INFORMATION.get(name.getPath());
        if (data != null) {
            ItemStack syringe = new ItemStack((ItemLike)this, 1);
            syringe.set((DataComponentType)JSDataComponents.FULL_CONTAINER.get(), (Object)1);
            syringe.set(DataComponents.CUSTOM_MODEL_DATA, (Object)SampleColour.PLANT.model());
            syringe.set((DataComponentType)JSDataComponents.SPECIES_NAME.get(), (Object)name.toString());
            if (context.getPlayer() != null) {
                context.getPlayer().getInventory().add(syringe);
                context.getItemInHand().shrink(1);
            }
            return InteractionResult.SUCCESS_NO_ITEM_USED;
        }
        return super.useOn(context);
    }

    @Override
    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        if (!stack.isEmpty() && ((Integer)stack.getOrDefault((DataComponentType)JSDataComponents.FULL_CONTAINER.get(), (Object)0) == 1 || ((CustomModelData)stack.getOrDefault(DataComponents.CUSTOM_MODEL_DATA, (Object)new CustomModelData(0))).value() == 1) && entity.isInWater()) {
            stack.remove((DataComponentType)JSDataComponents.DNA_QUALITY.get());
            stack.remove((DataComponentType)JSDataComponents.SPECIES_NAME.get());
            stack.remove((DataComponentType)JSDataComponents.FULL_CONTAINER.get());
            stack.remove(DataComponents.CUSTOM_MODEL_DATA);
        }
        return false;
    }
}

