/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.animal.animations.extinct.aquatic;

import jp.jurassicsaga.server.base.animal.animals.JSAnimations;
import jp.jurassicsaga.server.base.animal.animations.JSAnimator;
import jp.jurassicsaga.server.v1.animal.entity.extinct.aquatic.TylosaurusEntity;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.other.TravelersAnimalAnimationModule;
import travelers.server.animal.obj.TravelersMoveAnalysis;

public class TylosaurusAnimations
extends JSAnimator<TylosaurusEntity> {
    @Override
    public void animate(TylosaurusEntity base, TravelersMoveAnalysis moveAnalysis, TravelersAnimalAnimationModule animationManager) {
        if (base.isDead()) {
            if (base.isInWater()) {
                JSAnimations.DEATH.sendForEntity((SmartAnimalBase)base);
            } else {
                JSAnimations.ON_LAND_DEATH.sendForEntity((SmartAnimalBase)base);
            }
            return;
        }
        if (animationManager.playTransition(base.isLeaping(), JSAnimations.JUMP_START.wrap(13), JSAnimations.JUMP_LOOP.wrap(), JSAnimations.JUMP_END.wrap(26))) {
            return;
        }
        if (base.isInWater()) {
            if (base.getDeltaMovement().horizontalDistanceSqr() > 0.0) {
                if (base.isRunning()) {
                    JSAnimations.SWIM_FAST.sendForEntity((SmartAnimalBase)base);
                } else {
                    JSAnimations.SWIM.sendForEntity((SmartAnimalBase)base);
                }
            } else {
                JSAnimations.IDLE.sendForEntity((SmartAnimalBase)base);
            }
        } else {
            JSAnimations.BEACHED.sendForEntity((SmartAnimalBase)base);
        }
    }

    @Override
    public void animateServer(TylosaurusEntity base, TravelersMoveAnalysis moveAnalysis, TravelersAnimalAnimationModule animationManager) {
        if (base.isDead()) {
            return;
        }
        if (base.curEatTicks > 0) {
            JSAnimations.ATTACK.sendForEntity((SmartAnimalBase)base);
            return;
        }
        if (base.curInjuredTicks > 0) {
            JSAnimations.INJURED.sendForEntity((SmartAnimalBase)base);
            return;
        }
        if (base.curAttackTicks > 0) {
            JSAnimations.ATTACK.sendForEntity((SmartAnimalBase)base);
            return;
        }
    }
}

