/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.animal.animations.extinct.avian;

import jp.jurassicsaga.server.base.animal.animals.JSAnimations;
import jp.jurassicsaga.server.base.animal.animations.JSAnimator;
import jp.jurassicsaga.server.v1.animal.entity.extinct.avian.CearadactylusEntity;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.other.TravelersAnimalAnimationModule;
import travelers.server.animal.obj.TravelersMoveAnalysis;

public class CearadactylusAnimations
extends JSAnimator<CearadactylusEntity> {
    @Override
    public void animate(CearadactylusEntity base, TravelersMoveAnalysis moveAnalysis, TravelersAnimalAnimationModule animationManager) {
        if (base.isDead()) {
            if (base.onGround()) {
                JSAnimations.DEATH.sendForEntity((SmartAnimalBase)base);
            } else {
                animationManager.playTransition(!base.onGround(), false, JSAnimations.FALL.wrap(21), JSAnimations.FALL_LOOP.wrap(), JSAnimations.DEATH.wrap(1));
            }
            return;
        }
        if (!base.onGround()) {
            if (base.isDiving()) {
                JSAnimations.DIVE.sendForEntity((SmartAnimalBase)base);
                return;
            }
            JSAnimations.FLYING.sendForEntity((SmartAnimalBase)base);
        } else {
            if (base.isSleeping() || base.isResting()) {
                return;
            }
            if (this.isMoving(moveAnalysis)) {
                JSAnimations.WALK.sendForEntity((SmartAnimalBase)base);
            } else {
                JSAnimations.IDLE.sendForEntity((SmartAnimalBase)base);
            }
        }
    }

    @Override
    public void animateServer(CearadactylusEntity base, TravelersMoveAnalysis moveAnalysis, TravelersAnimalAnimationModule animationManager) {
        if (base.isDead() && base.isFlying()) {
            return;
        }
        if (animationManager.playTransition(base.isSleeping(), true, JSAnimations.SLEEP_IN.wrap(63), JSAnimations.SLEEP_LOOP.wrap(), JSAnimations.SLEEP_OUT.wrap(39))) {
            return;
        }
        if (animationManager.playTransition(base.isResting(), true, JSAnimations.REST_IN.wrap(36), JSAnimations.REST_LOOP.wrap(), JSAnimations.REST_OUT.wrap(19))) {
            return;
        }
        if (base.curEatTicks > 0) {
            JSAnimations.EAT.sendForEntity((SmartAnimalBase)base);
            return;
        }
        if (base.curDrinkTicks > 0) {
            JSAnimations.DRINK.sendForEntity((SmartAnimalBase)base);
            return;
        }
        if (base.curInjuredTicks > 0) {
            JSAnimations.INJURED.sendForEntity((SmartAnimalBase)base);
            return;
        }
        if (base.curAttackTicks > 0) {
            JSAnimations.ATTACK.sendForEntity((SmartAnimalBase)base);
            return;
        }
    }
}

