/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.animal.entity.extinct.avian;

import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAvianBase;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalGrowthStage;
import jp.jurassicsaga.server.base.animal.entity.obj.nav.JSAquaticNavigation;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat.JSCombatFollowTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat.JSTargetTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.navigation.JSFleeTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.navigation.JSRandomStrollTask;
import jp.jurassicsaga.server.v1.animal.entity.obj.task.MeganeuraFloatTask;
import jp.jurassicsaga.server.v1.animal.entity.obj.task.MeganeuraFoodTask;
import jp.jurassicsaga.server.v1.sound.JSV1Sounds;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.pathingsystem.TravelersPath;
import travelers.server.animal.entity.pathingsystem.control.TravelersSmoothSwimMoveControl;
import travelers.server.animal.entity.pathingsystem.navigation.TravelersPathNavigation;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersPathType;
import travelers.server.animal.entity.task.TravelerTaskBase;
import travelers.server.animal.entity.task.TravelerTaskController;

public class MeganeuraEntity
extends JSAvianBase {
    private JSAquaticNavigation aquaticNavigation;
    private TravelersSmoothSwimMoveControl aquaticControl;

    public MeganeuraEntity(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
        this.setPathfindingMalus(TravelersPathType.WATER, -1.0f);
        this.setPathfindingMalus(TravelersPathType.WATER_BORDER, 0.0f);
    }

    protected void addTasksToController(TravelerTaskController controller, TravelerTaskController combatTargeting) {
        controller.registerTask((TravelerTaskBase)new JSFleeTask(this, 20));
        controller.registerTask((TravelerTaskBase)new JSFleeTask(this, 30));
        controller.registerTask((TravelerTaskBase)new JSRandomStrollTask(this));
        controller.registerTask((TravelerTaskBase)new MeganeuraFloatTask(this));
        controller.registerTask((TravelerTaskBase)new MeganeuraFoodTask(this));
        controller.registerTask((TravelerTaskBase)new JSCombatFollowTask(this));
        combatTargeting.registerTask((TravelerTaskBase)new JSTargetTask(this, false));
    }

    @Override
    public int getDistanceOfGround() {
        return 5;
    }

    @Override
    public void travel(@NotNull Vec3 travelVector) {
        if (this.isInWater() && this.getModules().getGrowthStageModule().getGrowthStage() != AnimalGrowthStage.ADULT) {
            if (!this.level().isClientSide && this.isInWater()) {
                this.moveRelative(this.getSpeed(), travelVector);
                this.move(MoverType.SELF, this.getDeltaMovement());
                this.setDeltaMovement(this.getDeltaMovement().scale(0.6));
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.005, 0.0));
            } else {
                super.travel(travelVector);
            }
            return;
        }
        super.travel(travelVector);
    }

    @Override
    public void onGrowthStageChange(AnimalGrowthStage newStage) {
        if (newStage == AnimalGrowthStage.ADULT) {
            this.setPathfindingMalus(TravelersPathType.WATER, -1.0f);
        }
        super.onGrowthStageChange(newStage);
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        if (this.isFlying() && !this.isBaby()) {
            return (SoundEvent)JSV1Sounds.MEGANEURA_FLIGHT_LOOP.get();
        }
        return null;
    }

    public int getAirSupply() {
        return this.getModules().getGrowthStageModule().getGrowthStage() == AnimalGrowthStage.ADULT ? super.getAirSupply() : this.getMaxAirSupply();
    }

    @Override
    public boolean shouldSleep() {
        return false;
    }

    public boolean isPushedByFluid() {
        return this.isDead() && this.getModules().getGrowthStageModule().getGrowthStage() != AnimalGrowthStage.ADULT;
    }

    @Override
    public boolean disableFlyTransitions() {
        return this.getModules().getGrowthStageModule().getGrowthStage() == AnimalGrowthStage.BABY;
    }

    @Override
    public void aiStep() {
        super.aiStep();
        if (this.getModules().getGrowthStageModule().getGrowthStage() != AnimalGrowthStage.ADULT) {
            if ((double)this.getPathfindingMalus(TravelersPathType.WATER) != 0.0) {
                this.setPathfindingMalus(TravelersPathType.WATER, 0.0f);
            }
            if (this.aquaticNavigation == null) {
                this.aquaticNavigation = new JSAquaticNavigation(this, this.level(), false);
            }
            if (this.navigationController != this.aquaticNavigation) {
                this.entityData.set(FLYING, (Object)false);
                this.navigationController = this.aquaticNavigation;
            }
            if (this.aquaticControl == null) {
                this.aquaticControl = new TravelersSmoothSwimMoveControl((SmartAnimalBase)this, 85.0f, 10.0f, 0.02f, 0.1f, true);
            }
            if (this.moveController != this.aquaticControl) {
                this.moveController = this.aquaticControl;
            }
        } else if (this.aquaticNavigation != null || this.aquaticControl != null) {
            this.aquaticNavigation = null;
            this.aquaticControl = null;
            this.moveController = this.flyingMoveControl;
            this.navigationController = this.getFlyingPathNavigation();
        } else {
            if (this.getPathfindingMalus(TravelersPathType.WATER) != -1.0f) {
                this.setPathfindingMalus(TravelersPathType.WATER, -1.0f);
            }
            if (this.onGround() && this.random.nextFloat() > 0.887f) {
                this.stamina = 1.0f;
            }
        }
        if (!this.level().isClientSide) {
            if (!this.isEyeInFluid(FluidTags.WATER)) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.0225, 0.0));
            }
            TravelersPathNavigation navigator = this.getNavigationController();
            TravelersPath path = navigator.getPath();
            if (this.isInLiquid() || this.isInWater() || this.wasEyeInWater) {
                if (this.checkForCollide()) {
                    this.setDeltaMovement(this.getDeltaMovement().add(0.0, 0.0225, 0.0));
                }
                if (path != null && !path.isDone()) {
                    BlockPos nextPos = path.getNextNodePos();
                    if (navigator.isStuck()) {
                        navigator.stop();
                    }
                    int y = nextPos.getY();
                    int difference = y - this.getBlockY();
                    if (y > this.getBlockY()) {
                        this.setDeltaMovement(this.getDeltaMovement().add(0.0, difference > 1 ? this.getUpLift() * 2.0 : this.getUpLift(), 0.0));
                    } else if (y < this.getBlockY()) {
                        this.setDeltaMovement(this.getDeltaMovement().add(0.0, difference > -1 ? -this.getUpLift() * 2.0 : -this.getUpLift(), 0.0));
                    }
                    this.getLookControl().setLookAt(nextPos.getCenter());
                }
            }
        }
    }

    @Override
    protected boolean hoversInPlace() {
        return true;
    }

    protected float getWaterSlowDown() {
        return this.getModules().getGrowthStageModule().getGrowthStage() != AnimalGrowthStage.ADULT ? 0.1f : 0.8f;
    }

    private double getUpLift() {
        return 0.02;
    }

    @Override
    protected void playStepSound(@NotNull BlockPos pos, @NotNull BlockState state) {
        if (this.getModules().getGrowthStageModule().getGrowthStage() == AnimalGrowthStage.ADULT) {
            super.playStepSound(pos, state);
        }
    }

    public int getAmbientSoundInterval() {
        return 120;
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return (SoundEvent)JSV1Sounds.MEGANEURA_DEATH.get();
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return (SoundEvent)JSV1Sounds.MEGANEURA_DEATH.get();
    }
}

