/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.animal.entity.obj.task;

import java.util.List;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.modules.JSHerdModule;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat.JSTargetTask;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;

public class JSCompyTarget
extends JSTargetTask {
    public JSCompyTarget(JSAnimalBase baseAnimal, boolean mustSee) {
        super(baseAnimal, mustSee);
    }

    @Override
    protected void findTarget() {
        double groupBoundingPoints = 0.0;
        JSHerdModule herdModule = this.animal.getModules().getHerdModule();
        if (herdModule != null) {
            JSAnimalBase leader;
            JSAnimalBase jSAnimalBase = leader = herdModule.isFollower() ? herdModule.getHerdLeader() : this.animal;
            if (!leader.getModules().getHerdModule().getFollowers().isEmpty()) {
                for (JSAnimalBase follower : leader.getModules().getHerdModule().getFollowers()) {
                    groupBoundingPoints += (double)((follower.getBbHeight() + follower.getBbWidth()) / 2.0f);
                }
            } else {
                return;
            }
        }
        AABB tracking = this.getTargetSearchArea(this.animal.getTrackingRange());
        double finalGroupBoundingPoints = groupBoundingPoints;
        List entities = this.animal.level().getEntitiesOfClass(LivingEntity.class, tracking, mob -> {
            if (mob.is((Entity)this.animal)) {
                return false;
            }
            if (this.mustSee && !this.animal.hasLineOfSight((Entity)mob)) {
                return false;
            }
            if (this.animal.getModules().getMetabolismModule().canTarget(false, false, (LivingEntity)mob)) {
                Player player;
                double pointsOfMob = mob.getBbHeight() + mob.getBbWidth();
                if (mob instanceof Player && (player = (Player)mob).isCreative()) {
                    return false;
                }
                return pointsOfMob < finalGroupBoundingPoints;
            }
            return false;
        });
        this.target = this.animal.level().getNearestEntity(entities, TargetingConditions.DEFAULT.range(this.animal.getTrackingRange()), (LivingEntity)this.animal, this.animal.getX(), this.animal.getEyeY(), this.animal.getZ());
    }
}

