/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.animal.entity.obj.task;

import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAvianBase;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.JSTaskBase;
import jp.jurassicsaga.server.base.entity.obj.other.IJSEdibleEntity;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import travelers.server.animal.entity.task.TaskGoal;
import travelers.server.animal.entity.task.TaskPriority;

public class JSDiveBombTask
extends JSTaskBase {
    private static final double MIN_RADIUS = 15.0;
    private static final double MAX_RADIUS = 20.0;
    private static final double MIN_ALT = 12.0;
    private static final double MAX_ALT = 18.0;
    private static final double CIRCLE_SPEED = 0.06;
    private static final double DIVE_ACCEL = 0.2;
    private static final double DIVE_SPEED_BASE = 1.5;
    private static final double HIT_RANGE_SQR = 12.25;
    private static final int DIVE_COOLDOWN_TICKS = 80;
    private static final double ORBIT_STEER = 0.05;
    private static final double RECOVER_STEER = 0.07;
    private static final double CLIMB_FACTOR = 0.0015;
    private static final double MAX_HORIZ_SPEED = 0.6;
    private static final int TIMEOUT_TICKS = 600;
    private long stuckTick;
    private Phase phase;
    private final JSAvianBase pterodactyl;
    private LivingEntity target;
    private double angle;
    private double radius;
    private double alt;
    private long lastDiveTick;

    public JSDiveBombTask(JSAvianBase baseAnimal) {
        super(baseAnimal);
        this.pterodactyl = baseAnimal;
        this.getGoals().add(TaskGoal.ATTACK);
        this.setPriority(TaskPriority.VERY_HIGH);
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public boolean shouldRun() {
        if (this.checkCooldown > 0) {
            --this.checkCooldown;
            return false;
        }
        if (this.pterodactyl.isDead()) {
            return false;
        }
        LivingEntity target = this.pterodactyl.getTarget();
        if (this.pterodactyl.isSleeping() || this.pterodactyl.isResting()) {
            return false;
        }
        if (target == null || !target.isAlive()) {
            return false;
        }
        if (target instanceof IJSEdibleEntity) {
            return false;
        }
        if (!this.pterodactyl.isFlying()) {
            return false;
        }
        this.target = target;
        return true;
    }

    public void onStart() {
        this.angle = this.random.nextDouble() * Math.PI * 2.0;
        this.radius = 15.0 + this.random.nextDouble() * 5.0;
        this.alt = 12.0 + this.random.nextDouble() * 6.0;
        this.phase = Phase.CIRCLE;
        this.stuckTick = this.pterodactyl.tickCount;
        this.pterodactyl.getFlyingPathNavigation().setLookingForPath(true);
        this.pterodactyl.getFlyingPathNavigation().stop();
    }

    public boolean canInterrupt() {
        return false;
    }

    public void tick() {
        if (this.target == null || !this.target.isAlive() || this.animal.isDead()) {
            this.stop();
            return;
        }
        if (!this.pterodactyl.isFlying()) {
            this.pterodactyl.setFlying(true);
        }
        if (this.pterodactyl.getDeltaMovement().lengthSqr() > 0.001) {
            this.stuckTick = this.pterodactyl.tickCount;
        }
        if (this.phase != Phase.CHASE && (long)this.pterodactyl.tickCount - this.stuckTick > 600L) {
            this.phase = Phase.CHASE;
        }
        switch (this.phase.ordinal()) {
            case 0: {
                this.tickCircle();
                break;
            }
            case 1: {
                this.tickDive();
                break;
            }
            case 2: {
                this.tickRecover();
                break;
            }
            case 3: {
                this.tickChase();
            }
        }
    }

    private void tickCircle() {
        boolean cooldown;
        double dz;
        double dy;
        double cx = this.target.getX();
        double cy = this.target.getY();
        double cz = this.target.getZ();
        double orbitY = cy + this.alt;
        this.angle += 0.06;
        double tx = cx + this.radius * Math.cos(this.angle);
        double tz = cz + this.radius * Math.sin(this.angle);
        double dx = tx - this.pterodactyl.getX();
        double len = Math.sqrt(dx * dx + (dy = orbitY - this.pterodactyl.getY()) * dy + (dz = tz - this.pterodactyl.getZ()) * dz);
        if (len < 1.0E-4) {
            return;
        }
        Vec3 vel = this.pterodactyl.getDeltaMovement().scale(0.85);
        vel = vel.add((dx /= len) * 0.05, (dy /= len) * 0.05, (dz /= len) * 0.05);
        double climb = (orbitY - this.pterodactyl.getY()) * 0.0015;
        vel = vel.add(0.0, climb, 0.0);
        vel = this.clampHorizontalSpeed(vel);
        this.pterodactyl.setDeltaMovement(vel);
        this.rotateToVelocity(vel);
        boolean above = this.pterodactyl.getY() > cy + 3.5;
        boolean closeHoriz = this.pterodactyl.position().distanceToSqr(cx, this.pterodactyl.getY(), cz) <= this.radius * this.radius * 1.2;
        boolean bl = cooldown = (long)this.pterodactyl.tickCount - this.lastDiveTick >= 80L;
        if (above && closeHoriz && cooldown && this.random.nextInt(35) == 0 && this.pterodactyl.hasLineOfSight((Entity)this.target)) {
            this.phase = Phase.DIVE;
            this.lastDiveTick = this.pterodactyl.tickCount;
            this.radius = 15.0 + this.random.nextDouble() * 5.0;
        }
    }

    private void tickDive() {
        boolean low;
        this.pterodactyl.setDiving(true);
        Vec3 tv = this.target.getDeltaMovement();
        double leadTicks = 4.0;
        double tx = this.target.getX() + tv.x * leadTicks;
        double ty = this.target.getY() + Math.min(0.5, tv.y * leadTicks);
        double tz = this.target.getZ() + tv.z * leadTicks;
        double dx = tx - this.pterodactyl.getX();
        double dy = ty - this.pterodactyl.getY();
        double dz = tz - this.pterodactyl.getZ();
        double len = Math.sqrt(dx * dx + dy * dy + dz * dz);
        if (len > 1.0E-5) {
            Vec3 vel = this.pterodactyl.getDeltaMovement();
            double speed = 1.5 + this.random.nextDouble() * 0.4;
            vel = new Vec3(vel.x * 0.8 + (dx /= len) * (0.2 * speed), vel.y * 0.8 + (dy /= len) * (0.2 * speed), vel.z * 0.8 + (dz /= len) * (0.2 * speed));
            this.pterodactyl.setDeltaMovement(vel);
            this.rotateToVelocity(vel);
        }
        boolean hitRange = this.pterodactyl.distanceToSqr((Entity)this.target) <= 12.25;
        boolean passed = this.pterodactyl.getY() <= this.target.getY() + 0.2;
        boolean bl = low = this.pterodactyl.getY() <= (double)(this.level.getMinBuildHeight() + 2);
        if (hitRange) {
            this.pterodactyl.doHurtTarget((Entity)this.target);
        }
        if (hitRange || passed || low || !this.pterodactyl.hasLineOfSight((Entity)this.target)) {
            this.phase = Phase.RECOVER;
        }
    }

    private void tickRecover() {
        double dz;
        double dy;
        double cx = this.target.getX();
        double cy = this.target.getY();
        double cz = this.target.getZ();
        this.pterodactyl.setDiving(false);
        if (this.random.nextInt(40) == 0) {
            this.radius = 15.0 + this.random.nextDouble() * 5.0;
            this.alt = 12.0 + this.random.nextDouble() * 6.0;
        }
        this.angle += 0.06;
        double targetY = cy + this.alt;
        double tx = cx + this.radius * Math.cos(this.angle);
        double tz = cz + this.radius * Math.sin(this.angle);
        double dx = tx - this.pterodactyl.getX();
        double len = Math.sqrt(dx * dx + (dy = targetY - this.pterodactyl.getY()) * dy + (dz = tz - this.pterodactyl.getZ()) * dz);
        if (len < 1.0E-4) {
            return;
        }
        Vec3 vel = this.pterodactyl.getDeltaMovement().scale(0.85);
        vel = vel.add((dx /= len) * 0.07, (dy /= len) * 0.07, (dz /= len) * 0.07);
        double climb = (targetY - this.pterodactyl.getY()) * 0.0015;
        vel = vel.add(0.0, climb, 0.0);
        vel = this.clampHorizontalSpeed(vel);
        this.pterodactyl.setDeltaMovement(vel);
        this.rotateToVelocity(vel);
        if (this.pterodactyl.getY() >= targetY - 0.5) {
            this.phase = Phase.CIRCLE;
        }
    }

    private void tickChase() {
        this.pterodactyl.setDiving(false);
        this.pterodactyl.getFlyingPathNavigation().setLookingForPath(true);
        this.pterodactyl.getFlyingPathNavigation().moveTo((Entity)this.target);
        if (this.pterodactyl.distanceToSqr((Entity)this.target) <= 12.25) {
            this.pterodactyl.doHurtTarget((Entity)this.target);
        }
    }

    private void rotateToVelocity(Vec3 vel) {
        if (vel.lengthSqr() < 1.0E-6) {
            return;
        }
        float yaw = (float)(Mth.atan2((double)vel.z, (double)vel.x) * 57.29577951308232) - 90.0f;
        float pitch = (float)(-(Mth.atan2((double)vel.y, (double)Math.sqrt(vel.x * vel.x + vel.z * vel.z)) * 57.29577951308232));
        this.pterodactyl.yBodyRot = this.rotLerp(this.pterodactyl.yBodyRot, yaw, 8.0f);
        this.pterodactyl.setYRot(this.pterodactyl.yBodyRot);
        this.pterodactyl.setXRot(pitch);
    }

    private Vec3 clampHorizontalSpeed(Vec3 vel) {
        double horiz = Math.sqrt(vel.x * vel.x + vel.z * vel.z);
        if (horiz > 0.6) {
            double scale = 0.6 / horiz;
            vel = new Vec3(vel.x * scale, vel.y, vel.z * scale);
        }
        return vel;
    }

    private float rotLerp(float current, float target, float maxChange) {
        float f = Mth.wrapDegrees((float)(target - current));
        if (f > maxChange) {
            f = maxChange;
        }
        if (f < -maxChange) {
            f = -maxChange;
        }
        return current + f;
    }

    public void onStop() {
        this.pterodactyl.setDiving(false);
        this.phase = Phase.CIRCLE;
        this.pterodactyl.getFlyingPathNavigation().setLookingForPath(false);
    }

    public boolean canContinueRunning() {
        if (this.pterodactyl.isSleeping() || this.pterodactyl.isResting()) {
            return false;
        }
        return this.target != null && this.target.isAlive();
    }

    private static enum Phase {
        CIRCLE,
        DIVE,
        RECOVER,
        CHASE;

    }
}

