/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.animal.entity.obj.task;

import java.util.Comparator;
import java.util.List;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalGrowthStage;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.JSTaskBase;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class JSTargetNearby
extends JSTaskBase {
    private LivingEntity target;

    public JSTargetNearby(JSAnimalBase baseAnimal) {
        super(baseAnimal);
    }

    public void onStart() {
        this.target = this.findNearbyTarget();
        if (this.target != null && this.animal.isBaby()) {
            this.alertHerd(this.target);
        }
    }

    public void tick() {
        if (this.target == null || !this.target.isAlive() || this.target.distanceTo((Entity)this.animal) > 16.0f) {
            this.target = this.findNearbyTarget();
            if (this.target != null && this.animal.isBaby()) {
                this.alertHerd(this.target);
            }
        }
    }

    public void onStop() {
        this.target = null;
    }

    public boolean shouldRun() {
        if (this.animal.getModules().getGrowthStageModule().getGrowthStage() == AnimalGrowthStage.BABY) {
            return this.findNearbyTarget() != null;
        }
        return false;
    }

    public boolean canContinueRunning() {
        return this.target != null && this.target.isAlive() && this.target.distanceTo((Entity)this.animal) <= 16.0f;
    }

    private LivingEntity findNearbyTarget() {
        List list = this.level.getEntitiesOfClass(LivingEntity.class, this.animal.getBoundingBox().inflate(16.0), e -> {
            Player player;
            return e != this.animal && e.isAlive() && (!(e instanceof Player) || !(player = (Player)e).isCreative()) && e.getType() != this.animal.getType();
        });
        return list.stream().min(Comparator.comparingDouble(e -> e.distanceToSqr((Entity)this.animal))).orElse(null);
    }

    private void alertHerd(LivingEntity threat) {
        JSAnimalBase trueLeader = this.animal.getModules().getHerdModule().getTrueLeader();
        if (trueLeader != null) {
            for (JSAnimalBase follower : trueLeader.getModules().getHerdModule().getFollowers()) {
                if (follower.getModules().getGrowthStageModule().getGrowthStage() == AnimalGrowthStage.ADULT) {
                    follower.setTarget(threat);
                    continue;
                }
                follower.setFleeTarget(threat);
            }
            trueLeader.setTarget(threat);
        }
    }
}

