/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.block;

import com.google.common.base.Supplier;
import java.util.Collection;
import java.util.function.Consumer;
import jp.jurassicsaga.server.base.block.JSBlocks;
import jp.jurassicsaga.server.base.block.obj.JSBlockSetTypes;
import jp.jurassicsaga.server.base.block.obj.JSTransparentBlock;
import jp.jurassicsaga.server.base.block.obj.JSTransparentWaterLoggedBlock;
import jp.jurassicsaga.server.base.block.obj.furniture.BenchBlock;
import jp.jurassicsaga.server.base.block.obj.group.BasicBlockSetRegistries;
import jp.jurassicsaga.server.base.block.obj.group.ColoredRegistries;
import jp.jurassicsaga.server.base.block.obj.group.WoodRegistries;
import jp.jurassicsaga.server.base.block.obj.plant.JSAquaticPlantBlock;
import jp.jurassicsaga.server.base.block.obj.plant.JSDoublePlantBlock;
import jp.jurassicsaga.server.base.block.obj.plant.JSPlantBlock;
import jp.jurassicsaga.server.base.block.obj.plant.JSTallPlantBlock;
import jp.jurassicsaga.server.base.block.obj.plant.JSWaterloggedPlantBlock;
import jp.jurassicsaga.server.base.block.obj.vanilla_overrides.JSDoor;
import jp.jurassicsaga.server.base.block.obj.vanilla_overrides.JSSapling;
import jp.jurassicsaga.server.base.block.obj.vanilla_overrides.JSStair;
import jp.jurassicsaga.server.base.block.obj.vanilla_overrides.JSWaterLily;
import jp.jurassicsaga.server.base.generic.obj.Era;
import jp.jurassicsaga.server.base.item.JSItems;
import jp.jurassicsaga.server.v1.block.obj.entity.BugZapperBlock;
import jp.jurassicsaga.server.v1.block.obj.entity.feeder.AquaticFeeder;
import jp.jurassicsaga.server.v1.block.obj.entity.feeder.CarnivoreFeeder;
import jp.jurassicsaga.server.v1.block.obj.entity.feeder.HerbivoreFeeder;
import jp.jurassicsaga.server.v1.block.obj.entity.machine.CultivatorMachine;
import jp.jurassicsaga.server.v1.block.obj.entity.machine.DnaModifierMachine;
import jp.jurassicsaga.server.v1.block.obj.entity.machine.GeneExtractorMachine;
import jp.jurassicsaga.server.v1.block.obj.entity.machine.GeneticAnalyzerMachine;
import jp.jurassicsaga.server.v1.block.obj.entity.machine.IncubatorMachine;
import jp.jurassicsaga.server.v1.item.JSV1Items;
import jp.jurassicsaga.server.v1.world.tree.JSV1TreeGrowers;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.PlaceOnWaterBlockItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.material.MapColor;

public class JSV1Blocks {
    public static final Supplier<Block> CULTIVATOR = JSBlocks.registerBlockWItem("cultivator", (Supplier<Block>)((Supplier)() -> new CultivatorMachine(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).forceSolidOn().noOcclusion())), new Item.Properties());
    public static final Supplier<Block> DNA_MODIFIER = JSBlocks.registerBlockWItem("dna_modifier", (Supplier<Block>)((Supplier)() -> new DnaModifierMachine(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).forceSolidOn().noOcclusion())), new Item.Properties());
    public static final Supplier<Block> GENE_EXTRACTOR = JSBlocks.registerBlockWItem("gene_extractor", (Supplier<Block>)((Supplier)() -> new GeneExtractorMachine(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).forceSolidOn().noOcclusion())), new Item.Properties());
    public static final Supplier<Block> GENETIC_ANALYZER = JSBlocks.registerBlockWItem("genetic_analyzer", (Supplier<Block>)((Supplier)() -> new GeneticAnalyzerMachine(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).forceSolidOn().noOcclusion())), new Item.Properties());
    public static final Supplier<Block> INCUBATOR = JSBlocks.registerBlockWItem("incubator", (Supplier<Block>)((Supplier)() -> new IncubatorMachine(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).forceSolidOn().noOcclusion())), new Item.Properties());
    public static final Supplier<Block> BUG_ZAPPER = JSBlocks.registerBlockWItem("bug_zapper", (Supplier<Block>)((Supplier)() -> new BugZapperBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SOUL_LANTERN).forceSolidOn().noOcclusion())), new Item.Properties());
    public static final Supplier<Block> HERBIVORE_FEEDER = JSBlocks.registerBlockWItem("herbivore_feeder", (Supplier<Block>)((Supplier)() -> new HerbivoreFeeder(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).forceSolidOn().noOcclusion())), new Item.Properties());
    public static final Supplier<Block> CARNIVORE_FEEDER = JSBlocks.registerBlockWItem("carnivore_feeder", (Supplier<Block>)((Supplier)() -> new CarnivoreFeeder(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).forceSolidOn().noOcclusion())), new Item.Properties());
    public static final Supplier<Block> AQUATIC_FEEDER = JSBlocks.registerBlockWItem("aquatic_feeder", (Supplier<Block>)((Supplier)() -> new AquaticFeeder(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).forceSolidOn().noOcclusion())), new Item.Properties());
    public static final Supplier<Block> SECURE_GRID_DOOR = JSBlocks.registerBlockWItem("secure_grid_door", (Supplier<Block>)((Supplier)() -> new JSDoor(BlockSetType.IRON, BlockBehaviour.Properties.of().noOcclusion())), new Item.Properties());
    public static final Supplier<Block> GRID_DOOR = JSBlocks.registerBlockWItem("grid_door", (Supplier<Block>)((Supplier)() -> new JSDoor(BlockSetType.COPPER, BlockBehaviour.Properties.of().noOcclusion())), new Item.Properties());
    public static final Supplier<Block> GLASS_DOOR = JSBlocks.registerBlockWItem("glass_door_basic", (Supplier<Block>)((Supplier)() -> new JSDoor(JSBlockSetTypes.GLASS_DOOR, BlockBehaviour.Properties.of().noOcclusion())), new Item.Properties());
    public static final ColoredRegistries COLORED_GLASS_DOORS = new ColoredRegistries("glass_door", (Supplier<Block>)((Supplier)() -> new JSDoor(JSBlockSetTypes.GLASS_DOOR, BlockBehaviour.Properties.of().noOcclusion())), new Item.Properties());
    public static final Supplier<Block> CORRUGATED_IRON = JSBlocks.registerBlockWItem("corrugated_iron", (Supplier<Block>)((Supplier)() -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK))), new Item.Properties());
    public static final Supplier<Block> CORRUGATED_IRON_STAIR = JSBlocks.registerBlockWItem("corrugated_iron_stair", (Supplier<Block>)((Supplier)() -> new JSStair(((Block)CORRUGATED_IRON.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK))), new Item.Properties());
    public static final ColoredRegistries COLORED_CORRUGATED_IRONS_STAIR = new ColoredRegistries("corrugated_iron_stair", (Supplier<Block>)((Supplier)() -> new JSStair(((Block)CORRUGATED_IRON.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK))), new Item.Properties());
    public static final Supplier<Block> CORRUGATED_IRON_SLAB = JSBlocks.registerBlockWItem("corrugated_iron_slab", (Supplier<Block>)((Supplier)() -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK))), new Item.Properties());
    public static final ColoredRegistries COLORED_CORRUGATED_IRONS = new ColoredRegistries("corrugated_iron", (Supplier<Block>)((Supplier)() -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK))), new Item.Properties());
    public static final ColoredRegistries COLORED_CORRUGATED_IRONS_SLAB = new ColoredRegistries("corrugated_iron_slab", (Supplier<Block>)((Supplier)() -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK))), new Item.Properties());
    public static final Supplier<Block> ROOF_TILES = JSBlocks.registerBlockWItem("roof_tiles", (Supplier<Block>)((Supplier)() -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MUD_BRICKS))), new Item.Properties());
    public static final Supplier<Block> ROOF_TILES_STAIR = JSBlocks.registerBlockWItem("roof_tiles_stair", (Supplier<Block>)((Supplier)() -> new JSStair(((Block)ROOF_TILES.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MUD_BRICKS))), new Item.Properties());
    public static final ColoredRegistries COLORED_ROOF_TILES_STAIRS = new ColoredRegistries("roof_tiles_stairs", (Supplier<Block>)((Supplier)() -> new JSStair(((Block)ROOF_TILES.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MUD_BRICKS))), new Item.Properties());
    public static final Supplier<Block> ROOF_TILES_SLAB = JSBlocks.registerBlockWItem("roof_tiles_slab", (Supplier<Block>)((Supplier)() -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MUD_BRICKS))), new Item.Properties());
    public static final ColoredRegistries COLORED_ROOF_TILES = new ColoredRegistries("roof_tiles", (Supplier<Block>)((Supplier)() -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MUD_BRICKS))), new Item.Properties());
    public static final ColoredRegistries COLORED_ROOF_TILES_SLAB = new ColoredRegistries("roof_tiles_slab", (Supplier<Block>)((Supplier)() -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MUD_BRICKS))), new Item.Properties());
    public static final Supplier<Block> THATCH = JSBlocks.registerBlockWItem("thatch", (Supplier<Block>)((Supplier)() -> new RotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.HAY_BLOCK))), new Item.Properties());
    public static final Supplier<Block> THATCH_STAIRS = JSBlocks.registerBlockWItem("thatch_stairs", (Supplier<Block>)((Supplier)() -> new JSStair(((Block)THATCH.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.HAY_BLOCK))), new Item.Properties());
    public static final Supplier<Block> THATCH_SLAB = JSBlocks.registerBlockWItem("thatch_slab", (Supplier<Block>)((Supplier)() -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.HAY_BLOCK))), new Item.Properties());
    public static final Supplier<Block> IRON_PILLAR = JSBlocks.registerBlockWItem("iron_pillar", (Supplier<Block>)((Supplier)() -> new RotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK))), new Item.Properties());
    public static final Supplier<Block> BIG_TILE = JSBlocks.registerBlockWItem("big_tile_path", (Supplier<Block>)((Supplier)() -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DIRT).sound(SoundType.DRIPSTONE_BLOCK))), new Item.Properties());
    public static final Supplier<Block> BIG_TILE_STAIR = JSBlocks.registerBlockWItem("big_tile_path_stairs", (Supplier<Block>)((Supplier)() -> new JSStair(((Block)BIG_TILE.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DIRT).sound(SoundType.DRIPSTONE_BLOCK))), new Item.Properties());
    public static final Supplier<Block> BIG_TILE_SLAB = JSBlocks.registerBlockWItem("big_tile_path_slab", (Supplier<Block>)((Supplier)() -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DIRT).sound(SoundType.DRIPSTONE_BLOCK))), new Item.Properties());
    public static final Supplier<Block> MIXED_PATH = JSBlocks.registerBlockWItem("mixed_path", (Supplier<Block>)((Supplier)() -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DIRT).sound(SoundType.DRIPSTONE_BLOCK))), new Item.Properties());
    public static final Supplier<Block> MIXED_PATH_STAIR = JSBlocks.registerBlockWItem("mixed_path_stairs", (Supplier<Block>)((Supplier)() -> new JSStair(((Block)MIXED_PATH.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DIRT).sound(SoundType.DRIPSTONE_BLOCK))), new Item.Properties());
    public static final Supplier<Block> MIXED_PATH_SLAB = JSBlocks.registerBlockWItem("mixed_path_slab", (Supplier<Block>)((Supplier)() -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DIRT).sound(SoundType.DRIPSTONE_BLOCK))), new Item.Properties());
    public static final Supplier<Block> CAMO_NET = JSBlocks.registerBlockWItem("camo_net", (Supplier<Block>)((Supplier)() -> new JSTransparentWaterLoggedBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS).dynamicShape().forceSolidOff().noOcclusion().sound(SoundType.ROOTED_DIRT).randomTicks(), false)), new Item.Properties());
    public static final Supplier<Block> CLEAR_GLASS = JSBlocks.registerBlockWItem("clear_glass", (Supplier<Block>)((Supplier)() -> new JSTransparentBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS).dynamicShape().forceSolidOff().noOcclusion().sound(SoundType.GLASS).randomTicks(), true)), new Item.Properties());
    public static final Supplier<Block> REINFORCED_GLASS = JSBlocks.registerBlockWItem("reinforced_glass", (Supplier<Block>)((Supplier)() -> new JSTransparentBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS).dynamicShape().forceSolidOff().noOcclusion().sound(SoundType.METAL).randomTicks(), true)), new Item.Properties());
    public static final Supplier<Block> HEAVY_DUTY_GRID = JSBlocks.registerBlockWItem("heavy_duty_grid", (Supplier<Block>)((Supplier)() -> new JSTransparentWaterLoggedBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS).sound(SoundType.METAL).forceSolidOff().randomTicks(), false)), new Item.Properties());
    public static final Supplier<Block> HEAVY_DUTY_BARS = JSBlocks.registerBlockWItem("heavy_duty_bars", (Supplier<Block>)((Supplier)() -> new JSTransparentWaterLoggedBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS).sound(SoundType.METAL).forceSolidOff().randomTicks(), false)), new Item.Properties());
    public static final BasicBlockSetRegistries FACILITY_CONCRETE = new BasicBlockSetRegistries("facility_concrete", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICKS), new Item.Properties());
    public static final BasicBlockSetRegistries FACILITY_CONCRETE_BRICKS = new BasicBlockSetRegistries("facility_concrete_bricks", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICKS), new Item.Properties());
    public static final BasicBlockSetRegistries FACILITY_CONCRETE_BRICKS_CRACKED = new BasicBlockSetRegistries("facility_concrete_bricks_cracked", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CRACKED_STONE_BRICKS), new Item.Properties());
    public static final BasicBlockSetRegistries FACILITY_CONCRETE_BRICKS_MOSSY = new BasicBlockSetRegistries("facility_concrete_bricks_mossy", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MOSSY_STONE_BRICKS), new Item.Properties());
    public static final BasicBlockSetRegistries FACILITY_CONCRETE_CRACKED = new BasicBlockSetRegistries("facility_concrete_cracked", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CRACKED_STONE_BRICKS), new Item.Properties());
    public static final BasicBlockSetRegistries FACILITY_CONCRETE_MOSSY = new BasicBlockSetRegistries("facility_concrete_mossy", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MOSSY_STONE_BRICKS), new Item.Properties());
    public static final BasicBlockSetRegistries FACILITY_CONCRETE_PANEL = new BasicBlockSetRegistries("facility_concrete_panel", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICKS), new Item.Properties());
    public static final BasicBlockSetRegistries FACILITY_CONCRETE_PANEL_MOSSY = new BasicBlockSetRegistries("facility_concrete_panel_mossy", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICKS), new Item.Properties());
    public static final Supplier<Block> FACILITY_CONCRETE_PILLAR = JSBlocks.registerBlockWItem("facility_concrete_pillar", (Supplier<Block>)((Supplier)() -> new RotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICKS))), new Item.Properties());
    public static final Supplier<Block> FACILITY_CONCRETE_PILLAR_CRACKED = JSBlocks.registerBlockWItem("facility_concrete_pillar_cracked", (Supplier<Block>)((Supplier)() -> new RotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICKS))), new Item.Properties());
    public static final Supplier<Block> FACILITY_CONCRETE_PILLAR_MOSSY = JSBlocks.registerBlockWItem("facility_concrete_pillar_mossy", (Supplier<Block>)((Supplier)() -> new RotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICKS))), new Item.Properties());
    public static final WoodRegistries ARAUCARIOXYLON = new WoodRegistries("araucarioxylon", MapColor.COLOR_BROWN, new Item.Properties());
    public static final WoodRegistries GORDONPTERIS = new WoodRegistries("gordonopteris", MapColor.COLOR_BROWN, new Item.Properties());
    public static final WoodRegistries LEPIDODENDRON = new WoodRegistries("lepidodendron", MapColor.COLOR_LIGHT_GREEN, new Item.Properties());
    public static final WoodRegistries SPINIFRUCTUS = new WoodRegistries("spinifructus", MapColor.COLOR_BROWN, new Item.Properties());
    public static final Supplier<Block> ARAUCARIOXYLON_SAPLING = JSBlocks.registerBlockWItem("araucarioxylon_sapling", (Supplier<Block>)((Supplier)() -> new JSSapling(JSV1TreeGrowers.ARAUCARIOXYLON, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.ACACIA_SAPLING))), new Item.Properties());
    public static final Supplier<Block> GORDONPTERIS_SAPLING = JSBlocks.registerBlockWItem("gordonopteris_sapling", (Supplier<Block>)((Supplier)() -> new JSSapling(JSV1TreeGrowers.GORDONOPTERIS, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.ACACIA_SAPLING))), new Item.Properties());
    public static final Supplier<Block> LEPIDODENDRON_SAPLING = JSBlocks.registerBlockWItem("lepidodendron_sapling", (Supplier<Block>)((Supplier)() -> new JSSapling(JSV1TreeGrowers.LEPIDODENDRON, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.ACACIA_SAPLING))), new Item.Properties());
    public static final Supplier<Block> SPINIFRUCTUS_SAPLING = JSBlocks.registerBlockWItem("spinifructus_sapling", (Supplier<Block>)((Supplier)() -> new JSSapling(JSV1TreeGrowers.SPINIFRUCTUS, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.ACACIA_SAPLING))), new Item.Properties());
    public static final Supplier<Block> ARCHAEOMARASMIUS = JSBlocks.registerBlockWItem("archaeomarasmius", (Supplier<Block>)((Supplier)() -> new JSPlantBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SHORT_GRASS))), new Item.Properties());
    public static final Supplier<Block> CYCADEOIDEA = JSBlocks.registerBlockWItem("cycadeoidea", (Supplier<Block>)((Supplier)() -> new JSPlantBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SHORT_GRASS))), new Item.Properties());
    public static final Supplier<Block> LADINA_SIMPLEX = JSBlocks.registerBlockWItem("ladinia_simplex", (Supplier<Block>)((Supplier)() -> new JSPlantBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SHORT_GRASS))), new Item.Properties());
    public static final Supplier<Block> SELAGINELLITES = JSBlocks.registerBlockWItem("selaginellites", (Supplier<Block>)((Supplier)() -> new JSPlantBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SHORT_GRASS))), new Item.Properties());
    public static final Supplier<Block> ZINGIBEROPSIS_BASIC = JSBlocks.registerBlockWItem("zingiberopsis_basic", (Supplier<Block>)((Supplier)() -> new JSPlantBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SHORT_GRASS))), new Item.Properties());
    public static final Supplier<Block> ZINGIBEROPSIS_ORANGE = JSBlocks.registerBlockWItem("zingiberopsis_orange", (Supplier<Block>)((Supplier)() -> new JSPlantBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SHORT_GRASS))), new Item.Properties());
    public static final Supplier<Block> ZINGIBEROPSIS_PINK = JSBlocks.registerBlockWItem("zingiberopsis_pink", (Supplier<Block>)((Supplier)() -> new JSPlantBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SHORT_GRASS))), new Item.Properties());
    public static final Supplier<Block> ZINGIBEROPSIS_RED = JSBlocks.registerBlockWItem("zingiberopsis_red", (Supplier<Block>)((Supplier)() -> new JSPlantBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SHORT_GRASS))), new Item.Properties());
    public static final Supplier<Block> ZINGIBEROPSIS_WHITE = JSBlocks.registerBlockWItem("zingiberopsis_white", (Supplier<Block>)((Supplier)() -> new JSPlantBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SHORT_GRASS))), new Item.Properties());
    public static final Supplier<Block> ZINGIBEROPSIS_YELLOW = JSBlocks.registerBlockWItem("zingiberopsis_yellow", (Supplier<Block>)((Supplier)() -> new JSPlantBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SHORT_GRASS))), new Item.Properties());
    public static final Supplier<Block> ROYAL_FERN = JSBlocks.registerBlockWItem("royal_fern", (Supplier<Block>)((Supplier)() -> new JSPlantBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SHORT_GRASS))), new Item.Properties());
    public static final Supplier<Block> HELICONIA = JSBlocks.registerBlockWItem("heliconia", (Supplier<Block>)((Supplier)() -> new JSDoublePlantBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SHORT_GRASS))), new Item.Properties());
    public static final Supplier<Block> WEST_INDIAN_LILAC = JSBlocks.registerBlockWItem("west_indian_lilac", (Supplier<Block>)((Supplier)() -> new JSDoublePlantBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SHORT_GRASS))), new Item.Properties());
    public static final Supplier<Block> SWISS_CHEESE_PLANT = JSBlocks.registerBlockWItem("swiss_cheese_plant", (Supplier<Block>)((Supplier)() -> new JSDoublePlantBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SHORT_GRASS))), new Item.Properties());
    public static final Supplier<Block> ALETHOPTERIS = JSBlocks.registerBlockWItem("alethopteris", (Supplier<Block>)((Supplier)() -> new JSDoublePlantBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SHORT_GRASS))), new Item.Properties());
    public static final Supplier<Block> CLADOPHLEBIS = JSBlocks.registerBlockWItem("cladophlebis", (Supplier<Block>)((Supplier)() -> new JSDoublePlantBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SHORT_GRASS))), new Item.Properties());
    public static final Supplier<Block> NEUROPTERIS = JSBlocks.registerBlockWItem("neuropteris", (Supplier<Block>)((Supplier)() -> new JSDoublePlantBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SHORT_GRASS))), new Item.Properties());
    public static final Supplier<Block> VERIFORMANS = JSBlocks.registerBlockWItem("veriformans", (Supplier<Block>)((Supplier)() -> new JSDoublePlantBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SHORT_GRASS))), new Item.Properties());
    public static final Supplier<Block> CAPRINA = JSBlocks.registerBlockWItem("caprina", (Supplier<Block>)((Supplier)() -> new JSAquaticPlantBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SEAGRASS))), new Item.Properties());
    public static final Supplier<Block> CREMNOCERAMUS = JSBlocks.registerBlockWItem("cremnoceramus", (Supplier<Block>)((Supplier)() -> new JSAquaticPlantBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SEAGRASS))), new Item.Properties());
    public static final Supplier<Block> HIPPURITELLA = JSBlocks.registerBlockWItem("hippuritella", (Supplier<Block>)((Supplier)() -> new JSAquaticPlantBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SEAGRASS))), new Item.Properties());
    public static final Supplier<Block> INOCERAMUS = JSBlocks.registerBlockWItem("inoceramus", (Supplier<Block>)((Supplier)() -> new JSWaterloggedPlantBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SEAGRASS))), new Item.Properties());
    public static final Supplier<Block> COBANNIA_CORRUGATA = JSBlocks.registerBlock("cobbania_corrugata", (Supplier<Block>)((Supplier)() -> new JSWaterLily(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LILY_PAD))));
    public static final Supplier<Item> COBANNIA_CORRUGATA_ITEM = JSItems.registerItem("cobbania_corrugata", (Supplier<Item>)((Supplier)() -> new PlaceOnWaterBlockItem((Block)COBANNIA_CORRUGATA.get(), new Item.Properties())));
    public static final Supplier<Block> NEOCALAMITES = JSBlocks.registerBlockWItem("neocalamites", (Supplier<Block>)((Supplier)() -> new JSTallPlantBlock(8, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SHORT_GRASS))), new Item.Properties());
    public static final Supplier<Block> OMPHALOPHLOIOS = JSBlocks.registerBlockWItem("omphalophloios", (Supplier<Block>)((Supplier)() -> new JSTallPlantBlock(6, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SHORT_GRASS))), new Item.Properties());
    public static final Supplier<Block> RHAMNUS_SALICIFOLIUS = JSBlocks.registerBlockWItem("rhamnus_salicifolius", (Supplier<Block>)((Supplier)() -> new JSTallPlantBlock(4, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SHORT_GRASS))), new Item.Properties());
    public static final Supplier<Block> TEMPSKYA = JSBlocks.registerBlockWItem("tempskya", (Supplier<Block>)((Supplier)() -> new JSTallPlantBlock(5, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SHORT_GRASS))), new Item.Properties());
    public static final Supplier<Block> BENCH_ARAUCARIOXYLON = JSBlocks.registerBlockWItem("bench_araucarioxylon", (Supplier<Block>)((Supplier)BenchBlock::new), new Item.Properties());
    public static final Supplier<Block> BENCH_GORDONOPTERIS = JSBlocks.registerBlockWItem("bench_gordonopteris", (Supplier<Block>)((Supplier)BenchBlock::new), new Item.Properties());
    public static final Supplier<Block> BENCH_LEPIDODENDRON = JSBlocks.registerBlockWItem("bench_lepidodendron", (Supplier<Block>)((Supplier)BenchBlock::new), new Item.Properties());
    public static final Supplier<Block> BENCH_SPINIFRUCTUS = JSBlocks.registerBlockWItem("bench_spinifructus", (Supplier<Block>)((Supplier)BenchBlock::new), new Item.Properties());

    public static void init() {
    }

    public static Runnable addBlocks(Consumer<ItemLike> output) {
        return () -> {
            output.accept((ItemLike)BUG_ZAPPER.get());
            output.accept((ItemLike)CULTIVATOR.get());
            output.accept((ItemLike)DNA_MODIFIER.get());
            output.accept((ItemLike)GENE_EXTRACTOR.get());
            output.accept((ItemLike)GENETIC_ANALYZER.get());
            output.accept((ItemLike)INCUBATOR.get());
            output.accept((ItemLike)HERBIVORE_FEEDER.get());
            output.accept((ItemLike)AQUATIC_FEEDER.get());
            output.accept((ItemLike)CARNIVORE_FEEDER.get());
            output.accept((ItemLike)SECURE_GRID_DOOR.get());
            output.accept((ItemLike)GRID_DOOR.get());
            output.accept((ItemLike)GLASS_DOOR.get());
            for (ItemLike itemLike : COLORED_GLASS_DOORS.collect()) {
                output.accept(itemLike);
            }
            output.accept((ItemLike)CORRUGATED_IRON.get());
            for (ItemLike itemLike : COLORED_CORRUGATED_IRONS.collect()) {
                output.accept(itemLike);
            }
            output.accept((ItemLike)CORRUGATED_IRON_SLAB.get());
            for (ItemLike itemLike : COLORED_CORRUGATED_IRONS_SLAB.collect()) {
                output.accept(itemLike);
            }
            output.accept((ItemLike)CORRUGATED_IRON_STAIR.get());
            for (ItemLike itemLike : COLORED_CORRUGATED_IRONS_STAIR.collect()) {
                output.accept(itemLike);
            }
            output.accept((ItemLike)ROOF_TILES.get());
            for (ItemLike itemLike : COLORED_ROOF_TILES.collect()) {
                output.accept(itemLike);
            }
            output.accept((ItemLike)ROOF_TILES_SLAB.get());
            for (ItemLike itemLike : COLORED_ROOF_TILES_SLAB.collect()) {
                output.accept(itemLike);
            }
            output.accept((ItemLike)ROOF_TILES_STAIR.get());
            for (ItemLike itemLike : COLORED_ROOF_TILES_STAIRS.collect()) {
                output.accept(itemLike);
            }
            for (Era value : Era.values()) {
                Supplier<Block> ore = value.getFossilOre();
                if (ore != null) {
                    output.accept((ItemLike)ore.get());
                }
                if ((ore = value.getMarineOre()) == null) continue;
                output.accept((ItemLike)ore.get());
            }
            output.accept((ItemLike)THATCH.get());
            output.accept((ItemLike)THATCH_SLAB.get());
            output.accept((ItemLike)THATCH_STAIRS.get());
            output.accept((ItemLike)IRON_PILLAR.get());
            output.accept((ItemLike)BIG_TILE.get());
            output.accept((ItemLike)BIG_TILE_SLAB.get());
            output.accept((ItemLike)BIG_TILE_STAIR.get());
            output.accept((ItemLike)MIXED_PATH.get());
            output.accept((ItemLike)MIXED_PATH_SLAB.get());
            output.accept((ItemLike)MIXED_PATH_STAIR.get());
            output.accept((ItemLike)CAMO_NET.get());
            output.accept((ItemLike)CLEAR_GLASS.get());
            output.accept((ItemLike)REINFORCED_GLASS.get());
            output.accept((ItemLike)HEAVY_DUTY_BARS.get());
            output.accept((ItemLike)HEAVY_DUTY_GRID.get());
            JSV1Blocks.addToOutput(FACILITY_CONCRETE.collect(), output);
            JSV1Blocks.addToOutput(FACILITY_CONCRETE_BRICKS.collect(), output);
            JSV1Blocks.addToOutput(FACILITY_CONCRETE_BRICKS_CRACKED.collect(), output);
            JSV1Blocks.addToOutput(FACILITY_CONCRETE_BRICKS_MOSSY.collect(), output);
            JSV1Blocks.addToOutput(FACILITY_CONCRETE_CRACKED.collect(), output);
            JSV1Blocks.addToOutput(FACILITY_CONCRETE_MOSSY.collect(), output);
            JSV1Blocks.addToOutput(FACILITY_CONCRETE_PANEL.collect(), output);
            JSV1Blocks.addToOutput(FACILITY_CONCRETE_PANEL_MOSSY.collect(), output);
            output.accept((ItemLike)FACILITY_CONCRETE_PILLAR.get());
            output.accept((ItemLike)FACILITY_CONCRETE_PILLAR_CRACKED.get());
            output.accept((ItemLike)FACILITY_CONCRETE_PILLAR_MOSSY.get());
        };
    }

    private static void addToOutput(Collection<ItemLike> collect, Consumer<ItemLike> output) {
        for (ItemLike itemLike : collect) {
            output.accept(itemLike);
        }
    }

    public static Runnable addPlants(Consumer<ItemLike> output) {
        return () -> {
            for (ItemLike stack : ARAUCARIOXYLON.collect()) {
                output.accept(stack);
            }
            output.accept((ItemLike)JSV1Items.ARAUCARIOXYLON_BOAT.get());
            output.accept((ItemLike)JSV1Items.ARAUCARIOXYLON_CHEST_BOAT.get());
            output.accept((ItemLike)ARAUCARIOXYLON_SAPLING.get());
            output.accept((ItemLike)BENCH_ARAUCARIOXYLON.get());
            for (ItemLike stack : GORDONPTERIS.collect()) {
                output.accept(stack);
            }
            output.accept((ItemLike)JSV1Items.GORDONOPTERIS_BOAT.get());
            output.accept((ItemLike)JSV1Items.GORDONOPTERIS_CHEST_BOAT.get());
            output.accept((ItemLike)GORDONPTERIS_SAPLING.get());
            output.accept((ItemLike)BENCH_GORDONOPTERIS.get());
            for (ItemLike stack : LEPIDODENDRON.collect()) {
                output.accept(stack);
            }
            output.accept((ItemLike)JSV1Items.LEPIDODENDRON_BOAT.get());
            output.accept((ItemLike)JSV1Items.LEPIDODENDRON_CHEST_BOAT.get());
            output.accept((ItemLike)LEPIDODENDRON_SAPLING.get());
            output.accept((ItemLike)BENCH_LEPIDODENDRON.get());
            for (ItemLike stack : SPINIFRUCTUS.collect()) {
                output.accept(stack);
            }
            output.accept((ItemLike)JSV1Items.SPINIFRUCTUS_BOAT.get());
            output.accept((ItemLike)JSV1Items.SPINIFRUCTUS_CHEST_BOAT.get());
            output.accept((ItemLike)SPINIFRUCTUS_SAPLING.get());
            output.accept((ItemLike)BENCH_SPINIFRUCTUS.get());
            output.accept((ItemLike)JSBlocks.BENCH_ACACIA_LOG.get());
            output.accept((ItemLike)JSBlocks.BENCH_OAK_LOG.get());
            output.accept((ItemLike)JSBlocks.BENCH_SPRUCE_LOG.get());
            output.accept((ItemLike)JSBlocks.BENCH_BIRCH_LOG.get());
            output.accept((ItemLike)JSBlocks.BENCH_JUNGLE_LOG.get());
            output.accept((ItemLike)JSBlocks.BENCH_ACACIA_LOG.get());
            output.accept((ItemLike)JSBlocks.BENCH_DARK_OAK_LOG.get());
            output.accept((ItemLike)JSBlocks.BENCH_MANGROVE_LOG.get());
            output.accept((ItemLike)JSBlocks.BENCH_CHERRY_LOG.get());
            output.accept((ItemLike)JSBlocks.BENCH_CRIMSON_STEM.get());
            output.accept((ItemLike)JSBlocks.BENCH_WARPED_STEM.get());
            output.accept((ItemLike)ALETHOPTERIS.get());
            output.accept((ItemLike)ARCHAEOMARASMIUS.get());
            output.accept((ItemLike)CLADOPHLEBIS.get());
            output.accept((ItemLike)CYCADEOIDEA.get());
            output.accept((ItemLike)LADINA_SIMPLEX.get());
            output.accept((ItemLike)NEUROPTERIS.get());
            output.accept((ItemLike)VERIFORMANS.get());
            output.accept((ItemLike)SELAGINELLITES.get());
            output.accept((ItemLike)ZINGIBEROPSIS_BASIC.get());
            output.accept((ItemLike)ZINGIBEROPSIS_ORANGE.get());
            output.accept((ItemLike)ZINGIBEROPSIS_PINK.get());
            output.accept((ItemLike)ZINGIBEROPSIS_RED.get());
            output.accept((ItemLike)ZINGIBEROPSIS_WHITE.get());
            output.accept((ItemLike)ZINGIBEROPSIS_YELLOW.get());
            output.accept((ItemLike)HELICONIA.get());
            output.accept((ItemLike)ROYAL_FERN.get());
            output.accept((ItemLike)WEST_INDIAN_LILAC.get());
            output.accept((ItemLike)SWISS_CHEESE_PLANT.get());
            output.accept((ItemLike)CAPRINA.get());
            output.accept((ItemLike)CREMNOCERAMUS.get());
            output.accept((ItemLike)HIPPURITELLA.get());
            output.accept((ItemLike)INOCERAMUS.get());
            output.accept((ItemLike)COBANNIA_CORRUGATA_ITEM.get());
            output.accept((ItemLike)NEOCALAMITES.get());
            output.accept((ItemLike)OMPHALOPHLOIOS.get());
            output.accept((ItemLike)RHAMNUS_SALICIFOLIUS.get());
            output.accept((ItemLike)TEMPSKYA.get());
        };
    }
}

