/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.block.entity.geo.machine;

import jp.jurassicsaga.server.base.generic.gene.JSGeneUtil;
import jp.jurassicsaga.server.base.generic.gene.JSGenetics;
import jp.jurassicsaga.server.base.generic.gene.obj.JSGeneData;
import jp.jurassicsaga.server.base.generic.gene.obj.JSPlantData;
import jp.jurassicsaga.server.base.item.JSDataComponents;
import jp.jurassicsaga.server.base.item.obj.egg.FertileEggItem;
import jp.jurassicsaga.server.v1.block.JSV1Blocks;
import jp.jurassicsaga.server.v1.block.entity.JSV1BlockEntities;
import jp.jurassicsaga.server.v1.block.entity.geo.machine.GenericMachineEntity;
import jp.jurassicsaga.server.v1.menu.obj.machine.CultivatorMachineMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CultivatorMachineEntity
extends GenericMachineEntity {
    private final ContainerData data = new ContainerData(){

        public int get(int index) {
            return switch (index) {
                case 1 -> CultivatorMachineEntity.this.progress1;
                case 2 -> CultivatorMachineEntity.this.progress2;
                case 3 -> CultivatorMachineEntity.this.progress3;
                default -> 1200;
            };
        }

        public void set(int index, int value) {
            switch (index) {
                case 1: {
                    CultivatorMachineEntity.this.progress1 = value;
                    break;
                }
                case 2: {
                    CultivatorMachineEntity.this.progress2 = value;
                    break;
                }
                case 3: {
                    CultivatorMachineEntity.this.progress3 = value;
                }
            }
        }

        public int getCount() {
            return 4;
        }
    };
    private final int maxProgress = 1200;
    private int progress1 = 0;
    private int progress2 = 0;
    private int progress3 = 0;

    public CultivatorMachineEntity(BlockPos p_155229_, BlockState p_155230_) {
        super(19, (Block)JSV1Blocks.CULTIVATOR.get(), (BlockEntityType)JSV1BlockEntities.CULTIVATOR.get(), p_155229_, p_155230_);
    }

    private void tickItem(int slot, Level lvl, CultivatorMachineEntity be) {
        ItemStack slot1 = (ItemStack)be.items.get(slot);
        if (lvl.isClientSide) {
            return;
        }
        Item item = slot1.getItem();
        if (item instanceof FertileEggItem) {
            FertileEggItem eggItem = (FertileEggItem)item;
            int progressCur = switch (slot) {
                case 0 -> be.progress1;
                case 1 -> be.progress2;
                case 2 -> be.progress3;
                default -> 0;
            };
            CompoundTag animal = (CompoundTag)slot1.get((DataComponentType)JSDataComponents.GENE_DATA.get());
            if (animal == null) {
                return;
            }
            JSGeneData geneData = JSGeneUtil.fromCompound(animal);
            ResourceLocation name = ResourceLocation.bySeparator((String)geneData.getDataOwnerName(), (char)':');
            JSPlantData plantData = JSGenetics.PLANT_GENETIC_INFORMATION.get(name.getPath());
            if (plantData == null) {
                progressCur = 0;
            } else if (++progressCur >= be.maxProgress) {
                JSGeneData data = JSGeneUtil.readFromStack(slot1);
                ItemStack output = ((Block)plantData.result.get()).asItem().getDefaultInstance();
                output.setCount(2);
                if (data.isValid()) {
                    JSGeneUtil.writeToStack(output, data);
                }
                be.items.set(slot, (Object)output);
                progressCur = 0;
            }
            switch (slot) {
                case 0: {
                    be.progress1 = progressCur;
                    break;
                }
                case 1: {
                    be.progress2 = progressCur;
                    break;
                }
                case 2: {
                    be.progress3 = progressCur;
                }
            }
        } else {
            switch (slot) {
                case 0: {
                    be.progress1 = 0;
                    break;
                }
                case 1: {
                    be.progress2 = 0;
                    break;
                }
                case 2: {
                    be.progress3 = 0;
                }
            }
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = super.getUpdateTag(registries);
        tag.putInt("js.egg.0", this.progress1);
        tag.putInt("js.egg.1", this.progress2);
        tag.putInt("js.egg.2", this.progress3);
        return tag;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int p_39954_, @NotNull Inventory p_39955_, @NotNull Player p_39956_) {
        return new CultivatorMachineMenu(p_39954_, p_39955_, this, this.data);
    }

    @Override
    public ContainerData getContainerData() {
        return this.data;
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt("js.egg.0", this.progress1);
        tag.putInt("js.egg.1", this.progress2);
        tag.putInt("js.egg.2", this.progress3);
    }

    @Override
    protected void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.progress1 = tag.getInt("js.egg.0");
        this.progress2 = tag.getInt("js.egg.1");
        this.progress3 = tag.getInt("js.egg.2");
    }

    @Override
    public void workTick(Level level, GenericMachineEntity be, BlockState state, BlockPos pos) {
        if (!(be instanceof CultivatorMachineEntity)) {
            return;
        }
        CultivatorMachineEntity e = (CultivatorMachineEntity)be;
        this.localTick(level, e);
    }

    public void localTick(Level lvl, CultivatorMachineEntity be) {
        be.setChanged();
        be.tickItem(0, lvl, be);
        be.tickItem(1, lvl, be);
        be.tickItem(2, lvl, be);
        be.setChanged();
    }
}

