/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.block.entity.geo.machine;

import jp.jurassicsaga.server.base.generic.gene.JSGene;
import jp.jurassicsaga.server.base.generic.gene.JSGeneUtil;
import jp.jurassicsaga.server.base.generic.gene.obj.JSGeneData;
import jp.jurassicsaga.server.base.generic.obj.AnimalAttachment;
import jp.jurassicsaga.server.base.item.obj.egg.GenderSpawnEgg;
import jp.jurassicsaga.server.base.item.obj.genetics.DnaItem;
import jp.jurassicsaga.server.base.item.obj.genetics.GeneItem;
import jp.jurassicsaga.server.base.item.obj.genetics.OtherDnaItem;
import jp.jurassicsaga.server.base.item.obj.genetics.PlantDnaItem;
import jp.jurassicsaga.server.v1.block.JSV1Blocks;
import jp.jurassicsaga.server.v1.block.entity.JSV1BlockEntities;
import jp.jurassicsaga.server.v1.block.entity.geo.machine.GenericMachineEntity;
import jp.jurassicsaga.server.v1.menu.obj.machine.DnaModifierMachineMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DnaModifierMachineEntity
extends GenericMachineEntity {
    private final ContainerData data;
    private ItemStack result = ItemStack.EMPTY;
    private int progress = 0;
    private int maxProgress = 130;

    public DnaModifierMachineEntity(BlockPos p_155229_, BlockState p_155230_) {
        super(20, (Block)JSV1Blocks.DNA_MODIFIER.get(), (BlockEntityType)JSV1BlockEntities.DNA_MODIFIER.get(), p_155229_, p_155230_);
        this.data = new ContainerData(){

            public int get(int index) {
                return switch (index) {
                    case 0 -> DnaModifierMachineEntity.this.progress;
                    case 1 -> DnaModifierMachineEntity.this.maxProgress;
                    default -> 0;
                };
            }

            public void set(int index, int value) {
                switch (index) {
                    case 0: {
                        DnaModifierMachineEntity.this.progress = value;
                        break;
                    }
                    case 1: {
                        DnaModifierMachineEntity.this.maxProgress = value;
                    }
                }
            }

            public int getCount() {
                return 2;
            }
        };
        this.init();
    }

    public void init() {
    }

    /*
     * Unable to fully structure code
     */
    public void localTick(Level lvl, DnaModifierMachineEntity be) {
        block7: {
            block8: {
                block9: {
                    upperSlot = (ItemStack)be.items.get(0);
                    lowerSlot = (ItemStack)be.items.get(1);
                    if (lvl.isClientSide) break block7;
                    if (this.result == ItemStack.EMPTY) {
                        this.result = this.determineResult(be);
                        be.progress = 0;
                        return;
                    }
                    slot2 = (ItemStack)be.getItems().get(2);
                    if (slot2.getCount() >= slot2.getMaxStackSize() && !slot2.isEmpty() && !ItemStack.isSameItemSameComponents((ItemStack)slot2, (ItemStack)this.result)) break block8;
                    if (be.progress < this.maxProgress) break block9;
                    if (slot2.isEmpty()) {
                        be.items.set(2, (Object)this.result);
                    } else {
                        slot2.grow(1);
                        be.items.set(2, (Object)slot2);
                    }
                    upperSlot.shrink(1);
                    lowerSlot.shrink(1);
                    be.progress = 0;
                    this.result = ItemStack.EMPTY;
                    break block7;
                }
                var7_6 = upperSlot.getItem();
                if (!(var7_6 instanceof GenderSpawnEgg)) ** GOTO lbl-1000
                egg = (GenderSpawnEgg)var7_6;
                if (!lowerSlot.isEmpty()) {
                    be.progress += 5;
                } else if (!upperSlot.isEmpty() && !lowerSlot.isEmpty()) {
                    ++be.progress;
                } else {
                    be.progress = 0;
                    this.result = ItemStack.EMPTY;
                }
                break block7;
            }
            be.progress = 0;
            this.result = ItemStack.EMPTY;
        }
        be.setChanged();
    }

    private ItemStack determineResult(DnaModifierMachineEntity be) {
        ItemStack upperSlot = (ItemStack)be.items.get(0);
        ItemStack lowerSlot = (ItemStack)be.items.get(1);
        if (lowerSlot.getItem() instanceof PlantDnaItem) {
            ItemStack result = lowerSlot.copy();
            result.setCount(1);
            Item item = upperSlot.getItem();
            if (item instanceof GeneItem) {
                GeneItem geneItem = (GeneItem)item;
                JSGene gene = geneItem.getGene();
                if (this.canAddGene(lowerSlot, gene)) {
                    this.addGeneToDNAResult(result, geneItem.getGene());
                    return result;
                }
            } else if (upperSlot.getItem() instanceof PlantDnaItem) {
                JSGeneData down = JSGeneUtil.readFromStack(lowerSlot);
                JSGeneData up = JSGeneUtil.readFromStack(upperSlot);
                if (this.isCombinationValid(up, down)) {
                    return this.getMergeDNAResult(lowerSlot, upperSlot);
                }
            }
            return ItemStack.EMPTY;
        }
        Item geneItem = lowerSlot.getItem();
        if (!(geneItem instanceof AnimalAttachment)) {
            return ItemStack.EMPTY;
        }
        AnimalAttachment dnaItem = (AnimalAttachment)geneItem;
        ItemStack result = lowerSlot.copy();
        result.setCount(1);
        Item up = upperSlot.getItem();
        if (up instanceof GeneItem) {
            GeneItem geneItem2 = (GeneItem)up;
            JSGene gene = geneItem2.getGene();
            if (dnaItem.getAnimal().getAnimalAttributes().getGeneticProperties().isGeneSupported(gene) && this.canAddGene(lowerSlot, gene)) {
                this.addGeneToDNAResult(result, geneItem2.getGene());
                return result;
            }
        } else if (upperSlot.getItem() instanceof DnaItem || upperSlot.getItem() instanceof OtherDnaItem) {
            JSGeneData down = JSGeneUtil.readFromStack(lowerSlot);
            JSGeneData up2 = JSGeneUtil.readFromStack(upperSlot);
            if (up2.getAnimal() != null && !down.getDataOwnerName().equals(up2.getDataOwnerName()) && up2.getAnimal().getAnimalAttributes().getMiscProperties().isExtinct()) {
                return ItemStack.EMPTY;
            }
            if (this.isCombinationValid(up2, down)) {
                return this.getMergeDNAResult(lowerSlot, upperSlot);
            }
        }
        return ItemStack.EMPTY;
    }

    private boolean isCombinationValid(JSGeneData up, JSGeneData down) {
        boolean isValidCombination = false;
        if (down.getDataOwnerName().equals(up.getDataOwnerName())) {
            if (down.getBaseQuality() == 100) {
                return false;
            }
            if (down.hasDonor() && up.hasDonor() && down.getDonorName().equals(up.getDonorName()) || !down.hasDonor() && up.hasDonor() || down.hasDonor() && !up.hasDonor() || !down.hasDonor() && !up.hasDonor()) {
                isValidCombination = true;
            }
        } else {
            if (up.hasDonor()) {
                return false;
            }
            if (down.hasDonor()) {
                if (up.getDataOwnerName().equals(down.getDonorName()) && down.getTotalCompletion() < 100) {
                    isValidCombination = true;
                }
            } else if (down.isCompatibleWith(up.getDonorName())) {
                isValidCombination = true;
            }
        }
        return isValidCombination;
    }

    private ItemStack getMergeDNAResult(ItemStack lower, ItemStack upper) {
        JSGeneData upperData = JSGeneUtil.readFromStack(upper);
        JSGeneData lowerData = JSGeneUtil.readFromStack(lower);
        JSGeneData data1 = lowerData.combine(upperData);
        ItemStack res = new ItemStack((ItemLike)lower.getItem(), 1);
        JSGeneUtil.writeToStack(res, data1);
        return res;
    }

    private boolean canAddGene(ItemStack result, JSGene gene) {
        JSGeneData data = JSGeneUtil.readFromStack(result);
        return data.canAccept(gene) && data.canAddGene(gene);
    }

    private void addGeneToDNAResult(ItemStack result, JSGene gene) {
        JSGeneData data = JSGeneUtil.readFromStack(result);
        data.addGene(gene);
        JSGeneUtil.writeToStack(result, data);
    }

    @Nullable
    public AbstractContainerMenu createMenu(int p_39954_, @NotNull Inventory p_39955_, @NotNull Player p_39956_) {
        return new DnaModifierMachineMenu(p_39954_, p_39955_, this, this.data);
    }

    @Override
    public void workTick(Level level, GenericMachineEntity be, BlockState state, BlockPos pos) {
        if (be instanceof DnaModifierMachineEntity) {
            DnaModifierMachineEntity e = (DnaModifierMachineEntity)be;
            e.localTick(level, e);
        }
    }

    public void onTookFromOutputSlot(ItemStack stack) {
        this.result = null;
        this.progress = 0;
    }

    @Override
    public ContainerData getContainerData() {
        return this.data;
    }
}

