/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.block.entity.geo.machine;

import com.google.common.base.Supplier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import jp.jurassicsaga.server.base.animal.JSAnimals;
import jp.jurassicsaga.server.base.animal.obj.JSAnimal;
import jp.jurassicsaga.server.base.generic.gene.JSGeneUtil;
import jp.jurassicsaga.server.base.generic.gene.JSGenetics;
import jp.jurassicsaga.server.base.generic.gene.obj.GeneType;
import jp.jurassicsaga.server.base.generic.gene.obj.JSDefaultEntityData;
import jp.jurassicsaga.server.base.generic.gene.obj.JSGeneData;
import jp.jurassicsaga.server.base.generic.gene.obj.JSPlantData;
import jp.jurassicsaga.server.base.generic.obj.Era;
import jp.jurassicsaga.server.base.generic.obj.ResultType;
import jp.jurassicsaga.server.base.generic.obj.SampleColour;
import jp.jurassicsaga.server.base.item.JSDataComponents;
import jp.jurassicsaga.server.base.item.obj.FossilItem;
import jp.jurassicsaga.server.base.item.obj.genetics.DnaItem;
import jp.jurassicsaga.server.base.item.obj.genetics.PlantDnaItem;
import jp.jurassicsaga.server.base.item.obj.genetics.SyringeItem;
import jp.jurassicsaga.server.v1.block.JSV1Blocks;
import jp.jurassicsaga.server.v1.block.entity.JSV1BlockEntities;
import jp.jurassicsaga.server.v1.block.entity.geo.machine.GenericMachineEntity;
import jp.jurassicsaga.server.v1.menu.obj.machine.GeneticAnalyzerMachineMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomModelData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import travelers.server.animal.obj.misc.AnimalType;

public class GeneticAnalyzerMachineEntity
extends GenericMachineEntity {
    private final ContainerData data;
    private static final HashMap<ResultType, HashMap<Era, ArrayList<AnalyzerResult>>> resultPossibilityHashMap = new HashMap();
    private ItemStack currentAnalyzerItem = ItemStack.EMPTY;
    private int currentAnalyzingSlotIndex = -1;
    private int progress = 0;
    private int maxProgress = 100;
    private ItemStack resultItem = ItemStack.EMPTY;

    public GeneticAnalyzerMachineEntity(BlockPos pos, BlockState state) {
        super(19, (Block)JSV1Blocks.GENETIC_ANALYZER.get(), (BlockEntityType)JSV1BlockEntities.GENETIC_ANALYZER.get(), pos, state);
        this.data = new ContainerData(){

            public int get(int index) {
                return switch (index) {
                    case 0 -> GeneticAnalyzerMachineEntity.this.progress;
                    case 1 -> GeneticAnalyzerMachineEntity.this.maxProgress;
                    default -> 0;
                };
            }

            public void set(int index, int value) {
                switch (index) {
                    case 0: {
                        GeneticAnalyzerMachineEntity.this.progress = value;
                        break;
                    }
                    case 1: {
                        GeneticAnalyzerMachineEntity.this.maxProgress = value;
                    }
                }
            }

            public int getCount() {
                return 2;
            }
        };
        if (resultPossibilityHashMap.isEmpty()) {
            GeneticAnalyzerMachineEntity.init();
        }
    }

    private static void init() {
        JSGenetics.PLANT_GENETIC_INFORMATION.forEach((string, jsPlantData) -> {
            resultPossibilityHashMap.putIfAbsent(ResultType.PLANT, new HashMap());
            HashMap resultHashMap = resultPossibilityHashMap.getOrDefault((Object)ResultType.PLANT, new HashMap());
            for (Era supportedEra : jsPlantData.supported_eras) {
                ArrayList<AnalyzerResult> list = resultHashMap.getOrDefault((Object)supportedEra, new ArrayList());
                list.add(new AnalyzerResult(new AnalyzerChanceItem((Item)jsPlantData.coin.get(), 15), new AnalyzerChanceItem(Items.GRAVEL, 30), new AnalyzerChanceItem(Items.SAND, 10), new AnalyzerChanceItem(Items.COAL, 20)));
                resultHashMap.put(supportedEra, list);
            }
            resultPossibilityHashMap.put(ResultType.PLANT, resultHashMap);
        });
        for (JSAnimal<?> animal : JSAnimals.getAnimals()) {
            ArrayList<AnalyzerResult> list;
            HashMap resultHashMap;
            if (!animal.getAnimalAttributes().getMiscProperties().isExtinct() || animal.getItems().getCoin() == null) continue;
            AnimalType type = animal.getAnimalAttributes().getEntityBaseProperties().getAnimalType();
            Era era = animal.getAnimalAttributes().getMiscProperties().getEra();
            if (type == AnimalType.AQUATIC_MAMMAL || type == AnimalType.AQUATIC_REPTILE || type == AnimalType.FISH || type == AnimalType.AMPHIBIAN) {
                resultPossibilityHashMap.putIfAbsent(ResultType.AQUATIC, new HashMap());
                resultHashMap = resultPossibilityHashMap.getOrDefault((Object)ResultType.AQUATIC, new HashMap());
                list = resultHashMap.getOrDefault((Object)era, new ArrayList());
                list.add(new AnalyzerResult(new AnalyzerChanceItem((Item)animal.getItems().getCoin().get(), 30), new AnalyzerChanceItem(Items.GRAVEL, 15), new AnalyzerChanceItem(Items.SAND, 10), new AnalyzerChanceItem(Items.COAL, 20)));
                resultHashMap.put(era, list);
                resultPossibilityHashMap.put(ResultType.AQUATIC, resultHashMap);
            } else if (type == AnimalType.SYNAPSID || type == AnimalType.INSECT || type == AnimalType.CEPHALOPOD) {
                resultPossibilityHashMap.putIfAbsent(ResultType.BUG, new HashMap());
                resultHashMap = resultPossibilityHashMap.getOrDefault((Object)ResultType.BUG, new HashMap());
                list = resultHashMap.getOrDefault((Object)era, new ArrayList());
                list.add(new AnalyzerResult(new AnalyzerChanceItem((Item)animal.getItems().getCoin().get(), 30), new AnalyzerChanceItem(Items.GRAVEL, 15), new AnalyzerChanceItem(Items.DIRT, 10), new AnalyzerChanceItem(Items.COAL, 20)));
                resultHashMap.put(era, list);
                resultPossibilityHashMap.put(ResultType.AQUATIC, resultHashMap);
            } else {
                resultPossibilityHashMap.putIfAbsent(ResultType.LAND, new HashMap());
                resultHashMap = resultPossibilityHashMap.getOrDefault((Object)ResultType.LAND, new HashMap());
                list = resultHashMap.getOrDefault((Object)era, new ArrayList());
                list.add(new AnalyzerResult(new AnalyzerChanceItem((Item)animal.getItems().getCoin().get(), 30), new AnalyzerChanceItem(Items.GRAVEL, 15), new AnalyzerChanceItem(Items.COBBLESTONE, 10), new AnalyzerChanceItem(Items.COAL, 20)));
                resultHashMap.put(era, list);
                resultPossibilityHashMap.put(ResultType.LAND, resultHashMap);
            }
            if (type != AnimalType.AMPHIBIAN) continue;
            resultPossibilityHashMap.putIfAbsent(ResultType.LAND, new HashMap());
            resultHashMap = resultPossibilityHashMap.getOrDefault((Object)ResultType.LAND, new HashMap());
            list = resultHashMap.getOrDefault((Object)era, new ArrayList());
            list.add(new AnalyzerResult(new AnalyzerChanceItem((Item)animal.getItems().getCoin().get(), 30), new AnalyzerChanceItem(Items.GRAVEL, 15), new AnalyzerChanceItem(Items.COBBLESTONE, 10), new AnalyzerChanceItem(Items.COAL, 20)));
            resultHashMap.put(era, list);
            resultPossibilityHashMap.put(ResultType.LAND, resultHashMap);
        }
    }

    public void localTick(Level level) {
        block5: {
            block6: {
                block4: {
                    if (level.isClientSide) {
                        return;
                    }
                    if (this.currentAnalyzingSlotIndex != -1 && !this.currentAnalyzerItem.isEmpty()) break block4;
                    this.progress = 0;
                    for (int i = 0; i < 9; ++i) {
                        ItemStack stack = (ItemStack)this.getItems().get(i);
                        if (!this.isValidItem(stack)) continue;
                        this.currentAnalyzerItem = stack;
                        this.currentAnalyzingSlotIndex = i;
                        this.progress = 0;
                        this.resultItem = ItemStack.EMPTY;
                        return;
                    }
                    break block5;
                }
                if (!this.resultItem.isEmpty()) break block6;
                if (this.progress++ < this.maxProgress) break block5;
                this.createResult(level);
                this.progress = 0;
                break block5;
            }
            for (int i = 9; i < 19; ++i) {
                ItemStack slotStack = (ItemStack)this.getItems().get(i);
                if (slotStack.isEmpty()) {
                    this.getItems().set(i, (Object)this.resultItem.copy());
                    this.consumeInput();
                    return;
                }
                if (!ItemStack.isSameItemSameComponents((ItemStack)slotStack, (ItemStack)this.resultItem) || slotStack.getCount() + this.resultItem.getCount() > slotStack.getMaxStackSize()) continue;
                slotStack.grow(this.resultItem.getCount());
                this.consumeInput();
                return;
            }
        }
    }

    private void consumeInput() {
        this.currentAnalyzerItem.shrink(1);
        if (this.currentAnalyzerItem.isEmpty()) {
            this.currentAnalyzerItem = ItemStack.EMPTY;
            this.currentAnalyzingSlotIndex = -1;
        }
        this.resultItem = ItemStack.EMPTY;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createResult(Level level) {
        Item data;
        Item item = this.currentAnalyzerItem.getItem();
        if (item instanceof SyringeItem) {
            SyringeItem syringeItem = (SyringeItem)item;
            data = (CustomModelData)this.currentAnalyzerItem.get(DataComponents.CUSTOM_MODEL_DATA);
            boolean isPlant = false;
            if (data != null) {
                isPlant = data.equals((Object)SampleColour.PLANT.model());
            }
            String component = (String)this.currentAnalyzerItem.getOrDefault((DataComponentType)JSDataComponents.SPECIES_NAME.get(), (Object)"");
            if (isPlant) {
                Supplier<Item> coin;
                JSPlantData plantData = JSGenetics.PLANT_GENETIC_INFORMATION.get(ResourceLocation.bySeparator((String)component, (char)':').getPath());
                if (plantData == null || (coin = plantData.coin) == null) return;
                this.resultItem = ((Item)coin.get()).getDefaultInstance();
                return;
            }
            if (component.contains("minecraft:")) {
                try {
                    Supplier<Item> coin;
                    EntityType entityType = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.bySeparator((String)component, (char)':'));
                    JSDefaultEntityData geneData = JSGenetics.ENTITY_DEFAULT_GENE_DATA.get(entityType);
                    if (geneData == null || (coin = geneData.coin()) == null) return;
                    this.resultItem = new ItemStack((ItemLike)coin.get());
                    JSGeneUtil.writeToStack(this.resultItem, geneData.geneData());
                    return;
                }
                catch (Exception e) {
                    return;
                }
            } else {
                JSAnimal<?> animal = JSAnimals.getAnimal((String)this.currentAnalyzerItem.getOrDefault((DataComponentType)JSDataComponents.SPECIES_NAME.get(), (Object)""));
                if (animal == null || animal.getItems().getCoin() == null) return;
                Item coin = (Item)animal.getItems().getCoin().get();
                JSGeneData genes = animal.getAnimalAttributes().getGeneticProperties().getDefaultGenetics();
                this.resultItem = new ItemStack((ItemLike)coin);
                genes.setDataOwnerName(animal.getAnimalAttributes().getModId() + ":" + animal.getAnimalAttributes().getAnimalName().toLowerCase(Locale.ROOT));
                JSGeneUtil.writeToStack(this.resultItem, genes);
            }
            return;
        }
        data = this.currentAnalyzerItem.getItem();
        if (!(data instanceof FossilItem)) {
            return;
        }
        FossilItem fossilItem = (FossilItem)data;
        ResultType type = fossilItem.getResult().getResultType();
        ArrayList<AnalyzerResult> results = resultPossibilityHashMap.get((Object)type).get((Object)fossilItem.getEra());
        if (results == null || results.isEmpty()) {
            return;
        }
        AnalyzerResult result = results.get(level.random.nextInt(results.size()));
        int totalWeight = 0;
        for (AnalyzerChanceItem item2 : result.getChanceItems()) {
            totalWeight += item2.chance();
        }
        int roll = level.random.nextInt(totalWeight);
        int sum = 0;
        for (AnalyzerChanceItem item3 : result.getChanceItems()) {
            Object geneData;
            if (roll >= (sum += item3.chance())) continue;
            this.resultItem = new ItemStack((ItemLike)item3.item());
            Item item4 = item3.item();
            if (item4 instanceof DnaItem) {
                DnaItem dnaItem = (DnaItem)item4;
                geneData = dnaItem.getAnimal().getAnimalAttributes().getGeneticProperties().getDefaultGenetics();
                JSGeneData newData = ((JSGeneData)geneData).copy();
                newData.setBaseQuality(this.random.nextInt(20, 40));
                this.resultItem.set((DataComponentType)JSDataComponents.GENE_DATA.get(), (Object)newData.saveToNbt(new CompoundTag()));
                return;
            }
            geneData = item3.item();
            if (!(geneData instanceof PlantDnaItem)) return;
            PlantDnaItem dnaItem = (PlantDnaItem)((Object)geneData);
            geneData = dnaItem.getGeneData();
            JSGeneData newData = ((JSGeneData)geneData).copy();
            newData.setGeneType(GeneType.PLANT);
            newData.setBaseQuality(this.random.nextInt(20, 40));
            this.resultItem.set((DataComponentType)JSDataComponents.GENE_DATA.get(), (Object)newData.saveToNbt(new CompoundTag()));
            return;
        }
    }

    private boolean isValidItem(ItemStack stack) {
        FossilItem fossilItem;
        Object era;
        Item item = stack.getItem();
        if (item instanceof FossilItem && JSAnimals.hasEra((Era)((Object)(era = (fossilItem = (FossilItem)item).getEra())))) {
            ResultType type = fossilItem.getResult().getResultType();
            return resultPossibilityHashMap.containsKey((Object)type);
        }
        era = stack.getItem();
        if (era instanceof SyringeItem) {
            SyringeItem syringeItem = (SyringeItem)era;
            boolean hasNone = ((String)stack.getOrDefault((DataComponentType)JSDataComponents.SPECIES_NAME.get(), (Object)"")).isEmpty();
            return !hasNone;
        }
        return false;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, @NotNull Inventory playerInv, @NotNull Player player) {
        return new GeneticAnalyzerMachineMenu(id, playerInv, this, this.data);
    }

    @Override
    public void workTick(Level level, GenericMachineEntity be, BlockState state, BlockPos pos) {
        if (be instanceof GeneticAnalyzerMachineEntity) {
            GeneticAnalyzerMachineEntity geneticAnalyzer = (GeneticAnalyzerMachineEntity)be;
            geneticAnalyzer.localTick(level);
        }
    }

    @Override
    public ContainerData getContainerData() {
        return this.data;
    }

    public static HashMap<ResultType, HashMap<Era, ArrayList<AnalyzerResult>>> getResultPossibilityHashMap() {
        return resultPossibilityHashMap;
    }

    private static class AnalyzerResult {
        private final AnalyzerChanceItem[] chanceItems;

        public AnalyzerResult(AnalyzerChanceItem ... chanceItems) {
            this.chanceItems = chanceItems;
        }

        public AnalyzerChanceItem[] getChanceItems() {
            return this.chanceItems;
        }
    }

    private record AnalyzerChanceItem(Item item, int chance) {
    }
}

