/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.block.obj.entity.feeder;

import com.mojang.serialization.MapCodec;
import jp.jurassicsaga.server.base.block.obj.entity.GenericMachine;
import jp.jurassicsaga.server.v1.block.entity.geo.machine.feeder.AquaticFeederEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AquaticFeeder
extends GenericMachine
implements SimpleWaterloggedBlock {
    private final MapCodec<AquaticFeeder> codec = AquaticFeeder.simpleCodec(AquaticFeeder::new);

    public AquaticFeeder(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        Direction direction = ((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getOpposite();
        BlockPos adjacentPos = pos.relative(direction);
        return level.getBlockState(adjacentPos).isFaceSturdy((BlockGetter)level, adjacentPos, direction.getOpposite());
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        Direction clickedFace = pContext.getClickedFace();
        if (clickedFace.getAxis().isVertical()) {
            return null;
        }
        BlockState state = (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)clickedFace);
        FluidState fluidstate = pContext.getLevel().getFluidState(pContext.getClickedPos());
        return this.canSurvive(state, (LevelReader)pContext.getLevel(), pContext.getClickedPos()) ? (BlockState)state.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.is(FluidTags.WATER) && fluidstate.getAmount() == 8)) : null;
    }

    @Override
    @NotNull
    protected InteractionResult useWithoutItem(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hitResult) {
        BlockEntity entity = level.getBlockEntity(pos);
        if (entity instanceof AquaticFeederEntity) {
            AquaticFeederEntity machine = (AquaticFeederEntity)entity;
            if (player.isShiftKeyDown()) {
                machine.dispense();
            } else if (!level.isClientSide) {
                machine.openMenu(player);
            }
            return InteractionResult.SUCCESS_NO_ITEM_USED;
        }
        throw new IllegalStateException("JS Container provider is missing!");
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.NORTH -> Block.box((double)-12.0, (double)-12.0, (double)9.0, (double)28.0, (double)28.0, (double)16.0);
            case Direction.EAST -> Block.box((double)0.0, (double)-12.0, (double)-12.0, (double)7.0, (double)28.0, (double)28.0);
            case Direction.SOUTH -> Block.box((double)-12.0, (double)-12.0, (double)0.0, (double)28.0, (double)28.0, (double)7.0);
            default -> Block.box((double)9.0, (double)-12.0, (double)-12.0, (double)16.0, (double)28.0, (double)28.0);
        };
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return this.codec;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new AquaticFeederEntity(pos, state);
    }
}

