/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.world.tree.placer;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.BiConsumer;
import jp.jurassicsaga.server.v1.world.tree.JSV1TrunkPlacerTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import org.jetbrains.annotations.NotNull;

public class GordonopterisTrunkGrower
extends TrunkPlacer {
    public static final MapCodec<GordonopterisTrunkGrower> CODEC = RecordCodecBuilder.mapCodec(p_70161_ -> GordonopterisTrunkGrower.trunkPlacerParts((RecordCodecBuilder.Instance)p_70161_).apply((Applicative)p_70161_, GordonopterisTrunkGrower::new));

    public GordonopterisTrunkGrower(int baseHeight, int heightRandA, int heightRandB) {
        super(baseHeight, heightRandA, heightRandB);
    }

    @NotNull
    protected TrunkPlacerType<?> type() {
        return (TrunkPlacerType)JSV1TrunkPlacerTypes.GORDONOPTERIS.get();
    }

    @NotNull
    public List<FoliagePlacer.FoliageAttachment> placeTrunk(@NotNull LevelSimulatedReader level, @NotNull BiConsumer<BlockPos, BlockState> blockSetter, @NotNull RandomSource random, int freeTreeHeight, BlockPos pos, @NotNull TreeConfiguration config) {
        GordonopterisTrunkGrower.setDirtAt((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)pos.below(), (TreeConfiguration)config);
        int height = this.baseHeight + random.nextInt(this.heightRandA + 1) + random.nextInt(this.heightRandB + 1);
        if (height < 2) {
            height = 2;
        }
        if (height > 4) {
            height = 4;
        }
        BlockPos topPos = pos;
        for (int i = 0; i < height; ++i) {
            topPos = pos.above(i);
            blockSetter.accept(topPos, config.trunkProvider.getState(random, pos));
        }
        this.placeCrown(level, blockSetter, random, topPos, config);
        return ImmutableList.of((Object)new FoliagePlacer.FoliageAttachment(topPos, 0, false));
    }

    private void placeCrown(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, BlockPos pos, TreeConfiguration config) {
        BlockState leaves = config.foliageProvider.getState(random, pos);
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                this.tryPlaceLeaf(level, blockSetter, pos.offset(dx, 0, dz), leaves);
            }
        }
        this.tryPlaceLeaf(level, blockSetter, pos.north(2).above(1), leaves);
        this.tryPlaceLeaf(level, blockSetter, pos.south(2).above(1), leaves);
        this.tryPlaceLeaf(level, blockSetter, pos.east(2).above(1), leaves);
        this.tryPlaceLeaf(level, blockSetter, pos.west(2).above(1), leaves);
        this.tryPlaceLeaf(level, blockSetter, pos.above(), leaves);
    }

    private void tryPlaceLeaf(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, BlockPos pos, BlockState state) {
        if (this.isValid(level, pos)) {
            blockSetter.accept(pos, state);
        }
    }

    public boolean isValid(LevelSimulatedReader pLevel, BlockPos pPos) {
        return pLevel.isStateAtPosition(pPos, BlockBehaviour.BlockStateBase::isAir);
    }
}

