/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.client.base.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import jp.jurassicsaga.server.base.entity.obj.other.PaddockSignEntity;
import jp.jurassicsaga.server.util.JSHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import org.jetbrains.annotations.NotNull;

public class PaddockSignRenderer
extends EntityRenderer<PaddockSignEntity> {
    public PaddockSignRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.shadowStrength = 0.0f;
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull PaddockSignEntity entity) {
        return Minecraft.getInstance().getPaintingTextures().getBackSprite().atlasLocation();
    }

    protected float getShadowRadius(PaddockSignEntity entity) {
        return 0.0f;
    }

    public void render(PaddockSignEntity pEntity, float pEntityYaw, float pPartialTick, PoseStack stack, MultiBufferSource pBufferSource, int pPackedLight) {
        String animalStr = pEntity.getAnimalStr();
        if (animalStr.isEmpty()) {
            return;
        }
        stack.pushPose();
        Direction direction = pEntity.getDirection();
        stack.mulPose(Axis.YP.rotationDegrees(direction.toYRot()));
        if (direction == Direction.EAST || direction == Direction.WEST) {
            stack.scale(-1.0f, 1.0f, -1.0f);
        }
        stack.translate(-0.5f, -0.5f, -0.5f);
        BakedModel model = JSHelper.jsClientPlatform.getBakedModel(ResourceLocation.fromNamespaceAndPath((String)"jurassicsaga", (String)("signs/paddock/" + animalStr)));
        MultiBufferSource.BufferSource bufferSource = Minecraft.getInstance().renderBuffers().bufferSource();
        VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)InventoryMenu.BLOCK_ATLAS));
        for (BakedQuad quad : JSHelper.jsClientPlatform.getQuads(model, RandomSource.create())) {
            vertexConsumer.putBulkData(stack.last(), quad, 1.0f, 1.0f, 1.0f, 1.0f, pPackedLight, OverlayTexture.NO_OVERLAY);
        }
        stack.popPose();
    }
}

