/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.client.base.renderer.layer;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import mod.azure.azurelib.rewrite.model.AzBone;
import mod.azure.azurelib.rewrite.render.AzRendererPipelineContext;
import mod.azure.azurelib.rewrite.render.layer.AzRenderLayer;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LightLayer;
import travelers.server.animal.entity.SmartAnimalBase;

public class LuxLayer
implements AzRenderLayer<SmartAnimalBase> {
    public static final Map<UUID, Float> previousBrightness = new HashMap<UUID, Float>();

    public void preRender(AzRendererPipelineContext<SmartAnimalBase> azRendererPipelineContext) {
    }

    public void render(AzRendererPipelineContext<SmartAnimalBase> context) {
    }

    public float getLerpedBrightness(JSAnimalBase base) {
        UUID id = base.getUUID();
        boolean isDay = base.level().getDayTime() % 24000L < 12000L;
        float brightnessSky = isDay ? (float)base.level().getBrightness(LightLayer.SKY, base.blockPosition()) : 0.0f;
        float brightnessGround = base.level().getBrightness(LightLayer.BLOCK, base.blockPosition());
        float blockLight = Math.min(15.0f, brightnessGround + brightnessSky);
        float invertedBlockLight = 15.0f - blockLight;
        float previous = previousBrightness.getOrDefault(id, Float.valueOf(invertedBlockLight)).floatValue();
        float lerped = Mth.lerp((float)0.0025f, (float)previous, (float)invertedBlockLight);
        previousBrightness.put(id, Float.valueOf(lerped));
        return lerped;
    }

    public int getHueShiftColor(int seed, float brightness) {
        Random random = new Random(seed);
        float brightnessFactor = Mth.clamp((float)(brightness / 15.0f), (float)0.0f, (float)1.0f);
        float hueShift = random.nextFloat();
        float saturation = Mth.lerp((float)brightnessFactor, (float)1.0f, (float)(random.nextFloat(0.1f) + 0.45f));
        int rgb = Color.HSBtoRGB(hueShift, saturation, brightnessFactor);
        int alpha = (int)(brightnessFactor * 255.0f);
        return alpha << 24 | rgb & 0xFFFFFF;
    }

    public void renderForBone(AzRendererPipelineContext<SmartAnimalBase> azRendererPipelineContext, AzBone azBone) {
    }
}

