/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.client.v1.screen.machine;

import jp.jurassicsaga.client.base.screen.obj.machine.GenericScreen;
import jp.jurassicsaga.server.v1.menu.obj.machine.DnaModifierMachineMenu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class DnaModifierMachineScreen
extends GenericScreen<DnaModifierMachineMenu> {
    private static final ResourceLocation BG_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"jurassicsaga", (String)"textures/gui/container/machine/dna_combinator_gui.png");
    private static final ResourceLocation PROGRESS_STEP1 = ResourceLocation.fromNamespaceAndPath((String)"jurassicsaga", (String)"textures/gui/sprites/machine/dna_modifier/step_1.png");
    private static final ResourceLocation PROGRESS_STEP2 = ResourceLocation.fromNamespaceAndPath((String)"jurassicsaga", (String)"textures/gui/sprites/machine/dna_modifier/step_2.png");
    private static final ResourceLocation PROGRESS_STEP3 = ResourceLocation.fromNamespaceAndPath((String)"jurassicsaga", (String)"textures/gui/sprites/machine/dna_modifier/step_3_left.png");
    private static final ResourceLocation PROGRESS_STEP3_RIGHT = ResourceLocation.fromNamespaceAndPath((String)"jurassicsaga", (String)"textures/gui/sprites/machine/dna_modifier/step_3_right.png");
    private static final int STEP1_END = 30;
    private static final int STEP2_END = 60;
    private static final int FINAL_STEP_END = 130;
    private float smoothProgress = 0.0f;

    public DnaModifierMachineScreen(DnaModifierMachineMenu menu, Inventory inv, Component title) {
        super(menu, inv, title);
    }

    protected void renderBg(GuiGraphics g, float partialTick, int mouseX, int mouseY) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        g.blit(BG_LOCATION, x - 4, y - 28, 0, 0, 183, 194);
        int realProgress = ((DnaModifierMachineMenu)this.menu).getData().get(0);
        this.smoothProgress = this.lerp(this.smoothProgress, realProgress, 0.2f);
        if (realProgress > 0) {
            g.blit(PROGRESS_STEP1, x + 82, y + 2, 0.0f, 0.0f, 12, this.getScaled(this.smoothProgress, 0, 30, 11), 12, 11);
            g.blit(PROGRESS_STEP2, x + 82, y + 33, 0.0f, 0.0f, 12, this.getScaled(this.smoothProgress, 30, 60, 11), 12, 11);
            int dualProgress = this.getScaled(this.smoothProgress, 60, 130, 52);
            if (dualProgress > 0) {
                g.blit(PROGRESS_STEP3, x + 25, y + 48, 0.0f, 0.0f, dualProgress, 12, 54, 12);
                g.blit(PROGRESS_STEP3_RIGHT, x + 99 + (52 - dualProgress), y + 48, (float)(52 - dualProgress + 2), 0.0f, dualProgress, 12, 54, 12);
            }
        }
    }

    private int getScaled(float progress, int start, int end, int size) {
        if (progress <= (float)start) {
            return 0;
        }
        if (progress >= (float)end) {
            return size;
        }
        return (int)((progress - (float)start) * (float)size / (float)(end - start));
    }

    private float lerp(float a, float b, float alpha) {
        return a + (b - a) * alpha;
    }

    @Override
    public void render(GuiGraphics g, int mouseX, int mouseY, float delta) {
        super.render(g, mouseX, mouseY, delta);
        this.renderTooltip(g, mouseX, mouseY);
    }
}

