/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.neo.data.server;

import java.util.Map;
import java.util.stream.Collectors;
import jp.jurassicsaga.server.base.block.JSBlocks;
import jp.jurassicsaga.server.base.block.obj.group.BasicBlockSetRegistries;
import jp.jurassicsaga.server.base.block.obj.group.ColoredRegistries;
import jp.jurassicsaga.server.base.generic.obj.Era;
import jp.jurassicsaga.server.v1.block.JSV1Blocks;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.packs.VanillaBlockLoot;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import org.jetbrains.annotations.NotNull;

public class JSBlockLootTableProvider
extends VanillaBlockLoot {
    HolderLookup.RegistryLookup<Enchantment> registrylookup;

    public JSBlockLootTableProvider(HolderLookup.Provider registries) {
        super(registries);
        this.registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
    }

    protected void generate() {
        this.dropSelf((Block)JSV1Blocks.CULTIVATOR.get());
        this.dropSelf((Block)JSV1Blocks.DNA_MODIFIER.get());
        this.dropSelf((Block)JSV1Blocks.GENETIC_ANALYZER.get());
        this.dropSelf((Block)JSV1Blocks.GENE_EXTRACTOR.get());
        this.dropSelf((Block)JSV1Blocks.INCUBATOR.get());
        this.dropSelf((Block)JSV1Blocks.BUG_ZAPPER.get());
        this.dropSelf((Block)JSV1Blocks.CARNIVORE_FEEDER.get());
        this.dropSelf((Block)JSV1Blocks.HERBIVORE_FEEDER.get());
        this.dropSelf((Block)JSV1Blocks.AQUATIC_FEEDER.get());
        this.add((Block)JSV1Blocks.GLASS_DOOR.get(), this.createDoorTable((Block)JSV1Blocks.GLASS_DOOR.get()));
        this.dropColoredDoor(JSV1Blocks.COLORED_GLASS_DOORS);
        this.dropSelf((Block)JSV1Blocks.CORRUGATED_IRON.get());
        this.dropSelf((Block)JSV1Blocks.CORRUGATED_IRON_SLAB.get());
        this.dropSelf((Block)JSV1Blocks.CORRUGATED_IRON_STAIR.get());
        this.dropColoredSelf(JSV1Blocks.COLORED_CORRUGATED_IRONS);
        this.dropColoredSelf(JSV1Blocks.COLORED_CORRUGATED_IRONS_SLAB);
        this.dropColoredSelf(JSV1Blocks.COLORED_CORRUGATED_IRONS_STAIR);
        this.dropSelf((Block)JSV1Blocks.ROOF_TILES.get());
        this.dropSelf((Block)JSV1Blocks.ROOF_TILES_SLAB.get());
        this.dropSelf((Block)JSV1Blocks.ROOF_TILES_STAIR.get());
        this.dropColoredSelf(JSV1Blocks.COLORED_ROOF_TILES);
        this.dropColoredSelf(JSV1Blocks.COLORED_ROOF_TILES_SLAB);
        this.dropColoredSelf(JSV1Blocks.COLORED_ROOF_TILES_STAIRS);
        this.dropSelf((Block)JSV1Blocks.THATCH.get());
        this.dropSelf((Block)JSV1Blocks.THATCH_SLAB.get());
        this.dropSelf((Block)JSV1Blocks.THATCH_STAIRS.get());
        this.dropSelf((Block)JSV1Blocks.IRON_PILLAR.get());
        this.dropSelf((Block)JSV1Blocks.BIG_TILE.get());
        this.dropSelf((Block)JSV1Blocks.BIG_TILE_SLAB.get());
        this.dropSelf((Block)JSV1Blocks.BIG_TILE_STAIR.get());
        this.dropSelf((Block)JSV1Blocks.MIXED_PATH.get());
        this.dropSelf((Block)JSV1Blocks.MIXED_PATH_SLAB.get());
        this.dropSelf((Block)JSV1Blocks.MIXED_PATH_STAIR.get());
        this.dropSelf((Block)JSV1Blocks.CAMO_NET.get());
        this.dropWhenSilkTouch((Block)JSV1Blocks.CLEAR_GLASS.get());
        this.dropSelf((Block)JSV1Blocks.REINFORCED_GLASS.get());
        this.dropSelf((Block)JSV1Blocks.HEAVY_DUTY_GRID.get());
        this.dropSelf((Block)JSV1Blocks.HEAVY_DUTY_BARS.get());
        this.dropSelf((Block)JSV1Blocks.ARAUCARIOXYLON.LOG.get());
        this.dropSelf((Block)JSV1Blocks.ARAUCARIOXYLON.WOOD.get());
        this.dropSelf((Block)JSV1Blocks.ARAUCARIOXYLON.STRIPPED_LOG.get());
        this.dropSelf((Block)JSV1Blocks.ARAUCARIOXYLON.STRIPPED_WOOD.get());
        this.dropSelf((Block)JSV1Blocks.ARAUCARIOXYLON.STAIRS.get());
        this.dropSelf((Block)JSV1Blocks.ARAUCARIOXYLON.PRESSURE_PLATE.get());
        this.dropSelf((Block)JSV1Blocks.ARAUCARIOXYLON.BUTTON.get());
        this.dropSelf((Block)JSV1Blocks.ARAUCARIOXYLON.BLOCK.get());
        this.add((Block)JSV1Blocks.ARAUCARIOXYLON.SLAB.get(), x$0 -> this.createSlabItemTable((Block)x$0));
        this.add((Block)JSV1Blocks.ARAUCARIOXYLON.DOOR.get(), x$0 -> this.createDoorTable((Block)x$0));
        this.dropWhenSilkTouch((Block)JSV1Blocks.ARAUCARIOXYLON.LEAVES.get());
        this.dropSelf((Block)JSV1Blocks.ARAUCARIOXYLON.FENCE.get());
        this.dropSelf((Block)JSV1Blocks.ARAUCARIOXYLON.FENCE_GATE.get());
        this.dropSelf((Block)JSV1Blocks.ARAUCARIOXYLON.TRAPDOOR.get());
        this.dropSelf((Block)JSV1Blocks.ARAUCARIOXYLON.SIGN.get());
        this.dropSelf((Block)JSV1Blocks.ARAUCARIOXYLON.WALL_SIGN.get());
        this.dropSelf((Block)JSV1Blocks.ARAUCARIOXYLON.HANGING_SIGN.get());
        this.dropSelf((Block)JSV1Blocks.ARAUCARIOXYLON.HANGING_SIGN_WALL.get());
        this.dropSelf((Block)JSV1Blocks.ARAUCARIOXYLON_SAPLING.get());
        this.dropSelf((Block)JSV1Blocks.GORDONPTERIS.LOG.get());
        this.dropSelf((Block)JSV1Blocks.GORDONPTERIS.WOOD.get());
        this.dropSelf((Block)JSV1Blocks.GORDONPTERIS.STRIPPED_LOG.get());
        this.dropSelf((Block)JSV1Blocks.GORDONPTERIS.STRIPPED_WOOD.get());
        this.dropSelf((Block)JSV1Blocks.GORDONPTERIS.STAIRS.get());
        this.dropSelf((Block)JSV1Blocks.GORDONPTERIS.PRESSURE_PLATE.get());
        this.dropSelf((Block)JSV1Blocks.GORDONPTERIS.BUTTON.get());
        this.dropSelf((Block)JSV1Blocks.GORDONPTERIS.BLOCK.get());
        this.add((Block)JSV1Blocks.GORDONPTERIS.SLAB.get(), x$0 -> this.createSlabItemTable((Block)x$0));
        this.add((Block)JSV1Blocks.GORDONPTERIS.DOOR.get(), x$0 -> this.createDoorTable((Block)x$0));
        this.dropWhenSilkTouch((Block)JSV1Blocks.GORDONPTERIS.LEAVES.get());
        this.dropSelf((Block)JSV1Blocks.GORDONPTERIS.FENCE.get());
        this.dropSelf((Block)JSV1Blocks.GORDONPTERIS.FENCE_GATE.get());
        this.dropSelf((Block)JSV1Blocks.GORDONPTERIS.TRAPDOOR.get());
        this.dropSelf((Block)JSV1Blocks.GORDONPTERIS.SIGN.get());
        this.dropSelf((Block)JSV1Blocks.GORDONPTERIS.WALL_SIGN.get());
        this.dropSelf((Block)JSV1Blocks.GORDONPTERIS.HANGING_SIGN.get());
        this.dropSelf((Block)JSV1Blocks.GORDONPTERIS.HANGING_SIGN_WALL.get());
        this.dropSelf((Block)JSV1Blocks.GORDONPTERIS_SAPLING.get());
        this.dropSelf((Block)JSV1Blocks.LEPIDODENDRON.LOG.get());
        this.dropSelf((Block)JSV1Blocks.LEPIDODENDRON.WOOD.get());
        this.dropSelf((Block)JSV1Blocks.LEPIDODENDRON.STRIPPED_LOG.get());
        this.dropSelf((Block)JSV1Blocks.LEPIDODENDRON.STRIPPED_WOOD.get());
        this.dropSelf((Block)JSV1Blocks.LEPIDODENDRON.STAIRS.get());
        this.dropSelf((Block)JSV1Blocks.LEPIDODENDRON.PRESSURE_PLATE.get());
        this.dropSelf((Block)JSV1Blocks.LEPIDODENDRON.BUTTON.get());
        this.dropSelf((Block)JSV1Blocks.LEPIDODENDRON.BLOCK.get());
        this.add((Block)JSV1Blocks.LEPIDODENDRON.SLAB.get(), x$0 -> this.createSlabItemTable((Block)x$0));
        this.add((Block)JSV1Blocks.LEPIDODENDRON.DOOR.get(), x$0 -> this.createDoorTable((Block)x$0));
        this.dropWhenSilkTouch((Block)JSV1Blocks.LEPIDODENDRON.LEAVES.get());
        this.dropSelf((Block)JSV1Blocks.LEPIDODENDRON.FENCE.get());
        this.dropSelf((Block)JSV1Blocks.LEPIDODENDRON.FENCE_GATE.get());
        this.dropSelf((Block)JSV1Blocks.LEPIDODENDRON.TRAPDOOR.get());
        this.dropSelf((Block)JSV1Blocks.LEPIDODENDRON.SIGN.get());
        this.dropSelf((Block)JSV1Blocks.LEPIDODENDRON.WALL_SIGN.get());
        this.dropSelf((Block)JSV1Blocks.LEPIDODENDRON.HANGING_SIGN.get());
        this.dropSelf((Block)JSV1Blocks.LEPIDODENDRON.HANGING_SIGN_WALL.get());
        this.dropSelf((Block)JSV1Blocks.LEPIDODENDRON_SAPLING.get());
        this.dropSelf((Block)JSV1Blocks.SPINIFRUCTUS.LOG.get());
        this.dropSelf((Block)JSV1Blocks.SPINIFRUCTUS.WOOD.get());
        this.dropSelf((Block)JSV1Blocks.SPINIFRUCTUS.STRIPPED_LOG.get());
        this.dropSelf((Block)JSV1Blocks.SPINIFRUCTUS.STRIPPED_WOOD.get());
        this.dropSelf((Block)JSV1Blocks.SPINIFRUCTUS.STAIRS.get());
        this.dropSelf((Block)JSV1Blocks.SPINIFRUCTUS.PRESSURE_PLATE.get());
        this.dropSelf((Block)JSV1Blocks.SPINIFRUCTUS.BUTTON.get());
        this.dropSelf((Block)JSV1Blocks.SPINIFRUCTUS.BLOCK.get());
        this.add((Block)JSV1Blocks.SPINIFRUCTUS.SLAB.get(), x$0 -> this.createSlabItemTable((Block)x$0));
        this.add((Block)JSV1Blocks.SPINIFRUCTUS.DOOR.get(), x$0 -> this.createDoorTable((Block)x$0));
        this.dropWhenSilkTouch((Block)JSV1Blocks.SPINIFRUCTUS.LEAVES.get());
        this.dropSelf((Block)JSV1Blocks.SPINIFRUCTUS.FENCE.get());
        this.dropSelf((Block)JSV1Blocks.SPINIFRUCTUS.FENCE_GATE.get());
        this.dropSelf((Block)JSV1Blocks.SPINIFRUCTUS.TRAPDOOR.get());
        this.dropSelf((Block)JSV1Blocks.SPINIFRUCTUS.SIGN.get());
        this.dropSelf((Block)JSV1Blocks.SPINIFRUCTUS.WALL_SIGN.get());
        this.dropSelf((Block)JSV1Blocks.SPINIFRUCTUS.HANGING_SIGN.get());
        this.dropSelf((Block)JSV1Blocks.SPINIFRUCTUS.HANGING_SIGN_WALL.get());
        this.dropSelf((Block)JSV1Blocks.SPINIFRUCTUS_SAPLING.get());
        this.dropSelf((Block)JSV1Blocks.ALETHOPTERIS.get());
        this.dropSelf((Block)JSV1Blocks.ARCHAEOMARASMIUS.get());
        this.add((Block)JSV1Blocks.CLADOPHLEBIS.get(), this.createDoublePlantDrop((Block)JSV1Blocks.CLADOPHLEBIS.get()));
        this.dropSelf((Block)JSV1Blocks.CYCADEOIDEA.get());
        this.dropSelf((Block)JSV1Blocks.LADINA_SIMPLEX.get());
        this.add((Block)JSV1Blocks.NEUROPTERIS.get(), this.createDoublePlantDrop((Block)JSV1Blocks.NEUROPTERIS.get()));
        this.dropSelf((Block)JSV1Blocks.SELAGINELLITES.get());
        this.dropSelf((Block)JSV1Blocks.ZINGIBEROPSIS_BASIC.get());
        this.dropSelf((Block)JSV1Blocks.ZINGIBEROPSIS_ORANGE.get());
        this.dropSelf((Block)JSV1Blocks.ZINGIBEROPSIS_PINK.get());
        this.dropSelf((Block)JSV1Blocks.ZINGIBEROPSIS_RED.get());
        this.dropSelf((Block)JSV1Blocks.ZINGIBEROPSIS_WHITE.get());
        this.dropSelf((Block)JSV1Blocks.ZINGIBEROPSIS_YELLOW.get());
        this.add((Block)JSV1Blocks.WEST_INDIAN_LILAC.get(), this.createDoublePlantDrop((Block)JSV1Blocks.WEST_INDIAN_LILAC.get()));
        this.add((Block)JSV1Blocks.HELICONIA.get(), this.createDoublePlantDrop((Block)JSV1Blocks.HELICONIA.get()));
        this.dropSelf((Block)JSV1Blocks.ROYAL_FERN.get());
        this.add((Block)JSV1Blocks.SWISS_CHEESE_PLANT.get(), this.createDoublePlantDrop((Block)JSV1Blocks.SWISS_CHEESE_PLANT.get()));
        this.dropSelf((Block)JSV1Blocks.CAPRINA.get());
        this.dropSelf((Block)JSV1Blocks.CREMNOCERAMUS.get());
        this.dropSelf((Block)JSV1Blocks.HIPPURITES.get());
        this.dropSelf((Block)JSV1Blocks.INOCERAMUS.get());
        this.dropSelf((Block)JSV1Blocks.COBANNIA_CORRUGATA.get());
        this.dropSelf((Block)JSV1Blocks.NEOCALAMITES.get());
        this.dropSelf((Block)JSV1Blocks.OMPHALOPHLOIOS.get());
        this.dropSelf((Block)JSV1Blocks.RHAMNUS_SALICIFOLIUS.get());
        this.dropSelf((Block)JSV1Blocks.TEMPSKYA.get());
        this.add((Block)JSV1Blocks.SECURE_GRID_DOOR.get(), this.createDoorTable((Block)JSV1Blocks.SECURE_GRID_DOOR.get()));
        this.add((Block)JSV1Blocks.GRID_DOOR.get(), this.createDoorTable((Block)JSV1Blocks.GRID_DOOR.get()));
        this.dropSimpleSelf(JSV1Blocks.FACILITY_CONCRETE);
        this.dropSimpleSelf(JSV1Blocks.FACILITY_CONCRETE_BRICKS);
        this.dropSimpleSelf(JSV1Blocks.FACILITY_CONCRETE_BRICKS_CRACKED);
        this.dropSimpleSelf(JSV1Blocks.FACILITY_CONCRETE_BRICKS_MOSSY);
        this.dropSimpleSelf(JSV1Blocks.FACILITY_CONCRETE_CRACKED);
        this.dropSimpleSelf(JSV1Blocks.FACILITY_CONCRETE_MOSSY);
        this.dropSimpleSelf(JSV1Blocks.FACILITY_CONCRETE_PANEL);
        this.dropSimpleSelf(JSV1Blocks.FACILITY_CONCRETE_PANEL_MOSSY);
        this.dropSelf((Block)JSV1Blocks.FACILITY_CONCRETE_PILLAR.get());
        this.dropSelf((Block)JSV1Blocks.FACILITY_CONCRETE_PILLAR_CRACKED.get());
        this.dropSelf((Block)JSV1Blocks.FACILITY_CONCRETE_PILLAR_MOSSY.get());
        this.dropSelf((Block)JSBlocks.BENCH_OAK_LOG.get());
        this.dropSelf((Block)JSBlocks.BENCH_SPRUCE_LOG.get());
        this.dropSelf((Block)JSBlocks.BENCH_BIRCH_LOG.get());
        this.dropSelf((Block)JSBlocks.BENCH_JUNGLE_LOG.get());
        this.dropSelf((Block)JSBlocks.BENCH_ACACIA_LOG.get());
        this.dropSelf((Block)JSBlocks.BENCH_DARK_OAK_LOG.get());
        this.dropSelf((Block)JSBlocks.BENCH_MANGROVE_LOG.get());
        this.dropSelf((Block)JSBlocks.BENCH_CHERRY_LOG.get());
        this.dropSelf((Block)JSBlocks.BENCH_CRIMSON_STEM.get());
        this.dropSelf((Block)JSBlocks.BENCH_WARPED_STEM.get());
        this.dropSelf((Block)JSV1Blocks.BENCH_ARAUCARIOXYLON.get());
        this.dropSelf((Block)JSV1Blocks.BENCH_GORDONOPTERIS.get());
        this.dropSelf((Block)JSV1Blocks.BENCH_LEPIDODENDRON.get());
        this.dropSelf((Block)JSV1Blocks.BENCH_SPINIFRUCTUS.get());
        this.initFossil();
    }

    private void dropSimpleSelf(BasicBlockSetRegistries blockSetRegistries) {
        this.dropSelf((Block)blockSetRegistries.getBLOCK().get());
        this.dropSelf((Block)blockSetRegistries.getSLAB().get());
        this.dropSelf((Block)blockSetRegistries.getSTAIRS().get());
        this.dropSelf((Block)blockSetRegistries.getWALL().get());
    }

    protected LootTable.Builder createDoublePlantDrop(Block sheared) {
        return LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)sheared).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f)))));
    }

    private void initFossil() {
        for (Era value : Era.values()) {
            if (value.isHasFossilOre()) {
                LootPool.Builder poolBuilder = LootPool.lootPool().when(this.hasSilkTouch().invert()).setRolls((NumberProvider)UniformGenerator.between((float)2.0f, (float)4.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BONE).setWeight(60)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.COBBLESTONE).setWeight(100)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.FLINT).setWeight(60));
                value.getRegistryMap().forEach((possibleResult, itemDeferredItem) -> {
                    if (!possibleResult.isAmber()) {
                        poolBuilder.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)itemDeferredItem.get())).setWeight(30).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount((Holder)this.registrylookup.getOrThrow(Enchantments.FORTUNE))));
                    } else {
                        poolBuilder.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)itemDeferredItem.get())).setWeight(1).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount((Holder)this.registrylookup.getOrThrow(Enchantments.FORTUNE))));
                    }
                });
                this.add((Block)value.getFossilOre().get(), LootTable.lootTable().setParamSet(LootContextParamSets.BLOCK).withPool(LootPool.lootPool().when(this.hasSilkTouch()).setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)value.getFossilOre().get())))).withPool(poolBuilder));
            }
            if (!value.isHasMarineOre()) continue;
            this.dropWhenSilkTouch((Block)value.getMarineOre().get());
        }
    }

    private void dropColoredSelf(ColoredRegistries c) {
        this.dropSelf((Block)c.BLACK.get());
        this.dropSelf((Block)c.BLUE.get());
        this.dropSelf((Block)c.BROWN.get());
        this.dropSelf((Block)c.CYAN.get());
        this.dropSelf((Block)c.GREEN.get());
        this.dropSelf((Block)c.GREY.get());
        this.dropSelf((Block)c.LIGHTBLUE.get());
        this.dropSelf((Block)c.LIGHTGREY.get());
        this.dropSelf((Block)c.LIME.get());
        this.dropSelf((Block)c.MAGENTA.get());
        this.dropSelf((Block)c.ORANGE.get());
        this.dropSelf((Block)c.PINK.get());
        this.dropSelf((Block)c.PURPLE.get());
        this.dropSelf((Block)c.RED.get());
        this.dropSelf((Block)c.WHITE.get());
        this.dropSelf((Block)c.YELLOW.get());
    }

    private void dropColoredDoor(ColoredRegistries c) {
        this.add((Block)c.BLACK.get(), this.createDoorTable((Block)c.BLACK.get()));
        this.add((Block)c.BLUE.get(), this.createDoorTable((Block)c.BLUE.get()));
        this.add((Block)c.BROWN.get(), this.createDoorTable((Block)c.BROWN.get()));
        this.add((Block)c.CYAN.get(), this.createDoorTable((Block)c.CYAN.get()));
        this.add((Block)c.GREEN.get(), this.createDoorTable((Block)c.GREEN.get()));
        this.add((Block)c.GREY.get(), this.createDoorTable((Block)c.GREY.get()));
        this.add((Block)c.LIGHTBLUE.get(), this.createDoorTable((Block)c.LIGHTBLUE.get()));
        this.add((Block)c.LIGHTGREY.get(), this.createDoorTable((Block)c.LIGHTGREY.get()));
        this.add((Block)c.LIME.get(), this.createDoorTable((Block)c.LIME.get()));
        this.add((Block)c.MAGENTA.get(), this.createDoorTable((Block)c.MAGENTA.get()));
        this.add((Block)c.ORANGE.get(), this.createDoorTable((Block)c.ORANGE.get()));
        this.add((Block)c.PINK.get(), this.createDoorTable((Block)c.PINK.get()));
        this.add((Block)c.PURPLE.get(), this.createDoorTable((Block)c.PURPLE.get()));
        this.add((Block)c.RED.get(), this.createDoorTable((Block)c.RED.get()));
        this.add((Block)c.WHITE.get(), this.createDoorTable((Block)c.WHITE.get()));
        this.add((Block)c.YELLOW.get(), this.createDoorTable((Block)c.YELLOW.get()));
    }

    @NotNull
    protected Iterable<Block> getKnownBlocks() {
        return BuiltInRegistries.BLOCK.entrySet().stream().filter(e -> ((ResourceKey)e.getKey()).location().getNamespace().equals("jurassicsaga")).map(Map.Entry::getValue).collect(Collectors.toList());
    }
}

