/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.neo.data.server;

import java.util.concurrent.CompletableFuture;
import jp.jurassicsaga.server.base.animal.JSAnimals;
import jp.jurassicsaga.server.base.animal.obj.JSAnimal;
import jp.jurassicsaga.server.base.generic.obj.Era;
import jp.jurassicsaga.server.base.tag.JSItemTags;
import jp.jurassicsaga.server.v1.item.JSV1Items;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.Nullable;
import travelers.server.animal.obj.misc.AnimalType;

public class JSItemTagProvider
extends ItemTagsProvider {
    public JSItemTagProvider(PackOutput p_275343_, CompletableFuture<HolderLookup.Provider> p_275729_, CompletableFuture<TagsProvider.TagLookup<Block>> p_275322_, @Nullable ExistingFileHelper existingFileHelper) {
        super(p_275343_, p_275729_, p_275322_, "jurassicsaga", existingFileHelper);
    }

    protected void addTags(HolderLookup.Provider provider) {
        IntrinsicHolderTagsProvider.IntrinsicTagAppender DNA = this.tag(JSItemTags.DNA);
        for (JSAnimal<?> jSAnimal : JSAnimals.getAnimals()) {
            AnimalType animalType = jSAnimal.getAnimalAttributes().getEntityBaseProperties().getAnimalType();
            if (jSAnimal.getItems().getCoin() != null) {
                DNA.add((Object)((Item)jSAnimal.getItems().getCoin().get()));
            }
            if (jSAnimal.getItems().getFossil_remains() != null) {
                this.tag(JSItemTags.FOSSIL).add((Object)((Item)jSAnimal.getItems().getFossil_remains().get()).asItem());
            }
            if (jSAnimal.getItems().getCookedMeat() != null) {
                if (animalType == AnimalType.AQUATIC_MAMMAL || animalType == AnimalType.AQUATIC_REPTILE || animalType == AnimalType.FISH) {
                    this.tag(JSItemTags.PISCIVORE_EDIBLE).add((Object)((Item)jSAnimal.getItems().getCookedMeat().get()).asItem());
                } else {
                    this.tag(JSItemTags.CARNIVORE_EDIBLE).add((Object)((Item)jSAnimal.getItems().getCookedMeat().get()).asItem());
                }
            }
            if (jSAnimal.getItems().getRawMeat() == null) continue;
            if (animalType == AnimalType.AQUATIC_MAMMAL || animalType == AnimalType.AQUATIC_REPTILE || animalType == AnimalType.FISH) {
                this.tag(JSItemTags.PISCIVORE_EDIBLE).add((Object)((Item)jSAnimal.getItems().getRawMeat().get()).asItem());
                continue;
            }
            this.tag(JSItemTags.CARNIVORE_EDIBLE).add((Object)((Item)jSAnimal.getItems().getRawMeat().get()).asItem());
        }
        for (Era value : Era.values()) {
            value.getRegistryMap().forEach((possibleResult, itemSupplier) -> this.tag(JSItemTags.FOSSIL).add((Object)((Item)itemSupplier.get())));
        }
        this.tag(JSItemTags.UNFERTILIZED_EGGS).add((Object[])new Item[]{(Item)JSV1Items.ALLIGATOR_EGG_UNFERTILIZED.get(), (Item)JSV1Items.CHICKEN_EGG_UNFERTILIZED.get(), (Item)JSV1Items.OSTRICH_EGG_UNFERTILIZED.get(), (Item)JSV1Items.SPIDER_EGG_UNFERTILIZED.get(), (Item)JSV1Items.FISH_EGG_UNFERTILIZED.get(), (Item)JSV1Items.BASILISK_EGG_UNFERTILIZED.get(), (Item)JSV1Items.FROG_EGG_UNFERTILIZED.get()});
        this.tag(JSItemTags.FERTILIZABLE_EGGS).add((Object[])new Item[]{(Item)JSV1Items.ALLIGATOR_EGG.get(), Items.EGG.asItem(), (Item)JSV1Items.OSTRICH_EGG.get(), (Item)JSV1Items.SPIDER_EGG.get(), (Item)JSV1Items.FISH_EGG.get(), (Item)JSV1Items.BASILISK_EGG.get(), (Item)JSV1Items.FROG_EGG.get()});
        this.tag(Tags.Items.FOODS_RAW_FISH).add((Object)((Item)JSV1Items.SQUID.get()));
        this.tag(Tags.Items.FOODS_COOKED_FISH).add((Object)((Item)JSV1Items.SQUID_COOKED.get()));
        for (JSAnimal jSAnimal : JSAnimals.getAnimals()) {
            if (jSAnimal.getAnimalAttributes().getItemProperties().isHasMeat()) {
                AnimalType type = jSAnimal.getAnimalAttributes().getEntityBaseProperties().getAnimalType();
                if (type == AnimalType.AQUATIC_MAMMAL || type == AnimalType.AQUATIC_REPTILE || type == AnimalType.FISH) {
                    this.tag(Tags.Items.FOODS_RAW_FISH).add((Object)((Item)jSAnimal.getItems().getRawMeat().get()));
                    this.tag(Tags.Items.FOODS_COOKED_FISH).add((Object)((Item)jSAnimal.getItems().getCookedMeat().get()));
                } else {
                    this.tag(Tags.Items.FOODS_RAW_MEAT).add((Object)((Item)jSAnimal.getItems().getRawMeat().get()));
                    this.tag(Tags.Items.FOODS_COOKED_MEAT).add((Object)((Item)jSAnimal.getItems().getCookedMeat().get()));
                }
            }
            if (jSAnimal.getItems().getHatched_egg() != null) {
                this.tag(JSItemTags.FERTILIZED_EGGS).add((Object)((Item)jSAnimal.getItems().getHatched_egg().get()));
            }
            if (!jSAnimal.getAnimalAttributes().getMiscProperties().isExtinct() || (double)jSAnimal.getAnimalAttributes().getMiscProperties().getVersion() != 1.0 || jSAnimal.getItems().getHatched_egg() == null) continue;
            this.tag(JSItemTags.V1_ANIMALS).add((Object)((Item)jSAnimal.getItems().getHatched_egg().get()));
        }
        this.tag(JSItemTags.CONCRETE).add((Object[])new Item[]{Items.WHITE_CONCRETE, Items.ORANGE_CONCRETE, Items.MAGENTA_CONCRETE, Items.LIGHT_BLUE_CONCRETE, Items.YELLOW_CONCRETE, Items.LIME_CONCRETE, Items.PINK_CONCRETE, Items.GRAY_CONCRETE, Items.LIGHT_GRAY_CONCRETE, Items.CYAN_CONCRETE, Items.PURPLE_CONCRETE, Items.BLUE_CONCRETE, Items.BROWN_CONCRETE, Items.GREEN_CONCRETE, Items.RED_CONCRETE, Items.BLACK_CONCRETE});
        this.tag(JSItemTags.MOSS).add((Object[])new Item[]{Items.MOSS_BLOCK, Items.MOSS_CARPET, Items.VINE});
    }
}

