/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.neo.server.world;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jp.jurassicsaga.server.v1.animal.JSV1Animals;
import jp.jurassicsaga.server.v1.world.feature.JSV1PlacedFeatures;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.BiomeModifiers;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class JSBiomeModifiers {
    public static final ResourceKey<BiomeModifier> OVERWORLD_ORES = JSBiomeModifiers.registerOre("overworld_ores");
    public static final ResourceKey<BiomeModifier> HELICONIA = JSBiomeModifiers.registerOre("heliconia");
    public static final ResourceKey<BiomeModifier> ROYAL_FERN = JSBiomeModifiers.registerOre("royal_fern");
    public static final ResourceKey<BiomeModifier> WEST_INDIAN_LILAC = JSBiomeModifiers.registerOre("west_indian_lilac");
    public static final ResourceKey<BiomeModifier> SWISS_CHEESE_PLANT = JSBiomeModifiers.registerOre("swiss_cheese_plant");
    public static final ResourceKey<BiomeModifier> ALLIGATOR_SWAMP = JSBiomeModifiers.registerEntity("alligator_swamp");
    public static final ResourceKey<BiomeModifier> BONITO_OCEAN = JSBiomeModifiers.registerEntity("bonito_ocean");
    public static final ResourceKey<BiomeModifier> MOSQUITO_SWAMP = JSBiomeModifiers.registerEntity("mosquito_swamp");
    public static final ResourceKey<BiomeModifier> MOSQUITO_JUNGLE = JSBiomeModifiers.registerEntity("mosquito_jungle");
    public static final ResourceKey<BiomeModifier> REED_FROG_JUNGLE = JSBiomeModifiers.registerEntity("reed_frog_jungle");
    public static final ResourceKey<BiomeModifier> BASILISK_JUNGLE = JSBiomeModifiers.registerEntity("basilisk_jungle");
    public static final ResourceKey<BiomeModifier> GOAT = JSBiomeModifiers.registerEntity("goat");
    public static final ResourceKey<BiomeModifier> OSTRICH_SAVANNA = JSBiomeModifiers.registerEntity("ostrich_savanna");

    public static void bootstrap(BootstrapContext<BiomeModifier> context) {
        HolderGetter features = context.lookup(Registries.PLACED_FEATURE);
        HolderGetter biomes = context.lookup(Registries.BIOME);
        ArrayList ores = new ArrayList();
        JSV1PlacedFeatures.ERA_KEYS.forEach((era, resourceKeyResourceKeyPair) -> {
            if (era.isHasMarineOre()) {
                ores.add(features.getOrThrow((ResourceKey)resourceKeyResourceKeyPair.getSecond()));
            }
            if (era.isHasFossilOre()) {
                ores.add(features.getOrThrow((ResourceKey)resourceKeyResourceKeyPair.getFirst()));
            }
        });
        context.register(ALLIGATOR_SWAMP, (Object)new BiomeModifiers.AddSpawnsBiomeModifier((HolderSet)biomes.getOrThrow(BiomeTags.HAS_SWAMP_HUT), Collections.singletonList(new MobSpawnSettings.SpawnerData((EntityType)JSV1Animals.ALLIGATOR.getEntityType().get(), 3, 2, 5))));
        context.register(BONITO_OCEAN, (Object)new BiomeModifiers.AddSpawnsBiomeModifier((HolderSet)biomes.getOrThrow(BiomeTags.IS_OCEAN), Collections.singletonList(new MobSpawnSettings.SpawnerData((EntityType)JSV1Animals.BONITO.getEntityType().get(), 4, 3, 8))));
        context.register(MOSQUITO_SWAMP, (Object)new BiomeModifiers.AddSpawnsBiomeModifier((HolderSet)biomes.getOrThrow(BiomeTags.HAS_SWAMP_HUT), Collections.singletonList(new MobSpawnSettings.SpawnerData((EntityType)JSV1Animals.MOSQUITO.getEntityType().get(), 2, 2, 4))));
        context.register(MOSQUITO_JUNGLE, (Object)new BiomeModifiers.AddSpawnsBiomeModifier((HolderSet)biomes.getOrThrow(BiomeTags.IS_JUNGLE), Collections.singletonList(new MobSpawnSettings.SpawnerData((EntityType)JSV1Animals.MOSQUITO.getEntityType().get(), 1, 1, 2))));
        context.register(REED_FROG_JUNGLE, (Object)new BiomeModifiers.AddSpawnsBiomeModifier((HolderSet)biomes.getOrThrow(BiomeTags.IS_JUNGLE), Collections.singletonList(new MobSpawnSettings.SpawnerData((EntityType)JSV1Animals.REED_FROG.getEntityType().get(), 3, 4, 6))));
        context.register(BASILISK_JUNGLE, (Object)new BiomeModifiers.AddSpawnsBiomeModifier((HolderSet)biomes.getOrThrow(BiomeTags.IS_JUNGLE), Collections.singletonList(new MobSpawnSettings.SpawnerData((EntityType)JSV1Animals.BASILISK.getEntityType().get(), 64, 4, 6))));
        context.register(GOAT, (Object)new BiomeModifiers.AddSpawnsBiomeModifier((HolderSet)biomes.getOrThrow(BiomeTags.IS_OVERWORLD), Collections.singletonList(new MobSpawnSettings.SpawnerData((EntityType)JSV1Animals.GOAT.getEntityType().get(), 12, 2, 4))));
        context.register(OSTRICH_SAVANNA, (Object)new BiomeModifiers.AddSpawnsBiomeModifier((HolderSet)biomes.getOrThrow(BiomeTags.IS_SAVANNA), List.of(new MobSpawnSettings.SpawnerData((EntityType)JSV1Animals.OSTRICH.getEntityType().get(), 12, 2, 4))));
        context.register(OVERWORLD_ORES, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(BiomeTags.IS_OVERWORLD), (HolderSet)HolderSet.direct(ores), GenerationStep.Decoration.UNDERGROUND_ORES));
        context.register(WEST_INDIAN_LILAC, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)HolderSet.direct((Holder[])new Holder[]{biomes.getOrThrow(Biomes.MEADOW), biomes.getOrThrow(Biomes.WINDSWEPT_HILLS)}), (HolderSet)HolderSet.direct((Holder[])new Holder[]{features.getOrThrow(JSV1PlacedFeatures.WEST_INDIAN_LILAC)}), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.register(SWISS_CHEESE_PLANT, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)HolderSet.direct((Holder[])new Holder[]{biomes.getOrThrow(Biomes.SPARSE_JUNGLE)}), (HolderSet)HolderSet.direct((Holder[])new Holder[]{features.getOrThrow(JSV1PlacedFeatures.SWISS_CHEESE_PLANT)}), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.register(HELICONIA, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)HolderSet.direct((Holder[])new Holder[]{biomes.getOrThrow(Biomes.JUNGLE), biomes.getOrThrow(Biomes.BAMBOO_JUNGLE)}), (HolderSet)HolderSet.direct((Holder[])new Holder[]{features.getOrThrow(JSV1PlacedFeatures.HELICONIA)}), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.register(ROYAL_FERN, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(Tags.Biomes.IS_SWAMP), (HolderSet)HolderSet.direct((Holder[])new Holder[]{features.getOrThrow(JSV1PlacedFeatures.ROYAL_FERN)}), GenerationStep.Decoration.VEGETAL_DECORATION));
    }

    public static ResourceKey<BiomeModifier> registerOre(String name) {
        return JSBiomeModifiers.registerKey("ore/" + name);
    }

    public static ResourceKey<BiomeModifier> registerVegetation(String name) {
        return JSBiomeModifiers.registerKey("vegetation/" + name);
    }

    public static ResourceKey<BiomeModifier> registerEntity(String name) {
        return JSBiomeModifiers.registerKey("entity/" + name);
    }

    public static ResourceKey<BiomeModifier> registerKey(String name) {
        return ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"jurassicsaga", (String)name));
    }
}

