/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.animals;

import java.util.HashMap;
import mod.azure.azurelib.rewrite.animation.play_behavior.AzPlayBehaviors;
import travelers.server.animal.obj.animation.TravelersAnimationControllers;
import travelers.server.animal.obj.animation.TravelersAnimationDefinition;

public class JSAnimations {
    private static final HashMap<String, TravelersAnimationDefinition> ANIMATION_MAP = new HashMap();
    public static final TravelersAnimationControllers.AnimationController swayController = TravelersAnimationControllers.register((String)"sway_controller", (int)10);
    public static final TravelersAnimationControllers.AnimationController base_controller = TravelersAnimationControllers.register((String)"base_controller", (int)10);
    public static final TravelersAnimationControllers.AnimationController damageController = TravelersAnimationControllers.register((String)"damage_controller", (int)10);
    public static final TravelersAnimationDefinition IDLE = JSAnimations.loop(base_controller, "animation.idle");
    public static final TravelersAnimationDefinition IDLE_HIDDEN = JSAnimations.loop(base_controller, "animation.idle_hidden");
    public static final TravelersAnimationDefinition IDLE_IN_WATER = JSAnimations.loop(base_controller, "animation.idle_in_water");
    public static final TravelersAnimationDefinition SWIM = JSAnimations.loop(base_controller, "animation.swim");
    public static final TravelersAnimationDefinition SWIM_NEAR_SURFACE = JSAnimations.loop(base_controller, "animation.swim_near_surface");
    public static final TravelersAnimationDefinition SWIM_FAST = JSAnimations.loop(base_controller, "animation.swim_fast");
    public static final TravelersAnimationDefinition SWAY_LEFT = JSAnimations.loop(swayController, "animation.sway_left");
    public static final TravelersAnimationDefinition SWAY_RIGHT = JSAnimations.loop(swayController, "animation.sway_right");
    public static final TravelersAnimationDefinition INJURED = JSAnimations.play(damageController, "animation.injured");
    public static final TravelersAnimationDefinition SLEEPING = JSAnimations.loop(base_controller, "animation.sleeping").disableLook().disablePhysics();
    public static final TravelersAnimationDefinition WALK = JSAnimations.loop(base_controller, "animation.walk");
    public static final TravelersAnimationDefinition RUN = JSAnimations.loop(base_controller, "animation.run");
    public static final TravelersAnimationDefinition DEATH = JSAnimations.hold(base_controller, "animation.death").disableLook().disablePhysics();
    public static final TravelersAnimationDefinition JUMP_START = JSAnimations.play(base_controller, "animation.jump_start").disableLook().disablePhysics();
    public static final TravelersAnimationDefinition JUMP_LOOP = JSAnimations.loop(base_controller, "animation.jump_loop").disableLook().disablePhysics();
    public static final TravelersAnimationDefinition JUMP_END = JSAnimations.play(base_controller, "animation.jump_end").disableLook().disablePhysics();
    public static final TravelersAnimationDefinition ATTACK = JSAnimations.play(damageController, "animation.attack");
    public static final TravelersAnimationDefinition REST_IN = JSAnimations.hold(base_controller, "animation.rest_in").disableLook().disablePhysics();
    public static final TravelersAnimationDefinition REST_LOOP = JSAnimations.loop(base_controller, "animation.rest_loop").disableLook().disablePhysics();
    public static final TravelersAnimationDefinition REST_OUT = JSAnimations.hold(base_controller, "animation.rest_out").disableLook().disablePhysics();
    public static final TravelersAnimationDefinition SLEEP_IN = JSAnimations.hold(base_controller, "animation.sleep_in").disableLook().disablePhysics();
    public static final TravelersAnimationDefinition SLEEP_LOOP = JSAnimations.loop(base_controller, "animation.sleep_loop").disableLook().disablePhysics();
    public static final TravelersAnimationDefinition SLEEP_OUT = JSAnimations.hold(base_controller, "animation.sleep_out").disableLook().disablePhysics();
    public static final TravelersAnimationDefinition BEACHED = JSAnimations.loop(base_controller, "animation.beached").disableLook().disablePhysics();
    public static final TravelersAnimationDefinition FLYING = JSAnimations.loop(base_controller, "animation.fly");
    public static final TravelersAnimationDefinition GLIDE = JSAnimations.loop(base_controller, "animation.glide");
    public static final TravelersAnimationDefinition IDLE_WING_MOVE = JSAnimations.play(base_controller, "animation.idle_wing_move");
    public static final TravelersAnimationDefinition RETRACT_SHELL = JSAnimations.play("animation.retractshell");
    public static final TravelersAnimationDefinition UNRETRACTING_SHELL = JSAnimations.play("animation.unretractingshell");
    public static final TravelersAnimationDefinition IDLE_WALL = JSAnimations.loop("animation.on_wall");
    public static final TravelersAnimationDefinition IDLE_ROOF = JSAnimations.loop("animation.on_roof");
    public static final TravelersAnimationDefinition IDLE_FLAP = JSAnimations.play("animation.idle_flap");
    public static final TravelersAnimationDefinition IDLE_DISPLAY = JSAnimations.play("animation.idle_display");
    public static final TravelersAnimationDefinition IDLE_CALL = JSAnimations.play("animation.idle_call");
    public static final TravelersAnimationDefinition FRILL_OUT = JSAnimations.play(base_controller, "animation.frill_out");
    public static final TravelersAnimationDefinition FRILL_SHAKE = JSAnimations.play(base_controller, "animation.frill_shake");
    public static final TravelersAnimationDefinition FRILL_IN = JSAnimations.play(base_controller, "animation.frill_in");
    public static final TravelersAnimationDefinition ON_LAND_DEATH = JSAnimations.play("animation.death_on_land").disableLook().disablePhysics();
    public static final TravelersAnimationDefinition ON_LAND_INJURED = JSAnimations.play("animation.injured_on_land");
    public static final TravelersAnimationDefinition OPEN = JSAnimations.play("animation.open");
    public static final TravelersAnimationDefinition OPENED = JSAnimations.hold("animation.opened");
    public static final TravelersAnimationDefinition OPEN_HOLD = JSAnimations.hold("animation.open");
    public static final TravelersAnimationDefinition CLOSE = JSAnimations.play("animation.close");
    public static final TravelersAnimationDefinition CLOSED = JSAnimations.hold("animation.closed");
    public static final TravelersAnimationDefinition GUIDEBOOK_POSE = JSAnimations.hold("animation.guidebook_pose");
    public static final TravelersAnimationDefinition GUIDEBOOK_POSE_BABY = JSAnimations.hold("animation.guidebook_baby_pose");
    public static final TravelersAnimationDefinition ROAR = JSAnimations.play(base_controller, "animation.roar").disableLook().disablePhysics();
    public static final TravelersAnimationDefinition ROAR_1 = JSAnimations.play(base_controller, "animation.roar1").disableLook().disablePhysics();
    public static final TravelersAnimationDefinition ROAR_2 = JSAnimations.play(base_controller, "animation.roar2").disableLook().disablePhysics();
    public static final TravelersAnimationDefinition FLY_ATTACK = JSAnimations.play(damageController, "animation.fly_attack");
    public static final TravelersAnimationDefinition FLOP = JSAnimations.loop(base_controller, "animation.flop");
    public static final TravelersAnimationDefinition STALK = JSAnimations.loop(base_controller, "animation.stalk");
    public static final TravelersAnimationDefinition EAT = JSAnimations.play(base_controller, "animation.eat");
    public static final TravelersAnimationDefinition DRINK = JSAnimations.play(base_controller, "animation.drink");
    public static final TravelersAnimationDefinition HOVER = JSAnimations.loop(base_controller, "animation.hover");
    public static final TravelersAnimationDefinition DROWN = JSAnimations.loop(base_controller, "animation.drown");

    public static TravelersAnimationDefinition loop(String name) {
        TravelersAnimationDefinition value = new TravelersAnimationDefinition(name, AzPlayBehaviors.LOOP, 5);
        ANIMATION_MAP.put(name, value);
        return value;
    }

    public static TravelersAnimationDefinition loop(TravelersAnimationControllers.AnimationController controller, String name) {
        TravelersAnimationDefinition value = new TravelersAnimationDefinition(name, controller, AzPlayBehaviors.LOOP);
        ANIMATION_MAP.put(name, value);
        return value;
    }

    public static TravelersAnimationDefinition play(String name) {
        TravelersAnimationDefinition value = new TravelersAnimationDefinition(name, AzPlayBehaviors.PLAY_ONCE, 5);
        ANIMATION_MAP.put(name, value);
        return value;
    }

    public static TravelersAnimationDefinition play(TravelersAnimationControllers.AnimationController controller, String name) {
        TravelersAnimationDefinition value = new TravelersAnimationDefinition(name, controller, AzPlayBehaviors.PLAY_ONCE);
        ANIMATION_MAP.put(name, value);
        return value;
    }

    public static TravelersAnimationDefinition hold(String name) {
        TravelersAnimationDefinition value = new TravelersAnimationDefinition(name, AzPlayBehaviors.HOLD_ON_LAST_FRAME, 5);
        ANIMATION_MAP.put(name, value);
        return value;
    }

    public static TravelersAnimationDefinition hold(TravelersAnimationControllers.AnimationController controller, String name) {
        TravelersAnimationDefinition value = new TravelersAnimationDefinition(name, controller, AzPlayBehaviors.HOLD_ON_LAST_FRAME);
        ANIMATION_MAP.put(name, value);
        return value;
    }

    public static TravelersAnimationDefinition getAnimation(String name) {
        return ANIMATION_MAP.get(name);
    }
}

