/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.bases;

import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAquaticBase;
import jp.jurassicsaga.server.base.animal.entity.obj.nav.JSAmphibiousNavigation;
import jp.jurassicsaga.server.base.animal.entity.obj.other.JSSwimmingMoveControl;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import travelers.server.animal.entity.pathingsystem.TravelersPath;
import travelers.server.animal.entity.pathingsystem.navigation.TravelersPathNavigation;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersPathType;

public class JSAmphibiousBase
extends JSAnimalBase {
    public JSAmphibiousBase(EntityType<? extends PathfinderMob> entityType, Level world) {
        super(entityType, world);
        this.setPathfindingMalus(TravelersPathType.WATER, 0.0f);
        this.setPathfindingMalus(TravelersPathType.WATER_BORDER, 0.0f);
        this.setPathfindingMalus(TravelersPathType.TRAPDOOR, -1.0f);
        this.moveController = new JSSwimmingMoveControl(this, (float)this.getAnimal().getAnimalAttributes().getEntityBaseProperties().getMaxTurnRate(), (float)this.getAnimal().getAnimalAttributes().getEntityBaseProperties().getMaxHeadYRot(), 0.01f, 0.1f, true);
    }

    public static boolean checkSurfaceWaterAnimalSpawnRules(EntityType<? extends JSAquaticBase> pWaterAnimal, LevelAccessor pLevel, MobSpawnType pSpawnType, BlockPos pPos, RandomSource pRandom) {
        int i = pLevel.getSeaLevel();
        int j = i - 13;
        return pPos.getY() >= j && pPos.getY() <= i && pLevel.getFluidState(pPos.below()).is(FluidTags.WATER) && pLevel.getBlockState(pPos.above()).is(Blocks.WATER);
    }

    public boolean canSwim() {
        return true;
    }

    public void travel(@NotNull Vec3 pTravelVector) {
        if (!this.level().isClientSide && this.isInWater()) {
            this.moveRelative(this.getSpeed(), pTravelVector);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.6));
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.005, 0.0));
        } else {
            super.travel(pTravelVector);
        }
    }

    public void baseTick() {
        int i = this.getAirSupply();
        super.baseTick();
        if (this.usesAir()) {
            this.handleAirSupply(i);
        }
    }

    protected void handleAirSupply(int airSupply) {
        if (this.isAlive() && this.invertAir() != this.isInWaterOrBubble()) {
            this.setAirSupply(airSupply - 1);
            if (this.getAirSupply() == -20) {
                this.setAirSupply(0);
                this.hurt(this.damageSources().drown(), 2.0f);
            }
        } else {
            this.setAirSupply(300);
        }
    }

    public int getAirSupply() {
        return this.usesAir() ? super.getAirSupply() : this.getMaxAirSupply();
    }

    protected float getWaterSlowDown() {
        return 0.1f;
    }

    public double getFluidJumpThreshold() {
        return this.maxUpStep();
    }

    @Override
    protected TravelersPathNavigation createNavigationController(Level level) {
        return new JSAmphibiousNavigation(this, level, this.shallowSwimming());
    }

    @Override
    public void aiStep() {
        super.aiStep();
        if (this.isInWater()) {
            if (this.sinkToBottom() || this.isDead() || !this.isStalking() && !this.isEyeInFluid(FluidTags.WATER)) {
                if (!this.onGround()) {
                    this.setDeltaMovement(this.getDeltaMovement().add(0.0, -this.getSinkRate(), 0.0));
                }
            } else if (!this.level().isClientSide) {
                TravelersPathNavigation navigator = this.getNavigationController();
                TravelersPath path = navigator.getPath();
                if (!this.onGround() && (this.isInLiquid() || this.isInWater() || this.wasEyeInWater) && path != null && !path.isDone()) {
                    double y;
                    double difference;
                    Vec3 pathPos = path.getNextEntityPos((Entity)this);
                    if (navigator.isStuck()) {
                        navigator.stop();
                    }
                    if (Math.abs(difference = pathPos.y - (y = this.position().y)) > 0.1) {
                        if (difference > 0.0) {
                            this.setDeltaMovement(this.getDeltaMovement().add(0.0, difference > 2.0 ? this.getSinkRate() * 2.0 : this.getSinkRate(), 0.0));
                        } else {
                            this.setDeltaMovement(this.getDeltaMovement().add(0.0, difference < -2.0 ? -this.getSinkRate() * 2.0 : -this.getSinkRate(), 0.0));
                        }
                    }
                }
            }
        }
    }

    protected double getSinkRate() {
        return 0.05f;
    }

    protected boolean sinkToBottom() {
        return true;
    }

    protected boolean usesAir() {
        return true;
    }

    protected boolean invertAir() {
        return false;
    }

    public boolean shallowSwimming() {
        return false;
    }

    public boolean checkSpawnObstruction(LevelReader level) {
        return level.isUnobstructed((Entity)this);
    }

    public boolean isPushedByFluid() {
        return false;
    }
}

