/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.bases;

import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.nav.JSAquaticNavigation;
import jp.jurassicsaga.server.base.animal.entity.obj.other.JSSwimmingMoveControl;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import travelers.server.animal.entity.pathingsystem.TravelersPath;
import travelers.server.animal.entity.pathingsystem.navigation.TravelersPathNavigation;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersPathType;

public class JSAquaticBase
extends JSAnimalBase {
    private static final EntityDataAccessor<Boolean> SWIMMING = SynchedEntityData.defineId(JSAquaticBase.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public JSAquaticBase(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
        this.setPathfindingMalus(TravelersPathType.WATER, 0.0f);
        this.setPathfindingMalus(TravelersPathType.TRAPDOOR, -1.0f);
        this.moveController = new JSSwimmingMoveControl(this, (float)this.getAnimal().getAnimalAttributes().getEntityBaseProperties().getMaxTurnRate(), (float)this.getAnimal().getAnimalAttributes().getEntityBaseProperties().getMaxHeadYRot(), 0.01f, 0.1f, true);
    }

    public static boolean checkSurfaceWaterAnimalSpawnRules(EntityType<? extends JSAquaticBase> pWaterAnimal, LevelAccessor pLevel, MobSpawnType pSpawnType, BlockPos pPos, RandomSource pRandom) {
        int i = pLevel.getSeaLevel();
        int j = i - 13;
        return pPos.getY() >= j && pPos.getY() <= i && pLevel.getFluidState(pPos.below()).is(FluidTags.WATER) && pLevel.getBlockState(pPos.above()).is(Blocks.WATER);
    }

    @Override
    public boolean shouldSleep() {
        return false;
    }

    public void baseTick() {
        int i = this.getAirSupply();
        super.baseTick();
        this.handleAirSupply(i);
    }

    public boolean checkSpawnObstruction(LevelReader level) {
        return level.isUnobstructed((Entity)this);
    }

    protected void handleAirSupply(int airSupply) {
        if (this.isAlive() && !this.isInWaterOrBubble()) {
            this.setAirSupply(airSupply - 1);
            if (this.getAirSupply() == -20) {
                this.setAirSupply(0);
                this.hurt(this.damageSources().drown(), 2.0f);
            }
        } else {
            this.setAirSupply(300);
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.isInWaterOrBubble() && this.onGround() && this.shouldFlop()) {
            this.setDeltaMovement(this.getDeltaMovement().add((double)((this.random.nextFloat() * 2.0f - 1.0f) * 0.2f), 0.5, (double)((this.random.nextFloat() * 2.0f - 1.0f) * 0.2f)));
            this.setYRot(this.random.nextFloat() * 360.0f);
            this.setOnGround(false);
            this.hasImpulse = true;
        }
    }

    public boolean shouldFlop() {
        return false;
    }

    @Override
    public void aiStep() {
        super.aiStep();
        if (!this.onGround()) {
            if (!this.isEyeInFluid(FluidTags.WATER)) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.05, 0.0));
            } else {
                this.goDownInWater();
            }
        }
        if (this.isInWater()) {
            this.entityData.set(SWIMMING, (Object)true);
        }
        if (this.isInLiquid() || this.isInWater() || this.wasEyeInWater) {
            TravelersPath path;
            if (this.checkForCollide()) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, 0.0225, 0.0));
            }
            if ((path = this.getNavigationController().getPath()) != null && !path.isDone()) {
                Vec3 pathPos = path.getNextEntityPos((Entity)this);
                if (this.getNavigation().isStuck()) {
                    this.getNavigation().stop();
                }
                double y = this.position().y;
                double difference = pathPos.y - y;
                double distance = Math.abs(difference);
                if (Math.abs(difference) > 0.1) {
                    float uplift = (float)Mth.lerp((double)Math.min(1.0, distance / 2.0), (double)(this.getUpLift() * 0.5), (double)(this.getUpLift() * 2.0));
                    if (difference > 0.0) {
                        this.setDeltaMovement(this.getDeltaMovement().add(0.0, (double)uplift, 0.0));
                    } else {
                        this.setDeltaMovement(this.getDeltaMovement().add(0.0, (double)(-uplift), 0.0));
                    }
                }
            }
        }
    }

    protected double getUpLift() {
        return 0.0135;
    }

    public void travel(@NotNull Vec3 pTravelVector) {
        if (!this.level().isClientSide && this.isInWater()) {
            this.moveRelative(this.getSpeed(), pTravelVector);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.6));
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.005, 0.0));
        } else {
            super.travel(pTravelVector);
        }
    }

    @Override
    protected boolean canRunInWater() {
        return true;
    }

    public boolean isPushedByFluid() {
        return this.isDead();
    }

    @Override
    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SWIMMING, (Object)false);
    }

    @Override
    protected TravelersPathNavigation createNavigationController(Level level) {
        return new JSAquaticNavigation(this, level, this.allowBreaching());
    }

    private boolean allowBreaching() {
        return true;
    }

    protected float getWaterSlowDown() {
        return 0.1f;
    }

    public double getFluidJumpThreshold() {
        return this.maxUpStep();
    }

    @Override
    protected void playStepSound(@NotNull BlockPos pos, @NotNull BlockState state) {
    }

    protected void goDownInWater() {
        if (this.isDead()) {
            super.goDownInWater();
        }
    }

    public boolean isSwimming() {
        return (Boolean)this.entityData.get(SWIMMING);
    }

    public boolean canSwim() {
        return true;
    }

    @Override
    protected float getJumpPower() {
        return this.isSwimming() ? super.getJumpPower() : 0.0f;
    }
}

