/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.bases;

import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.nav.JSFlyingNavigation;
import jp.jurassicsaga.server.base.animal.entity.obj.nav.JSGroundNavigation;
import jp.jurassicsaga.server.base.animal.entity.obj.other.JSLookControl;
import jp.jurassicsaga.server.v1.animal.entity.obj.JSFlyingMoveControl;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.JumpControl;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.pathingsystem.TravelersPath;
import travelers.server.animal.entity.pathingsystem.control.TravelersMoveControl;
import travelers.server.animal.entity.pathingsystem.navigation.TravelersPathNavigation;

public class JSAvianBase
extends JSAnimalBase {
    public static final EntityDataAccessor<Boolean> FLYING = SynchedEntityData.defineId(JSAvianBase.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> WANTS_TO_LAND = SynchedEntityData.defineId(JSAvianBase.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private JSFlyingNavigation flyingPathNavigation;
    private JSGroundNavigation groundPathNavigation;
    protected final JSFlyingMoveControl flyingMoveControl;
    protected final TravelersMoveControl animalMoveControl = new TravelersMoveControl((SmartAnimalBase)this, this.getAnimal());
    protected float stamina = 1.0f;
    protected float staminaDrainRate = 0.0015f;
    protected float staminaRegenRate = 0.0025f;
    private int takeoffCooldown = 0;

    public JSAvianBase(EntityType<? extends PathfinderMob> entityType, Level world) {
        super(entityType, world);
        this.flyingMoveControl = new JSFlyingMoveControl(this, this.getAnimal(), this.hoversInPlace());
        this.moveController = this.animalMoveControl;
        this.lookControl = new JSLookControl(this);
    }

    protected boolean hoversInPlace() {
        return false;
    }

    public JSFlyingNavigation getFlyingPathNavigation() {
        if (this.flyingPathNavigation == null) {
            this.flyingPathNavigation = new JSFlyingNavigation(this, this.level());
        }
        return this.flyingPathNavigation;
    }

    public JSGroundNavigation getGroundPathNavigation() {
        if (this.groundPathNavigation == null) {
            this.groundPathNavigation = new JSGroundNavigation(this, this.level());
        }
        return this.groundPathNavigation;
    }

    @Override
    protected TravelersPathNavigation createNavigationController(Level level) {
        return this.getGroundPathNavigation();
    }

    protected void checkFallDamage(double y, boolean onGround, @NotNull BlockState state, @NotNull BlockPos pos) {
        if (!this.isFlying()) {
            super.checkFallDamage(y, onGround, state, pos);
        }
    }

    @Override
    public boolean onClimbable() {
        return super.onClimbable() && !this.isFlying();
    }

    protected boolean isFlapping() {
        return this.isFlying();
    }

    @Override
    public boolean hasSolidBelow() {
        AABB aabb = this.getBoundingBox();
        return this.hasCollisions(aabb.inflate(0.0, 2.0, 0.0));
    }

    public void travel(@NotNull Vec3 travelVector) {
        if (this.isFlying()) {
            if (this.isControlledByLocalInstance()) {
                if (this.isInLava()) {
                    this.moveRelative(0.02f, travelVector);
                    this.move(MoverType.SELF, this.getDeltaMovement());
                    this.setDeltaMovement(this.getDeltaMovement().scale(0.5));
                } else {
                    float f = 0.95f;
                    float speed = this.getSpeed();
                    this.moveRelative(speed, travelVector);
                    this.move(MoverType.SELF, this.getDeltaMovement());
                    this.setDeltaMovement(this.getDeltaMovement().multiply((double)0.91f, (double)f, (double)0.91f));
                }
            }
        } else {
            super.travel(travelVector);
        }
    }

    @Override
    public float getSpeed() {
        return this.isFlying() ? (float)this.getAttributes().getBaseValue(Attributes.FLYING_SPEED) : super.getSpeed();
    }

    @Override
    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(FLYING, (Object)false);
        pBuilder.define(WANTS_TO_LAND, (Object)true);
    }

    public boolean isFlying() {
        return (Boolean)this.entityData.get(FLYING) != false || !this.onGround() && !this.hasSolidBelow() || this.getNavigationController() == this.getFlyingPathNavigation();
    }

    @Override
    public void jumpFromGround() {
        if (this.isFlying()) {
            return;
        }
        super.jumpFromGround();
    }

    public void setJumping(boolean jumping) {
        if (this.isFlying()) {
            super.setJumping(false);
            return;
        }
        super.setJumping(jumping);
    }

    @NotNull
    public JumpControl getJumpControl() {
        return new FlyingJumpControl(this);
    }

    public boolean disableFlyTransitions() {
        return false;
    }

    @Override
    public void aiStep() {
        if (this.takeoffCooldown > 0) {
            --this.takeoffCooldown;
        }
        if (this.isDead() && !this.onGround()) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.075, 0.0));
        }
        if (this.isFlying()) {
            this.stamina = Math.max(0.0f, this.stamina - this.staminaDrainRate);
            if (this.stamina <= 0.0f) {
                this.entityData.set(WANTS_TO_LAND, (Object)true);
            }
        } else if (this.onGround() || this.hasSolidBelow()) {
            this.stamina = Math.min(1.0f, this.stamina + this.staminaRegenRate);
        }
        super.aiStep();
        if (this.disableFlyTransitions()) {
            return;
        }
        this.setNoGravity(this.hoversInPlace());
        if (this.isFlying() && this.getNavigationController().isDone() && !this.hoversInPlace()) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.005, 0.0));
        } else if (this.isFlying() && this.getNavigationController().isDone()) {
            Vec3 delta = this.getDeltaMovement();
            this.setDeltaMovement(new Vec3(delta.x, 0.01, delta.z));
        }
        if (this.getDeltaMovement().y < -10.0 && !this.isFlying() || this.isInWater()) {
            this.entityData.set(FLYING, (Object)true);
            this.moveController = this.flyingMoveControl;
            if (this.getNavigationController() == this.getGroundPathNavigation()) {
                this.getGroundPathNavigation().stop();
                this.navigationController = this.getFlyingPathNavigation();
            }
            if (this.isInWater()) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, 0.075, 0.0));
            } else {
                Vec3 mv = this.getDeltaMovement();
                this.setDeltaMovement(new Vec3(mv.x, 0.0, mv.z));
            }
        }
        if (this.isFlying() && !this.wantsToLand()) {
            if (this.getMoveController() != this.flyingMoveControl) {
                this.moveController = this.flyingMoveControl;
            }
            if (this.getNavigationController() != this.getFlyingPathNavigation()) {
                if (this.getNavigationController() == this.getGroundPathNavigation()) {
                    this.getGroundPathNavigation().stop();
                }
                this.navigationController = this.getFlyingPathNavigation();
            }
            if (this.stamina < 0.5f && this.random.nextFloat() < 0.015f && this.random.nextBoolean()) {
                this.entityData.set(WANTS_TO_LAND, (Object)true);
            }
            TravelersPathNavigation navigator = this.getNavigationController();
            TravelersPath path = navigator.getPath();
            if (!(this.onGround() || this.isInLiquid() || this.isInWater() || this.wasEyeInWater || path == null || path.isDone())) {
                BlockPos nextPos = path.getNextNodePos();
                if (navigator.isStuck()) {
                    navigator.stop();
                }
                this.getLookControl().setLookAt(nextPos.getCenter());
            }
        }
        if ((this.onGround() || this.hasSolidBelow()) && this.wantsToLand()) {
            this.entityData.set(WANTS_TO_LAND, (Object)false);
            this.entityData.set(FLYING, (Object)false);
            this.moveController = this.animalMoveControl;
            this.navigationController = this.getGroundPathNavigation();
            this.setDeltaMovement(Vec3.ZERO);
            this.takeoffCooldown = 100 + this.random.nextInt(50);
            return;
        }
        if (!this.isFlying() && this.takeoffCooldown == 0 && this.stamina > 0.95f && this.random.nextFloat() < 0.05f && this.random.nextBoolean()) {
            this.entityData.set(FLYING, (Object)true);
            this.moveController = this.flyingMoveControl;
            this.navigationController = this.getFlyingPathNavigation();
            this.setDeltaMovement(new Vec3(0.0, 0.05, 0.0));
            this.takeoffCooldown = 100 + this.random.nextInt(50);
        }
    }

    public boolean wantsToLand() {
        return (Boolean)this.entityData.get(WANTS_TO_LAND);
    }

    @Override
    public void addAdditionalSaveData(@NotNull CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putBoolean("js.isFlying", ((Boolean)this.entityData.get(FLYING)).booleanValue());
        pCompound.putBoolean("js.isLanding", ((Boolean)this.entityData.get(WANTS_TO_LAND)).booleanValue());
        pCompound.putFloat("js.stamina", this.stamina);
    }

    @Override
    public void readAdditionalSaveData(@NotNull CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        this.entityData.set(FLYING, (Object)pCompound.getBoolean("js.isFlying"));
        this.entityData.set(WANTS_TO_LAND, (Object)pCompound.getBoolean("js.isLanding"));
        if (pCompound.contains("js.stamina")) {
            this.stamina = pCompound.getFloat("js.stamina");
        }
    }

    public int getMaxDistanceToGround() {
        return 60;
    }

    private static class FlyingJumpControl
    extends JumpControl {
        private final JSAvianBase base;

        public FlyingJumpControl(JSAvianBase mob) {
            super((Mob)mob);
            this.base = mob;
        }

        public void jump() {
            this.jump = true;
        }

        public void tick() {
            if (this.base.isFlying()) {
                if (this.base.jumping) {
                    this.base.setJumping(false);
                    this.jump = false;
                }
            } else {
                this.base.setJumping(this.jump);
                this.jump = false;
            }
        }
    }
}

