/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.bases;

import jp.jurassicsaga.server.base.animal.entity.obj.other.JSVariants;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import travelers.server.animal.entity.SmartAnimalBase;

public abstract class JSEntityDataHolder
extends SmartAnimalBase {
    public static final EntityDataAccessor<Boolean> male = SynchedEntityData.defineId(JSEntityDataHolder.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> refreshData = SynchedEntityData.defineId(JSEntityDataHolder.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> panicking = SynchedEntityData.defineId(JSEntityDataHolder.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> resting = SynchedEntityData.defineId(JSEntityDataHolder.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> sleeping = SynchedEntityData.defineId(JSEntityDataHolder.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> stalking = SynchedEntityData.defineId(JSEntityDataHolder.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> dead = SynchedEntityData.defineId(JSEntityDataHolder.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Float> additionalScale = SynchedEntityData.defineId(JSEntityDataHolder.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<String> textureVariant = SynchedEntityData.defineId(JSEntityDataHolder.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<CompoundTag> gene_data = SynchedEntityData.defineId(JSEntityDataHolder.class, (EntityDataSerializer)EntityDataSerializers.COMPOUND_TAG);
    public static final EntityDataAccessor<CompoundTag> growth_data = SynchedEntityData.defineId(JSEntityDataHolder.class, (EntityDataSerializer)EntityDataSerializers.COMPOUND_TAG);
    public static final EntityDataAccessor<CompoundTag> metabolism_data = SynchedEntityData.defineId(JSEntityDataHolder.class, (EntityDataSerializer)EntityDataSerializers.COMPOUND_TAG);

    protected JSEntityDataHolder(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(male, (Object)false);
        builder.define(panicking, (Object)false);
        builder.define(refreshData, (Object)false);
        builder.define(resting, (Object)false);
        builder.define(sleeping, (Object)false);
        builder.define(stalking, (Object)false);
        builder.define(dead, (Object)false);
        builder.define(additionalScale, (Object)Float.valueOf(0.0f));
        builder.define(textureVariant, (Object)JSVariants.NONE.getName());
        builder.define(gene_data, (Object)new CompoundTag());
        builder.define(growth_data, (Object)new CompoundTag());
        builder.define(metabolism_data, (Object)new CompoundTag());
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("js.animal.dead", ((Boolean)this.entityData.get(dead)).booleanValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.entityData.set(dead, (Object)compound.getBoolean("js.animal.dead"));
    }

    void setDead(boolean aBoolean) {
        this.entityData.set(dead, (Object)aBoolean);
    }

    public void setIsPanicking(boolean isPanicking) {
        this.entityData.set(panicking, (Object)isPanicking);
    }

    public boolean isPanicking() {
        return (Boolean)this.entityData.get(panicking);
    }

    public void setResting(boolean isResting) {
        this.entityData.set(resting, (Object)isResting);
    }

    public boolean isResting() {
        return (Boolean)this.entityData.get(resting);
    }

    public void setSleeping(boolean isSleeping) {
        this.entityData.set(sleeping, (Object)isSleeping);
    }

    public boolean isSleeping() {
        return (Boolean)this.entityData.get(sleeping);
    }

    public void setStalking(boolean isStalking) {
        this.entityData.set(stalking, (Object)isStalking);
    }

    public float maxUpStep() {
        return 1.0f;
    }
}

