/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.modules;

import java.util.concurrent.atomic.AtomicInteger;
import jp.jurassicsaga.JSCommon;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSEntityDataHolder;
import jp.jurassicsaga.server.base.animal.entity.obj.diet.Diet;
import jp.jurassicsaga.server.base.animal.entity.obj.modules.JSAnimalModuleBase;
import jp.jurassicsaga.server.base.animal.entity.obj.modules.JSHerdModule;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMetabolismProperties;
import jp.jurassicsaga.server.base.entity.obj.other.IJSEdibleEntity;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import travelers.server.animal.TravelersAnimal;

public class JSMetabolismModule
extends JSAnimalModuleBase {
    private boolean hungerEnabled;
    private boolean thirstEnabled;
    private boolean sleepEnabled;
    private boolean breedingEnabled;
    private boolean isInterrupted;
    private int maxHunger;
    private int maxThirst;
    private int ticksSleeping;
    private int interruptTicks = 0;
    private Diet diet;

    protected JSMetabolismModule(JSAnimalBase owner) {
        super(owner);
    }

    @Override
    public void saveNbt(CompoundTag nbt) {
        nbt.put("js.metabolism", (Tag)this.owner.getEntityData().get(JSEntityDataHolder.metabolism_data));
    }

    @Override
    public void loadNbt(CompoundTag nbt) {
        this.owner.getEntityData().set(JSEntityDataHolder.metabolism_data, (Object)nbt.getCompound("js.metabolism"));
    }

    @Override
    public void init() {
        TravelersAnimal animal = this.owner.getAnimal();
        JSMetabolismProperties attributes = animal.getAnimalAttributes().getMetabolismProperties();
        this.hungerEnabled = this.owner.level().getGameRules().getBoolean(JSCommon.ENABLE_METABOLISM) && animal.getAnimalAttributes().getMetabolismProperties().isHungerEnabled();
        this.thirstEnabled = this.owner.level().getGameRules().getBoolean(JSCommon.ENABLE_METABOLISM) && animal.getAnimalAttributes().getMetabolismProperties().isThirstEnabled();
        this.maxHunger = attributes.getMaxFood();
        this.maxThirst = attributes.getMaxWater();
    }

    @Override
    public void tick() {
        if (this.interruptTicks > 0) {
            --this.interruptTicks;
        } else if (this.isInterrupted) {
            this.isInterrupted = false;
        }
    }

    public Diet getDiet() {
        if (this.diet != null) {
            return this.diet;
        }
        this.diet = this.owner.getAnimal().getAnimalAttributes().getMetabolismProperties().getDietSupplier().get();
        return this.diet;
    }

    @Override
    public void serverAiStep() {
        if (!this.owner.getContainer().isEmpty()) {
            AtomicInteger i = new AtomicInteger();
            this.owner.getContainer().getItems().iterator().forEachRemaining(item -> {
                if (this.getDiet().canEatItem((ItemStack)item)) {
                    FoodProperties food = (FoodProperties)item.get(DataComponents.FOOD);
                    if (food != null) {
                        this.setHunger((int)((float)this.getHunger() + 100.0f * ((float)food.nutrition() + food.saturation())));
                    } else {
                        this.setHunger(this.getHunger() + 500);
                    }
                    this.owner.getContainer().removeItem(i.get(), 1);
                    i.getAndIncrement();
                }
            });
        }
        if (this.maxHunger == -1 || this.maxThirst == -1) {
            this.init();
        }
        if (this.owner.isMoving()) {
            if (this.hungerEnabled) {
                int hunger = this.getHunger();
                this.setHunger(Math.max(0, hunger - 1));
                if (hunger == 0 && this.owner.getRandom().nextDouble() > 0.8) {
                    this.owner.hurt(this.owner.level().damageSources().starve(), 2.0f);
                }
            }
            if (this.thirstEnabled) {
                int thirst = this.getThirst();
                this.setThirst(Math.max(0, thirst - 1));
                if (thirst == 0 && this.owner.getRandom().nextDouble() > 0.8) {
                    this.owner.hurt(this.owner.level().damageSources().dryOut(), 2.0f);
                }
            }
        }
    }

    public boolean isHungry() {
        return this.hungerPercentage() < (double)0.6f;
    }

    public boolean isThirsty() {
        return this.thirstPercentage() < (double)0.6f;
    }

    public int getHunger() {
        CompoundTag data = (CompoundTag)this.owner.getEntityData().get(JSEntityDataHolder.metabolism_data);
        return data.getInt("js.metabolism.hunger");
    }

    public void setHunger(int newHunger) {
        CompoundTag data = ((CompoundTag)this.owner.getEntityData().get(JSEntityDataHolder.metabolism_data)).copy();
        data.putInt("js.metabolism.hunger", Math.min(this.maxHunger, newHunger));
        this.owner.getEntityData().set(JSEntityDataHolder.metabolism_data, (Object)data);
    }

    public int getThirst() {
        CompoundTag data = (CompoundTag)this.owner.getEntityData().get(JSEntityDataHolder.metabolism_data);
        return data.getInt("js.metabolism.thirst");
    }

    public void setThirst(int newThirst) {
        CompoundTag data = ((CompoundTag)this.owner.getEntityData().get(JSEntityDataHolder.metabolism_data)).copy();
        data.putInt("js.metabolism.thirst", Math.min(this.maxThirst, newThirst));
        this.owner.getEntityData().set(JSEntityDataHolder.metabolism_data, (Object)data);
    }

    public int getGestation() {
        CompoundTag data = (CompoundTag)this.owner.getEntityData().get(JSEntityDataHolder.metabolism_data);
        return data.getInt("js.metabolism.gestation");
    }

    public void setGestation(int newGestation) {
        CompoundTag data = ((CompoundTag)this.owner.getEntityData().get(JSEntityDataHolder.metabolism_data)).copy();
        data.putInt("js.metabolism.gestation", newGestation);
        this.owner.getEntityData().set(JSEntityDataHolder.metabolism_data, (Object)data);
    }

    @Override
    public void finalizeSpawn(@NotNull ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        this.setMax();
    }

    public void setMax() {
        this.setThirst(this.owner.getAnimal().getAnimalAttributes().getMetabolismProperties().getMaxWater());
        this.setHunger(this.owner.getAnimal().getAnimalAttributes().getMetabolismProperties().getMaxFood());
    }

    public boolean canTarget(LivingEntity mob) {
        return this.canTarget(true, mob);
    }

    public boolean canTarget(boolean withBias, LivingEntity mob) {
        boolean canTarget = false;
        for (Class<LivingEntity> huntTarget : this.owner.getAnimal().getAnimalAttributes().getSocialGroupProperties().getHuntTargets()) {
            if (!huntTarget.isInstance(mob) && mob.getClass() != huntTarget) continue;
            canTarget = true;
            break;
        }
        if (!canTarget) {
            return false;
        }
        if (withBias) {
            double boundingPoints = this.owner.getBbHeight() + this.owner.getBbWidth();
            double otherPoints = mob.getBbHeight() + mob.getBbWidth();
            double hungerBias = this.hungerPercentage();
            double distanceToOwner = this.owner.getAnimal().getAnimalAttributes().getSocialGroupProperties().getMinDistanceToPackLeader();
            double distanceSquare = distanceToOwner * distanceToOwner;
            if (hungerBias > (double)0.8f && mob.distanceToSqr((Entity)this.owner) > distanceSquare) {
                return false;
            }
            JSHerdModule herdModule = this.owner.getModules().getHerdModule();
            if (herdModule.isLeader() || herdModule.isFollower()) {
                if (herdModule.isLeader()) {
                    int size = herdModule.getHerdSize();
                    double extraPoints = boundingPoints * (double)size;
                    boundingPoints += extraPoints / 2.0;
                } else {
                    JSAnimalBase leader = herdModule.getTrueLeader();
                    if (leader.getTarget() == null) {
                        int size = leader.getModules().getHerdModule().getHerdSize();
                        double extraPoints = boundingPoints * (double)size;
                        boundingPoints += extraPoints / 2.0;
                    } else {
                        return false;
                    }
                }
            }
            return !(boundingPoints < (otherPoints *= hungerBias));
        }
        return true;
    }

    public double hungerPercentage() {
        return (double)this.getHunger() / (double)this.maxHunger;
    }

    public double thirstPercentage() {
        return (double)this.getThirst() / (double)this.maxThirst;
    }

    public void interrupt(int ticks) {
        this.isInterrupted = true;
        this.interruptTicks = ticks;
        this.owner.setSleeping(false);
        this.owner.setResting(false);
    }

    public void eatEntity(IJSEdibleEntity edible) {
        this.setHunger(this.getHunger() + edible.getFoodPoints(this.owner));
    }

    public boolean canEatCorpse(JSAnimalBase edible) {
        return true;
    }

    public void eatCorpse(JSAnimalBase edible) {
        this.setHunger((int)((float)this.getHunger() + 100.0f * (edible.getBbWidth() + edible.getBbHeight())));
    }

    public void addThirst(int thirst) {
        this.setThirst(this.getThirst() + thirst);
    }

    public boolean eatItem(ItemStack stack) {
        if (this.getDiet().canEatItem(stack)) {
            double foodValue = 100.0;
            FoodProperties food = (FoodProperties)stack.get(DataComponents.FOOD);
            if (food != null) {
                foodValue += (double)(3500.0f * ((float)food.nutrition() * food.saturation()));
            }
            this.setHunger((int)((double)this.getHunger() + foodValue));
            return true;
        }
        return false;
    }

    public boolean isHungerEnabled() {
        return this.hungerEnabled;
    }

    public boolean isThirstEnabled() {
        return this.thirstEnabled;
    }

    public boolean isSleepEnabled() {
        return this.sleepEnabled;
    }

    public boolean isBreedingEnabled() {
        return this.breedingEnabled;
    }

    public boolean isInterrupted() {
        return this.isInterrupted;
    }

    public int getMaxHunger() {
        return this.maxHunger;
    }

    public int getMaxThirst() {
        return this.maxThirst;
    }

    public int getTicksSleeping() {
        return this.ticksSleeping;
    }
}

