/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.nav;

import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.nav.JSGenericNav;
import jp.jurassicsaga.server.base.animal.entity.obj.nav.node.JSAmphibiousNodeEvaluator;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.pathingsystem.TravelersPathFinder;
import travelers.server.animal.entity.pathingsystem.navigation.TravelersPathNavigation;

public class JSAmphibiousNavigation
extends TravelersPathNavigation {
    private final boolean shallow;
    private final JSAnimalBase base;
    private int curNodeIndex = -1;
    private int nodeStuckTime = 0;

    public JSAmphibiousNavigation(JSAnimalBase mob, Level level, boolean shallow) {
        super((SmartAnimalBase)mob, level);
        this.shallow = shallow;
        this.base = mob;
    }

    protected void followThePath() {
        if (this.path == null) {
            return;
        }
        Vec3 temptPos = this.getTempMobPos();
        if (JSGenericNav.shouldTargetNextNodeInDirection(this.path, this.base)) {
            this.path.advance();
        }
        this.doStuckDetection(temptPos);
        if (this.isStuck()) {
            this.stop();
        }
    }

    protected boolean canUpdatePath() {
        return true;
    }

    protected Vec3 getTempMobPos() {
        return new Vec3(this.mob.getX(), this.mob.getY(0.5), this.mob.getZ());
    }

    protected double getGroundY(Vec3 p_217794_) {
        return p_217794_.y;
    }

    public boolean isStableDestination(BlockPos p_217799_) {
        return !this.level.getBlockState(p_217799_.below()).isAir();
    }

    public void setCanFloat(boolean p_217801_) {
    }

    private void checkStuckOnNode() {
        if (this.path == null) {
            return;
        }
        int nodeIndex = this.path.getNextNodeIndex() - 1;
        if (nodeIndex > 0) {
            if (nodeIndex > this.path.getNodeCount()) {
                return;
            }
            if (this.curNodeIndex == nodeIndex) {
                ++this.nodeStuckTime;
                if (this.nodeStuckTime > 50) {
                    this.recomputePath();
                }
                return;
            }
            this.nodeStuckTime = 0;
            this.curNodeIndex = nodeIndex;
        }
    }

    protected TravelersPathFinder createPathFinder() {
        this.nodeEvaluator = new JSAmphibiousNodeEvaluator(this.shallow);
        this.nodeEvaluator.setCanPassDoors(true);
        this.nodeEvaluator.setCanFloat(true);
        return new TravelersPathFinder(this.nodeEvaluator);
    }

    protected boolean canMoveDirectly(@NotNull Vec3 posVec31, @NotNull Vec3 posVec32) {
        return JSAmphibiousNavigation.isClearForMovementBetween((Mob)this.mob, (Vec3)posVec31, (Vec3)posVec32, (boolean)true);
    }
}

