/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.nav;

import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAvianBase;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import travelers.TravelersMain;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.pathingsystem.TravelersPath;
import travelers.server.animal.entity.pathingsystem.TravelersPathFinder;
import travelers.server.animal.entity.pathingsystem.navigation.TravelersFlyingNavigation;
import travelers.server.animal.entity.pathingsystem.node.TravelersFlyNodeEvaluator;
import travelers.server.packet.obj.TravelersPathFindingDebug;
import travelers.util.helper.TravelersPacketDistributor;

public class JSFlyingNavigation
extends TravelersFlyingNavigation {
    private final JSAvianBase base;
    private int curNodeIndex = -1;
    private int nodeStuckTime = 0;

    public JSFlyingNavigation(JSAvianBase mob, Level level) {
        super((SmartAnimalBase)mob, level);
        this.base = mob;
    }

    protected boolean canUpdatePath() {
        return this.canFloat() && this.mob.isInLiquid() || !this.mob.isPassenger();
    }

    protected Vec3 getTempMobPos() {
        return this.mob.position();
    }

    public void tick() {
        ++this.tick;
        if (this.hasDelayedRecomputation) {
            this.recomputePath();
        }
        if (!this.isDone() && !this.isLookingForPath) {
            if (this.canUpdatePath()) {
                this.followThePath();
            } else if (this.path != null && !this.path.isDone()) {
                Vec3 vec3 = this.getTempMobPos();
                Vec3 vec31 = this.path.getNextEntityPos((Entity)this.mob);
                if (vec31.distanceToSqr(vec3) <= (double)this.maxDistanceToWaypoint) {
                    this.path.advance();
                }
            }
            this.sendPathFinding(this.level, this.mob, this.path, this.maxDistanceToWaypoint);
            if (!this.isDone() && !this.isLookingForPath) {
                if (this.path == null) {
                    return;
                }
                Vec3 target = this.path.getNextEntityPos((Entity)this.mob);
                if (this.mob.position().closerThan((Position)target, (double)this.maxDistanceToWaypoint)) {
                    if (this.path.isDone()) {
                        this.stop();
                    }
                } else {
                    this.mob.getMoveController().setWantedPosition(target.x, target.y, target.z, this.speedModifier);
                }
            }
        }
    }

    void sendPathFinding(Level level, SmartAnimalBase mob, TravelersPath path, float maxDistanceToWaypoint) {
        if (TravelersMain.isDebugging()) {
            if (path == null || level.isClientSide) {
                return;
            }
            TravelersPacketDistributor.sendToPlayersTrackingEntity((SmartAnimalBase)mob, (CustomPacketPayload)new TravelersPathFindingDebug(mob.getId(), path, maxDistanceToWaypoint));
        }
    }

    protected void followThePath() {
        if (this.path == null) {
            return;
        }
        Vec3 temptPos = this.getTempMobPos();
        if (this.shouldTargetNextNodeInDirection(this.path, this.base, temptPos)) {
            this.path.advance();
        } else {
            this.checkStuckOnNode();
        }
        this.doStuckDetection(temptPos);
        if (this.isStuck()) {
            this.recomputePath();
        }
        if (this.path != null && this.path.isDone()) {
            this.stop();
        }
    }

    private void checkStuckOnNode() {
        if (this.path == null) {
            return;
        }
        int nodeIndex = this.path.getNextNodeIndex() - 1;
        if (nodeIndex < 0 || nodeIndex >= this.path.getNodeCount()) {
            return;
        }
        if (this.curNodeIndex == nodeIndex) {
            ++this.nodeStuckTime;
            if (this.nodeStuckTime > 50) {
                this.recomputePath();
            }
            return;
        }
        this.nodeStuckTime = 0;
        this.curNodeIndex = nodeIndex;
    }

    public boolean shouldTargetNextNodeInDirection(TravelersPath path, JSAvianBase mob, Vec3 vec) {
        if (path == null) {
            return false;
        }
        int nextNodeIndex = path.getNextNodeIndex();
        if (nextNodeIndex >= path.getNodeCount()) {
            return false;
        }
        Vec3 vec31 = Vec3.atCenterOf((Vec3i)path.getNodePos(nextNodeIndex));
        Vec3 pos = mob.position();
        return vec31.closerThan(pos, (double)Math.max(1.0f, mob.getBbWidth() / 2.0f), (double)Math.max(1.0f, mob.getBbHeight() * 2.0f));
    }

    protected boolean canMoveDirectly(@NotNull Vec3 posVec31, @NotNull Vec3 posVec32) {
        return JSFlyingNavigation.isClearForMovementBetween((Mob)this.mob, (Vec3)posVec31, (Vec3)posVec32, (boolean)false);
    }

    @NotNull
    protected TravelersPathFinder createPathFinder() {
        this.nodeEvaluator = new TravelersFlyNodeEvaluator();
        return new TravelersPathFinder(this.nodeEvaluator);
    }
}

