/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.nav;

import java.util.concurrent.CompletableFuture;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.nav.JSGenericNav;
import jp.jurassicsaga.server.base.animal.entity.obj.nav.node.JSWalkNodeEvaluator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.pathingsystem.TravelersPath;
import travelers.server.animal.entity.pathingsystem.TravelersPathFinder;
import travelers.server.animal.entity.pathingsystem.navigation.TravelersPathNavigation;

public class JSGroundNavigation
extends TravelersPathNavigation {
    private final JSAnimalBase base;
    private int curNodeIndex = -1;
    private int nodeStuckTime = 0;

    public JSGroundNavigation(JSAnimalBase mob, Level level) {
        super((SmartAnimalBase)mob, level);
        this.base = mob;
    }

    protected boolean canUpdatePath() {
        return this.mob.onGround() || this.mob.isInLiquid() || this.mob.isPassenger();
    }

    protected Vec3 getTempMobPos() {
        return new Vec3(this.mob.getX(), (double)this.getSurfaceY(), this.mob.getZ());
    }

    public CompletableFuture<TravelersPath> createPath(BlockPos pos, int accuracy) {
        LevelChunk levelchunk = this.level.getChunkSource().getChunkNow(SectionPos.blockToSectionCoord((int)pos.getX()), SectionPos.blockToSectionCoord((int)pos.getZ()));
        if (levelchunk == null) {
            return null;
        }
        if (levelchunk.getBlockState(pos).isAir()) {
            BlockPos blockpos = pos.below();
            while (blockpos.getY() > this.level.getMinBuildHeight() && levelchunk.getBlockState(blockpos).isAir()) {
                blockpos = blockpos.below();
            }
            if (blockpos.getY() > this.level.getMinBuildHeight()) {
                return super.createPath(blockpos.above(), accuracy);
            }
            while (blockpos.getY() < this.level.getMaxBuildHeight() && levelchunk.getBlockState(blockpos).isAir()) {
                blockpos = blockpos.above();
            }
            pos = blockpos;
        }
        if (!levelchunk.getBlockState(pos).isSolid()) {
            return super.createPath(pos, accuracy);
        }
        BlockPos blockpos1 = pos.above();
        while (blockpos1.getY() < this.level.getMaxBuildHeight() && levelchunk.getBlockState(blockpos1).isSolid()) {
            blockpos1 = blockpos1.above();
        }
        return super.createPath(blockpos1, accuracy);
    }

    public CompletableFuture<TravelersPath> createPath(Entity entity, int accuracy) {
        return this.createPath(entity.blockPosition(), accuracy);
    }

    private int getSurfaceY() {
        if (this.mob.isInWater() && !this.mob.onGround()) {
            int i = this.mob.getBlockY();
            BlockState blockstate = this.level.getBlockState(BlockPos.containing((double)this.mob.getX(), (double)i, (double)this.mob.getZ()));
            int j = 0;
            while (blockstate.is(Blocks.WATER)) {
                blockstate = this.level.getBlockState(BlockPos.containing((double)this.mob.getX(), (double)(++i), (double)this.mob.getZ()));
                if (++j <= 16) continue;
                return this.mob.getBlockY();
            }
            return i;
        }
        return Mth.floor((double)(this.mob.getY() + 0.5));
    }

    public boolean isStableDestination(BlockPos pos) {
        BlockPos blockpos = pos.below();
        BlockState state = this.level.getBlockState(blockpos);
        if (this.base.isInWaterOrBubble()) {
            return true;
        }
        return state.isSolidRender((BlockGetter)this.level, blockpos);
    }

    protected void followThePath() {
        if (this.path == null) {
            return;
        }
        Vec3 temptPos = this.getTempMobPos();
        if (JSGenericNav.shouldTargetNextNodeInDirection(this.path, this.base)) {
            this.path.advance();
        }
        this.checkStuckOnNode();
        if (this.path != null && this.getPath().isDone()) {
            this.stop();
        }
    }

    private void checkStuckOnNode() {
        if (this.path == null) {
            return;
        }
        int nodeIndex = this.path.getNextNodeIndex() - 1;
        if (nodeIndex >= 0) {
            if (nodeIndex > this.path.getNodeCount()) {
                return;
            }
            if (this.curNodeIndex == nodeIndex) {
                ++this.nodeStuckTime;
                if (this.nodeStuckTime > 200) {
                    this.stop();
                }
                return;
            }
            this.nodeStuckTime = 0;
            this.curNodeIndex = nodeIndex;
        }
    }

    public void stop() {
        super.stop();
        this.nodeStuckTime = 0;
        this.curNodeIndex = -1;
    }

    @NotNull
    protected TravelersPathFinder createPathFinder() {
        this.nodeEvaluator = new JSWalkNodeEvaluator();
        return new TravelersPathFinder(this.nodeEvaluator);
    }

    protected boolean canMoveDirectly(@NotNull Vec3 posVec31, @NotNull Vec3 posVec32) {
        return JSGroundNavigation.isClearForMovementBetween((Mob)this.mob, (Vec3)posVec31, (Vec3)posVec32, (boolean)false);
    }

    public void setCanOpenDoors(boolean canOpenDoors) {
        this.nodeEvaluator.setCanOpenDoors(canOpenDoors);
    }

    public boolean canPassDoors() {
        return this.nodeEvaluator.isCanPassDoors();
    }

    public void setCanPassDoors(boolean canPassDoors) {
        this.nodeEvaluator.setCanPassDoors(canPassDoors);
    }

    public boolean canOpenDoors() {
        return this.nodeEvaluator.isCanOpenDoors();
    }

    public void setCanWalkOverFences(boolean canWalkOverFences) {
        this.nodeEvaluator.setCanWalkOverFences(canWalkOverFences);
    }

    public boolean avoidsLight() {
        return ((JSWalkNodeEvaluator)this.nodeEvaluator).isTriesToAvoidLight();
    }

    public void setCanClimb(boolean b) {
        ((JSWalkNodeEvaluator)this.nodeEvaluator).setCanClimb(b);
    }
}

