/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.nav.node;

import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.EnumMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.pathingsystem.node.TravelersNodeEvaluator;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersNode;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersPathType;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersPathfindingContext;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersTarget;

public class JSAquaticNodeEvaluator
extends TravelersNodeEvaluator {
    private final boolean allowBreaching;
    private final Long2ObjectMap<TravelersPathType> pathTypesByPosCache = new Long2ObjectOpenHashMap();

    public JSAquaticNodeEvaluator(boolean allowBreaching) {
        this.allowBreaching = allowBreaching;
    }

    public void prepare(@NotNull PathNavigationRegion level, @NotNull SmartAnimalBase mob) {
        super.prepare(level, mob);
        this.pathTypesByPosCache.clear();
    }

    public void done() {
        super.done();
        this.pathTypesByPosCache.clear();
    }

    @NotNull
    public TravelersNode getStart() {
        BlockPos position = this.mob.blockPosition();
        return this.getNode(position.getX(), position.getY(), position.getZ());
    }

    @NotNull
    public TravelersTarget getTarget(double x, double y, double z) {
        return this.getTargetNodeAt(x, y, z);
    }

    public int getNeighbors(TravelersNode @NotNull [] outputArray, @NotNull TravelersNode p_node) {
        int i = 0;
        EnumMap map = Maps.newEnumMap(Direction.class);
        for (Direction direction : Direction.values()) {
            TravelersNode node = this.findAcceptedNode(p_node.x + direction.getStepX(), p_node.y + direction.getStepY(), p_node.z + direction.getStepZ());
            map.put(direction, node);
            if (!this.isNodeValid(node)) continue;
            outputArray[i++] = node;
        }
        for (Direction direction1 : Direction.Plane.HORIZONTAL) {
            TravelersNode node1;
            Direction direction2 = direction1.getClockWise();
            if (!JSAquaticNodeEvaluator.hasMalus((TravelersNode)map.get(direction1)) || !JSAquaticNodeEvaluator.hasMalus((TravelersNode)map.get(direction2)) || !this.isNodeValid(node1 = this.findAcceptedNode(p_node.x + direction1.getStepX() + direction2.getStepX(), p_node.y, p_node.z + direction1.getStepZ() + direction2.getStepZ()))) continue;
            outputArray[i++] = node1;
        }
        return i;
    }

    protected boolean isNodeValid(@Nullable TravelersNode node) {
        return node != null && !node.closed;
    }

    private static boolean hasMalus(@Nullable TravelersNode node) {
        return node != null && node.costMalus >= 0.0f;
    }

    @Nullable
    protected TravelersNode findAcceptedNode(int x, int y, int z) {
        float f;
        TravelersNode node = null;
        TravelersPathType pathtype = this.getCachedBlockType(x, y, z);
        if ((this.allowBreaching && pathtype == TravelersPathType.BREACH || pathtype == TravelersPathType.WATER) && (f = this.mob.getPathfindingMalus(pathtype)) >= 0.0f) {
            node = this.getNode(x, y, z);
            node.type = pathtype;
            node.costMalus = Math.max(node.costMalus, f);
            BlockPos pos = new BlockPos(x, y, z);
            CollisionGetter level = this.context.level();
            if (!level.getBlockState(pos).getCollisionShape((BlockGetter)level, pos).isEmpty()) {
                return null;
            }
            if (level.getFluidState(pos).isEmpty()) {
                node.costMalus += 8.0f;
            }
        }
        if (node != null) {
            if (!this.makeSureYFits(node.x, node.y, node.z)) {
                return null;
            }
            if (!this.canMobStandAt(node.x, node.y, node.z)) {
                return null;
            }
        }
        return node;
    }

    protected boolean canMobStandAt(int x, int y, int z) {
        int height = Mth.ceil((float)((float)this.entityHeight / 2.0f));
        int halfHeight = Math.max(1, height / 2);
        for (int i = -halfHeight; i < halfHeight; ++i) {
            if (!this.isSpaceValidForStanding(x, y + i, z)) continue;
            return true;
        }
        return false;
    }

    protected boolean isSpaceValidForStanding(int x, int y, int z) {
        AABB box = this.mob.getBoundingBox();
        double width = box.getXsize();
        double height = box.getYsize();
        double depth = box.getZsize();
        double centerX = (double)x + 0.5;
        double centerZ = (double)z + 0.5;
        int minX = Mth.floor((double)(centerX - width / 2.0));
        int maxX = Mth.ceil((double)(centerX + width / 2.0));
        int minY = y;
        int maxY = Mth.ceil((double)((double)y + height));
        int minZ = Mth.floor((double)(centerZ - depth / 2.0));
        int maxZ = Mth.ceil((double)(centerZ + depth / 2.0));
        for (int xi = minX; xi < maxX; ++xi) {
            for (int yi = minY; yi < maxY; ++yi) {
                for (int zi = minZ; zi < maxZ; ++zi) {
                    TravelersPathType type = this.getPathType(this.context, xi, yi, zi);
                    if (type == TravelersPathType.OPEN || type == TravelersPathType.WATER || type == TravelersPathType.WATER_BORDER) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean makeSureYFits(int x, int y, int z) {
        AABB box = this.mob.getBoundingBox();
        double height = box.getYsize();
        double halfHeight = height / 2.0;
        int minY = Mth.floor((double)((double)y + halfHeight));
        int maxY = Mth.ceil((double)((double)y + halfHeight));
        for (int yi = minY; yi < maxY; ++yi) {
            TravelersPathType type = this.getPathType(this.context, x, yi, z);
            if (!(yi == minY ? type != TravelersPathType.WALKABLE && type != TravelersPathType.OPEN && type != TravelersPathType.WATER && type != TravelersPathType.WATER_BORDER : type != TravelersPathType.OPEN && type != TravelersPathType.WATER && type != TravelersPathType.WATER_BORDER)) continue;
            return false;
        }
        return true;
    }

    private boolean hasCollisions(AABB boundingBox) {
        return !this.context.level().noCollision((Entity)this.mob, boundingBox);
    }

    protected TravelersPathType getCachedBlockType(int x, int y, int z) {
        return (TravelersPathType)this.pathTypesByPosCache.computeIfAbsent(BlockPos.asLong((int)x, (int)y, (int)z), p_330157_ -> this.getPathType(this.context, x, y, z));
    }

    @NotNull
    public TravelersPathType getPathType(@NotNull TravelersPathfindingContext context, int x, int y, int z) {
        return this.getPathTypeOfMob(context, x, y, z, this.mob);
    }

    @NotNull
    public TravelersPathType getPathTypeOfMob(@NotNull TravelersPathfindingContext context, int x, int y, int z, @NotNull SmartAnimalBase mob) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        if (mob == null) {
            return TravelersPathType.BLOCKED;
        }
        BlockState blockstate = context.getBlockState((BlockPos)blockpos$mutableblockpos.set(x, y, z));
        FluidState fluidstate = blockstate.getFluidState();
        if (fluidstate.isEmpty() && blockstate.isPathfindable(PathComputationType.WATER) && blockstate.isAir()) {
            return TravelersPathType.BREACH;
        }
        BlockState blockstate1 = context.getBlockState((BlockPos)blockpos$mutableblockpos);
        return blockstate1.isPathfindable(PathComputationType.WATER) ? TravelersPathType.WATER : TravelersPathType.BREACH;
    }
}

