/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.nav.node;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.EnumSet;
import java.util.Set;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.pathingsystem.node.TravelersNodeEvaluator;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersNode;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersPathType;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersPathfindingContext;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersTarget;

public class JSWalkNodeEvaluator
extends TravelersNodeEvaluator {
    private final Long2ObjectMap<TravelersPathType> pathTypesByPosCacheByMob = new Long2ObjectOpenHashMap();
    private final TravelersNode[] reusableNeighbors = new TravelersNode[Direction.Plane.HORIZONTAL.length()];
    private static final int FIXED_STEP_HEIGHT = 1;
    private int samplesPerBlock = 3;
    private boolean triesToAvoidLight = false;
    private boolean canClimb;
    private boolean canClimbAnyBlock = false;

    public void setSamplesPerBlock(int samples) {
        this.samplesPerBlock = Math.max(1, samples);
    }

    public void markDirty(BlockPos pos) {
        this.pathTypesByPosCacheByMob.remove(pos.asLong());
    }

    private static boolean doesBlockHavePartialCollision(TravelersPathType pathType) {
        return pathType == TravelersPathType.FENCE || pathType == TravelersPathType.DOOR_WOOD_CLOSED || pathType == TravelersPathType.DOOR_IRON_CLOSED;
    }

    public static double getFloorLevel(BlockGetter level, BlockPos pos) {
        BlockPos blockpos = pos.below();
        BlockState below = level.getBlockState(blockpos);
        VoxelShape shape = below.getCollisionShape(level, blockpos);
        return (double)blockpos.getY() + (shape.isEmpty() ? 0.0 : shape.max(Direction.Axis.Y));
    }

    public void prepare(@NotNull PathNavigationRegion level, @NotNull SmartAnimalBase mob) {
        super.prepare(level, mob);
        this.triesToAvoidLight = mob.avoidsLight();
        mob.onPathfindingStart();
    }

    public void done() {
        if (this.mob != null) {
            this.mob.onPathfindingDone();
        }
        this.pathTypesByPosCacheByMob.clear();
        super.done();
    }

    @NotNull
    public TravelersNode getStart() {
        Vec3 mobPos = this.mob.position();
        BlockPos pos = new BlockPos(Mth.floor((double)mobPos.x), Mth.floor((double)mobPos.y), Mth.floor((double)mobPos.z));
        if (this.mob.isInWaterOrBubble() && !this.isAmphibious()) {
            BlockPos.MutableBlockPos mutable = pos.mutable();
            for (int tries = 15; tries > 0; --tries) {
                boolean hasWater;
                mutable = mutable.above().mutable();
                boolean bl = hasWater = !this.context.level().getFluidState((BlockPos)mutable).isEmpty();
                if (hasWater) continue;
                pos = mutable.below();
                break;
            }
        }
        return this.getStartNode(pos);
    }

    protected TravelersNode getStartNode(BlockPos pos) {
        TravelersNode node = this.getNode(pos);
        node.type = this.getPathType(node.x, node.y, node.z);
        node.costMalus = this.mob.getPathfindingMalus(node.type);
        return node;
    }

    protected boolean canStartAt(BlockPos pos) {
        TravelersPathType pt = this.getPathType(pos.getX(), pos.getY(), pos.getZ());
        return pt != TravelersPathType.OPEN && this.mob.getPathfindingMalus(pt) >= 0.0f;
    }

    @NotNull
    public TravelersTarget getTarget(double x, double y, double z) {
        return this.getTargetNodeAt(x, y, z);
    }

    public int getNeighbors(TravelersNode @NotNull [] outputArray, TravelersNode p_node) {
        TravelersNode downNode;
        int count = 0;
        TravelersPathType aboveType = this.getPathType(p_node.x, p_node.y + 1, p_node.z);
        TravelersPathType currentType = this.getPathType(p_node.x, p_node.y, p_node.z);
        int maxStep = 0;
        if (this.mob.getPathfindingMalus(aboveType) >= 0.0f && currentType != TravelersPathType.STICKY_HONEY) {
            maxStep = 1;
        }
        double floorLevel = this.getFloorLevel(new BlockPos(p_node.x, p_node.y, p_node.z));
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            TravelersNode upNode;
            TravelersNode n;
            this.reusableNeighbors[dir.get2DDataValue()] = n = this.findAcceptedNode(p_node, p_node.x + dir.getStepX(), p_node.y, p_node.z + dir.getStepZ(), maxStep, floorLevel, dir, currentType);
            if (this.isNeighborValid(n, p_node)) {
                outputArray[count++] = n;
            }
            if (!this.isNeighborValid(upNode = this.findAcceptedNode(p_node, p_node.x, p_node.y + 1, p_node.z, maxStep, floorLevel, Direction.UP, currentType), p_node)) continue;
            boolean present = false;
            for (int i = 0; i < count; ++i) {
                if (outputArray[i] != upNode) continue;
                present = true;
                break;
            }
            if (present) continue;
            outputArray[count++] = upNode;
        }
        TravelersNode upNode = this.findAcceptedNode(p_node, p_node.x, p_node.y + 1, p_node.z, maxStep, floorLevel, Direction.UP, currentType);
        if (this.isNeighborValid(upNode, p_node)) {
            boolean present = false;
            for (int i = 0; i < count; ++i) {
                if (outputArray[i] != upNode) continue;
                present = true;
                break;
            }
            if (!present) {
                outputArray[count++] = upNode;
            }
        }
        if (this.isNeighborValid(downNode = this.findAcceptedNode(p_node, p_node.x, p_node.y - 1, p_node.z, maxStep, floorLevel, Direction.DOWN, currentType), p_node)) {
            boolean present = false;
            for (int i = 0; i < count; ++i) {
                if (outputArray[i] != downNode) continue;
                present = true;
                break;
            }
            if (!present) {
                outputArray[count++] = downNode;
            }
        }
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            int idx;
            boolean present;
            TravelersNode diag;
            TravelersNode b;
            Direction cw = dir.getClockWise();
            TravelersNode a = this.reusableNeighbors[dir.get2DDataValue()];
            if (!this.isDiagonalValid(p_node, a, b = this.reusableNeighbors[cw.get2DDataValue()]) || !this.isDiagonalValid(diag = this.findAcceptedNode(p_node, p_node.x + dir.getStepX() + cw.getStepX(), p_node.y, p_node.z + dir.getStepZ() + cw.getStepZ(), maxStep, floorLevel, dir, currentType))) continue;
            boolean diagonalClear = !this.cantMoveBetween(p_node, diag);
            boolean orthogonalsClear = true;
            if (a != null) {
                orthogonalsClear &= !this.cantMoveBetween(p_node, a) && !this.cantMoveBetween(a, diag);
            }
            if (b != null) {
                orthogonalsClear &= !this.cantMoveBetween(p_node, b) && !this.cantMoveBetween(b, diag);
            }
            if (diagonalClear && orthogonalsClear) {
                outputArray[count++] = diag;
                continue;
            }
            if (a != null && this.isNeighborValid(a, p_node)) {
                present = false;
                for (idx = 0; idx < count; ++idx) {
                    if (outputArray[idx] != a) continue;
                    present = true;
                    break;
                }
                if (!present) {
                    outputArray[count++] = a;
                }
            }
            if (b == null || !this.isNeighborValid(b, p_node)) continue;
            present = false;
            for (idx = 0; idx < count; ++idx) {
                if (outputArray[idx] != b) continue;
                present = true;
                break;
            }
            if (present) continue;
            outputArray[count++] = b;
        }
        return count;
    }

    protected boolean isNeighborValid(@Nullable TravelersNode neighbor, TravelersNode node) {
        return neighbor != null && !neighbor.closed && (neighbor.costMalus >= 0.0f || node.costMalus < 0.0f);
    }

    protected boolean isDiagonalValid(TravelersNode root, @Nullable TravelersNode xNode, @Nullable TravelersNode zNode) {
        boolean canUseDoors;
        if (zNode == null || xNode == null || zNode.y > root.y || xNode.y > root.y) {
            return false;
        }
        boolean bl = canUseDoors = this.isCanPassDoors() || this.isCanOpenDoors();
        if (!(xNode.type != TravelersPathType.WALKABLE_DOOR && zNode.type != TravelersPathType.WALKABLE_DOOR || canUseDoors)) {
            return false;
        }
        boolean narrowFencePass = zNode.type == TravelersPathType.FENCE && xNode.type == TravelersPathType.FENCE && (double)this.mob.getBbWidth() < 0.5;
        return (zNode.y < root.y || zNode.costMalus >= 0.0f || narrowFencePass) && (xNode.y < root.y || xNode.costMalus >= 0.0f || narrowFencePass);
    }

    protected boolean isDiagonalValid(@Nullable TravelersNode node) {
        if (node == null || node.closed) {
            return false;
        }
        return node.type != TravelersPathType.WALKABLE_DOOR || this.isCanPassDoors() || this.isCanOpenDoors();
    }

    private boolean cantMoveBetween(TravelersNode from, TravelersNode to) {
        double mobWidth;
        if (from == null || to == null) {
            return false;
        }
        int dx = to.x - from.x;
        int dy = to.y - from.y;
        int dz = to.z - from.z;
        int steps = Math.max(1, Math.max(Math.abs(dx), Math.max(Math.abs(dy), Math.abs(dz))));
        int totalSamples = Math.max(1, steps * this.samplesPerBlock);
        double mobDepth = mobWidth = (double)this.mob.getBbWidth();
        double mobHeight = this.mob.getBbHeight();
        double halfW = mobWidth / 2.0;
        double halfD = mobDepth / 2.0;
        for (int s = 1; s <= totalSamples; ++s) {
            double t = (double)s / (double)totalSamples;
            double sampleX = (double)from.x + 0.5 + (double)dx * t;
            double sampleY = (double)from.y + (double)dy * t;
            double sampleZ = (double)from.z + 0.5 + (double)dz * t;
            AABB sampleBox = new AABB(sampleX - halfW, sampleY, sampleZ - halfD, sampleX + halfW, sampleY + mobHeight, sampleZ + halfD);
            if (!this.context.level().noCollision((Entity)this.mob, sampleBox)) {
                return true;
            }
            int minX = Mth.floor((double)sampleBox.minX);
            int maxX = Mth.floor((double)sampleBox.maxX);
            int minY = Mth.floor((double)sampleBox.minY);
            int maxY = Mth.ceil((double)sampleBox.maxY);
            int minZ = Mth.floor((double)sampleBox.minZ);
            int maxZ = Mth.floor((double)sampleBox.maxZ);
            for (int xi = minX; xi <= maxX; ++xi) {
                for (int yi = minY; yi <= maxY; ++yi) {
                    for (int zi = minZ; zi <= maxZ; ++zi) {
                        double horizontalDist;
                        TravelersPathType pt = this.getPathType(this.context, xi, yi, zi);
                        if (pt == TravelersPathType.UNPASSABLE_RAIL || pt == TravelersPathType.POWDER_SNOW || pt == TravelersPathType.TRAPDOOR) {
                            return true;
                        }
                        if (pt != TravelersPathType.WATER || this.isAmphibious() || this.isCanFloat() || !((horizontalDist = Math.hypot(sampleX - ((double)from.x + 0.5), sampleZ - ((double)from.z + 0.5))) > 0.5)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    protected double getFloorLevel(BlockPos pos) {
        CollisionGetter blockgetter = this.context.level();
        return (this.isCanFloat() || this.isAmphibious() || this.mob.onGround() && !this.mob.isEyeInFluid(FluidTags.WATER)) && blockgetter.getFluidState(pos).is(FluidTags.WATER) ? (double)pos.getY() : JSWalkNodeEvaluator.getFloorLevel((BlockGetter)blockgetter, pos);
    }

    protected boolean isAmphibious() {
        return false;
    }

    @Nullable
    protected TravelersNode findAcceptedNode(TravelersNode p_node, int x, int y, int z, int verticalDeltaLimit, double nodeFloorLevel, Direction direction, TravelersPathType pathType) {
        int blockLight;
        BlockPos pos;
        Level level;
        int skyLight;
        int totalLight;
        int darkness;
        Level state2;
        TravelersNode node = null;
        TravelersPathType pathtype = this.getPathType(x, y, z);
        nodeFloorLevel = Math.floor(nodeFloorLevel);
        double diff = (double)y - nodeFloorLevel;
        if (!this.canClimb && Math.abs(diff) > Math.floor(this.getMobJumpHeight())) {
            return null;
        }
        float malus = this.mob.getPathfindingMalus(pathtype);
        if (this.canClimb && this.isClimbableAt(x, y, z)) {
            node = this.getNodeAndUpdateCostToMax(x, y, z, TravelersPathType.WALKABLE, this.mob.getPathfindingMalus(TravelersPathType.WALKABLE));
        }
        if (pathtype == TravelersPathType.WATER && this.canMobDive() && p_node != null && y < p_node.y) {
            boolean allWater = true;
            double halfW = (double)this.mob.getBbWidth() / 2.0;
            double height = this.mob.getBbHeight();
            for (int yi = p_node.y - 1; yi >= y; --yi) {
                TravelersPathType t = this.getPathType(this.context, x, yi, z);
                if (t != TravelersPathType.WATER && t != TravelersPathType.WATER_BORDER) {
                    allWater = false;
                    break;
                }
                AABB box = new AABB((double)x + 0.5 - halfW, (double)yi, (double)z + 0.5 - halfW, (double)x + 0.5 + halfW, (double)yi + height, (double)z + 0.5 + halfW);
                if (this.context.level().noCollision((Entity)this.mob, box)) continue;
                allWater = false;
                break;
            }
            if (allWater) {
                node = this.getNodeAndUpdateCostToMax(x, y, z, pathtype, this.mob.getPathfindingMalus(pathtype));
            }
        }
        if (malus >= 0.0f) {
            TravelersNode travelersNode = node = node == null ? this.getNodeAndUpdateCostToMax(x, y, z, pathtype, malus) : node;
        }
        if (node != null && (double)Math.abs(node.y - y) > Math.floor(this.getMob().maxUpStep())) {
            return null;
        }
        if (diff < -1.0 && node != null) {
            for (int i = 1; i <= (int)(-diff); ++i) {
                BlockState state2 = this.context.getBlockState(new BlockPos(x, y + i, z));
                if (!state2.isSolid()) continue;
                return null;
            }
        }
        if (pathtype != TravelersPathType.WALKABLE) {
            if ((node == null || node.costMalus < 0.0f) && (pathtype != TravelersPathType.FENCE || this.isCanWalkOverFences() || this.getMobJumpHeight() > (double)1.2f) && pathtype != TravelersPathType.UNPASSABLE_RAIL && pathtype != TravelersPathType.TRAPDOOR && pathtype != TravelersPathType.POWDER_SNOW) {
                node = this.tryJumpOn(x, y, z, verticalDeltaLimit, nodeFloorLevel, direction, pathType);
            } else if (!(this.isAmphibious() && !this.mob.onGround() || pathtype != TravelersPathType.WATER || this.isCanFloat() && !this.mob.onGround())) {
                node = this.tryFindFirstNonWaterBelow(x, y, z, node);
            } else if (pathtype == TravelersPathType.OPEN) {
                node = this.tryFindFirstGroundNodeBelow(x, y, z);
            } else if (JSWalkNodeEvaluator.doesBlockHavePartialCollision(pathtype) && node == null) {
                node = this.getClosedNode(x, y, z, pathtype);
            }
        }
        if (this.triesToAvoidLight && node != null && pathtype == TravelersPathType.WALKABLE && (state2 = this.mob.level()) instanceof Level && (float)(darkness = 15 - (totalLight = Math.min(15, (skyLight = (level = state2).getBrightness(LightLayer.SKY, pos = node.asBlockPos())) + (blockLight = level.getBrightness(LightLayer.BLOCK, pos))))) < 2.0f) {
            node.type = TravelersPathType.LIGHT;
        }
        if (node != null) {
            if (!this.makeSureYFits(node.x, node.y, node.z)) {
                return null;
            }
            if (!(pathtype == TravelersPathType.WATER || this.canMobStandAt(node.x, node.y, node.z) || this.canClimb && this.isClimbableAt(node.x, node.y, node.z))) {
                return null;
            }
        }
        return node;
    }

    private boolean canMobDive() {
        return this.mob.getTarget() != null;
    }

    private boolean makeSureYFits(int x, int y, int z) {
        double height = this.mob.getBbHeight();
        int maxY = y + Mth.ceil((double)height) - 1;
        for (int yi = y; yi <= maxY; ++yi) {
            TravelersPathType type = this.getPathType(this.context, x, yi, z);
            if (type == TravelersPathType.WALKABLE || type == TravelersPathType.OPEN || type == TravelersPathType.WATER || type == TravelersPathType.WATER_BORDER || !(this.canOpenDoors || this.canPassDoors ? type != TravelersPathType.DOOR_OPEN && type != TravelersPathType.DOOR_WOOD_CLOSED && (!this.canClimb || !this.isClimbableAt(x, yi, z)) : !this.canClimb || !this.isClimbableAt(x, yi, z))) continue;
            return false;
        }
        return true;
    }

    private double getMobJumpHeight() {
        SmartAnimalBase smartAnimalBase = this.mob;
        if (smartAnimalBase instanceof JSAnimalBase) {
            JSAnimalBase base = (JSAnimalBase)smartAnimalBase;
            return this.canClimb ? (double)(base.getBbHeight() * 10.0f) : base.jumpHeight();
        }
        return 1.0;
    }

    private TravelersNode getNodeAndUpdateCostToMax(int x, int y, int z, TravelersPathType pathType, float malus) {
        TravelersNode node = this.getNode(x, y, z);
        node.type = pathType;
        node.costMalus = Math.max(node.costMalus, malus);
        return node;
    }

    private TravelersNode getBlockedNode(int x, int y, int z) {
        TravelersNode node = this.getNode(x, y, z);
        node.type = TravelersPathType.BLOCKED;
        node.costMalus = -1.0f;
        return node;
    }

    private TravelersNode getClosedNode(int x, int y, int z, TravelersPathType pathType) {
        TravelersNode node = this.getNode(x, y, z);
        node.closed = true;
        node.type = pathType;
        node.costMalus = pathType.getMalus();
        return node;
    }

    @Nullable
    private TravelersNode tryJumpOn(int x, int y, int z, int verticalDeltaLimit, double nodeFloorLevel, Direction direction, TravelersPathType pathType) {
        TravelersNode up = this.findAcceptedNode(null, x, y + 1, z, verticalDeltaLimit, nodeFloorLevel, direction, pathType);
        if (up == null) {
            return null;
        }
        if (up.type != TravelersPathType.OPEN && up.type != TravelersPathType.WALKABLE) {
            return up;
        }
        double baseX = (double)(x - direction.getStepX()) + 0.5;
        double baseZ = (double)(z - direction.getStepZ()) + 0.5;
        AABB swept = new AABB(Math.min(baseX - 0.5, baseX - 0.5), this.getFloorLevel(new BlockPos(x, y + 1, z)), Math.min(baseZ - 0.5, baseZ - 0.5), Math.max(baseX + 0.5, baseX + 0.5), this.getFloorLevel(new BlockPos((int)baseX, y + (int)this.getMobJumpHeight(), (int)baseZ)), Math.max(baseZ + 0.5, baseZ + 0.5));
        if (!this.context.level().noCollision((Entity)this.mob, swept)) {
            return null;
        }
        return up;
    }

    protected boolean canMobStandAt(int x, int y, int z) {
        int half = Mth.ceil((float)((float)this.entityHeight / 2.0f));
        for (int i = -1; i <= half; ++i) {
            if (!this.isSpaceValidForStanding(x, y + i, z)) continue;
            return true;
        }
        return false;
    }

    protected boolean isSpaceValidForStanding(int x, int y, int z) {
        double width = this.mob.getBbWidth();
        double height = this.mob.getBbHeight();
        double depth = width;
        double centerX = (double)x + 0.5;
        double centerZ = (double)z + 0.5;
        int minX = Mth.floor((double)(centerX - width / 2.0));
        int maxX = Mth.floor((double)(centerX + width / 2.0));
        int minY = y;
        int maxY = Mth.floor((double)((double)y + height));
        int minZ = Mth.floor((double)(centerZ - width / 2.0));
        int maxZ = Mth.floor((double)(centerZ + width / 2.0));
        for (int xi = minX; xi <= maxX; ++xi) {
            for (int yi = minY; yi <= maxY; ++yi) {
                for (int zi = minZ; zi <= maxZ; ++zi) {
                    TravelersPathType type = this.getPathType(this.context, xi, yi, zi);
                    if (type == TravelersPathType.WALKABLE || type == TravelersPathType.OPEN || type == TravelersPathType.WATER || type == TravelersPathType.WATER_BORDER || !(this.canOpenDoors || this.canPassDoors ? type != TravelersPathType.DOOR_OPEN && type != TravelersPathType.DOOR_WOOD_CLOSED && (!this.canClimb || !this.isClimbableAt(xi, yi, zi)) : !this.canClimb || !this.isClimbableAt(xi, yi, zi))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Nullable
    private TravelersNode tryFindFirstNonWaterBelow(int x, int y, int z, @Nullable TravelersNode node) {
        --y;
        while (y > this.mob.level().getMinBuildHeight()) {
            TravelersPathType pathtype = this.getPathType(x, y, z);
            if (pathtype != TravelersPathType.WATER) {
                return node;
            }
            node = this.getNodeAndUpdateCostToMax(x, y, z, pathtype, this.mob.getPathfindingMalus(pathtype));
            --y;
        }
        return node;
    }

    private TravelersNode tryFindFirstGroundNodeBelow(int x, int y, int z) {
        for (int i = y - 1; i >= this.mob.level().getMinBuildHeight(); --i) {
            if (y - i > this.mob.getMaxFallDistance()) {
                return this.getBlockedNode(x, i, z);
            }
            TravelersPathType pathtype = this.getPathType(x, i, z);
            float f = this.mob.getPathfindingMalus(pathtype);
            if (pathtype == TravelersPathType.OPEN) continue;
            if (f >= 0.0f) {
                return this.getNodeAndUpdateCostToMax(x, i, z, pathtype, f);
            }
            return this.getBlockedNode(x, i, z);
        }
        return this.getBlockedNode(x, y, z);
    }

    protected TravelersPathType getPathType(int x, int y, int z) {
        return (TravelersPathType)this.pathTypesByPosCacheByMob.computeIfAbsent(BlockPos.asLong((int)x, (int)y, (int)z), p -> this.getPathTypeOfMob(this.context, x, y, z, this.mob));
    }

    public TravelersPathType getPathTypeOfMob(TravelersPathfindingContext context, int x, int y, int z, SmartAnimalBase mob) {
        Set<TravelersPathType> set = this.getPathTypeWithinMobBB(context, x, y, z);
        if (set.contains(TravelersPathType.FENCE)) {
            return TravelersPathType.FENCE;
        }
        if (set.contains(TravelersPathType.UNPASSABLE_RAIL)) {
            return TravelersPathType.UNPASSABLE_RAIL;
        }
        TravelersPathType chosen = TravelersPathType.BLOCKED;
        for (TravelersPathType t : set) {
            if (mob.getPathfindingMalus(t) < 0.0f) {
                return t;
            }
            if (!(mob.getPathfindingMalus(t) >= mob.getPathfindingMalus(chosen))) continue;
            chosen = t;
        }
        return chosen;
    }

    public Set<TravelersPathType> getPathTypeWithinMobBB(TravelersPathfindingContext context, int x, int y, int z) {
        EnumSet<TravelersPathType> enumset = EnumSet.noneOf(TravelersPathType.class);
        TravelersPathType pathtype = this.getPathType(context, x, y, z);
        boolean canPass = this.isCanPassDoors();
        boolean canOpen = this.isCanOpenDoors();
        if (pathtype == TravelersPathType.DOOR_WOOD_CLOSED && (canOpen || canPass)) {
            pathtype = TravelersPathType.WALKABLE_DOOR;
        }
        if (pathtype == TravelersPathType.DOOR_OPEN && !canPass) {
            pathtype = TravelersPathType.BLOCKED;
        }
        enumset.add(pathtype);
        return enumset;
    }

    @NotNull
    public TravelersPathType getPathType(@NotNull TravelersPathfindingContext context, int x, int y, int z) {
        return JSWalkNodeEvaluator.getPathTypeStatic(context, new BlockPos.MutableBlockPos(x, y, z));
    }

    public static TravelersPathType getPathTypeStatic(SmartAnimalBase base, BlockPos pos) {
        return JSWalkNodeEvaluator.getPathTypeStatic(new TravelersPathfindingContext((CollisionGetter)base.level(), (Mob)base), pos.mutable());
    }

    public static TravelersPathType getPathTypeStatic(TravelersPathfindingContext context, BlockPos.MutableBlockPos pos) {
        int k;
        int j;
        int i = pos.getX();
        TravelersPathType pathtype = context.getPathTypeFromState(i, j = pos.getY(), k = pos.getZ());
        if (pathtype == TravelersPathType.OPEN && j >= context.level().getMinBuildHeight() + 1) {
            return switch (context.getPathTypeFromState(i, j - 1, k)) {
                case TravelersPathType.OPEN, TravelersPathType.WATER, TravelersPathType.WALKABLE, TravelersPathType.LIGHT -> TravelersPathType.OPEN;
                case TravelersPathType.LAVA -> TravelersPathType.LAVA;
                case TravelersPathType.DAMAGE_FIRE -> TravelersPathType.DAMAGE_FIRE;
                case TravelersPathType.DAMAGE_OTHER -> TravelersPathType.DAMAGE_OTHER;
                case TravelersPathType.STICKY_HONEY -> TravelersPathType.STICKY_HONEY;
                case TravelersPathType.POWDER_SNOW -> TravelersPathType.DANGER_POWDER_SNOW;
                case TravelersPathType.DAMAGE_CAUTIOUS -> TravelersPathType.DAMAGE_CAUTIOUS;
                case TravelersPathType.TRAPDOOR -> TravelersPathType.DANGER_TRAPDOOR;
                default -> JSWalkNodeEvaluator.checkNeighbourBlocks(context, i, j, k, TravelersPathType.WALKABLE);
            };
        }
        return pathtype;
    }

    public static TravelersPathType checkNeighbourBlocks(TravelersPathfindingContext context, int x, int y, int z, TravelersPathType pathType) {
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    if (i == 0 && k == 0) continue;
                    TravelersPathType pathtype = context.getPathTypeFromState(x + i, y + j, z + k);
                    context.mutablePos.set(x + i, y + j, z + k);
                    if (pathtype == TravelersPathType.DAMAGE_OTHER) {
                        return TravelersPathType.DANGER_OTHER;
                    }
                    if (pathtype == TravelersPathType.DAMAGE_FIRE || pathtype == TravelersPathType.LAVA) {
                        return TravelersPathType.DANGER_FIRE;
                    }
                    if (pathtype == TravelersPathType.WATER) {
                        return TravelersPathType.WATER_BORDER;
                    }
                    if (pathtype != TravelersPathType.DAMAGE_CAUTIOUS) continue;
                    return TravelersPathType.DAMAGE_CAUTIOUS;
                }
            }
        }
        return pathType;
    }

    private boolean isClimbableAt(int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        BlockState s = this.context.level().getBlockState(pos);
        if (this.canClimbAnyBlock) {
            return s.getCollisionShape((BlockGetter)this.context.level(), pos).isEmpty();
        }
        if (!this.canClimb) {
            return false;
        }
        if (s.getBlock() instanceof LadderBlock || s.getBlock() instanceof VineBlock) {
            return true;
        }
        if (s.is(Blocks.SCAFFOLDING)) {
            return true;
        }
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            BlockState sid = this.context.level().getBlockState(pos.relative(dir));
            if (!(sid.getBlock() instanceof LadderBlock) && !(sid.getBlock() instanceof VineBlock) && !sid.is(Blocks.SCAFFOLDING)) continue;
            return true;
        }
        return false;
    }

    public boolean isTriesToAvoidLight() {
        return this.triesToAvoidLight;
    }

    public void setCanClimb(boolean canClimb) {
        this.canClimb = canClimb;
    }

    public void setCanClimbAnyBlock(boolean canClimbAnyBlock) {
        this.canClimbAnyBlock = canClimbAnyBlock;
    }
}

