/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.other;

import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.phys.Vec3;

public class JSLookControl
extends LookControl {
    protected final JSAnimalBase base;
    protected final float rot;

    public JSLookControl(JSAnimalBase mob) {
        super((Mob)mob);
        this.base = mob;
        this.rot = (float)this.base.getAnimal().getAnimalAttributes().getEntityBaseProperties().getTurnSmoothRate();
    }

    private static double getWantedY(Entity entity) {
        return entity instanceof LivingEntity ? entity.getEyeY() : (entity.getBoundingBox().minY + entity.getBoundingBox().maxY) / 2.0;
    }

    public void setLookAt(Vec3 lookVector) {
        this.setLookAt(lookVector.x, lookVector.y, lookVector.z);
    }

    public void setLookAt(Entity entity) {
        this.setLookAt(entity.getX(), JSLookControl.getWantedY(entity), entity.getZ());
    }

    public void setLookAt(Entity entity, float deltaYaw, float deltaPitch) {
        this.setLookAt(entity.getX(), JSLookControl.getWantedY(entity), entity.getZ(), deltaYaw, deltaPitch);
    }

    public void setLookAt(double x, double y, double z) {
        this.setLookAt(x, y, z, this.base.getHeadRotationSpeed(), this.mob.getMaxHeadXRot());
    }

    public void setLookAt(double x, double y, double z, float deltaYaw, float deltaPitch) {
        this.wantedX = x;
        this.wantedY = y;
        this.wantedZ = z;
        this.yMaxRotSpeed = deltaYaw;
        this.xMaxRotAngle = deltaPitch;
        this.lookAtCooldown = 10;
    }

    public void tick() {
        if (this.resetXRotOnTick()) {
            this.mob.setXRot(Mth.lerp((float)0.01f, (float)this.mob.getXRot(), (float)0.0f));
        }
        if (this.lookAtCooldown > 0) {
            --this.lookAtCooldown;
        } else {
            this.mob.yHeadRot = Mth.lerp((float)0.01f, (float)this.mob.yHeadRot, (float)this.mob.yBodyRot);
        }
    }

    protected float rotateTowards(float from, float to, float maxDelta, float maxRot) {
        float f = Mth.degreesDifference((float)from, (float)to);
        if (f > maxRot) {
            return maxRot;
        }
        if (f < maxRot) {
            return -maxRot;
        }
        float f1 = Mth.clamp((float)f, (float)(-maxDelta), (float)maxDelta);
        return from + f1;
    }

    protected float rotateTowards(float bodyRot, float from, float to, float maxDelta, float maxRot) {
        float diffBodyTo = Mth.degreesDifference((float)bodyRot, (float)to);
        if (diffBodyTo > maxRot) {
            to = bodyRot + maxRot;
        } else if (diffBodyTo < -maxRot) {
            to = bodyRot - maxRot;
        }
        float diffFromTo = Mth.degreesDifference((float)from, (float)to);
        float step = Mth.clamp((float)diffFromTo, (float)(-maxDelta), (float)maxDelta);
        return from + step;
    }
}

