/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.other;

import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAmphibiousBase;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import net.minecraft.util.Mth;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.pathingsystem.control.TravelersMoveControl;

public class JSSwimmingMoveControl
extends TravelersMoveControl {
    protected final float maxTurnX;
    protected final float maxTurnY;
    protected final float inWaterSpeedModifier;
    protected final float outsideWaterSpeedModifier;
    protected final boolean forceFloat;

    public JSSwimmingMoveControl(JSAnimalBase pMob, float maxTurnX, float maxTurnY, float inWaterSpeedModifier, float outsideWaterSpeedModifier, boolean applyGravity) {
        super((SmartAnimalBase)pMob, pMob.getAnimal());
        this.maxTurnX = maxTurnX;
        this.maxTurnY = maxTurnY;
        this.inWaterSpeedModifier = inWaterSpeedModifier;
        this.outsideWaterSpeedModifier = outsideWaterSpeedModifier;
        this.forceFloat = applyGravity;
    }

    protected static float getTurningSpeedFactor(float degreesToTurn) {
        return 1.0f - Mth.clamp((float)(degreesToTurn / 2.0f), (float)0.0f, (float)0.9f);
    }

    public void setWantedPosition(double pX, double pY, double pZ, double pSpeed) {
        super.setWantedPosition(pX, pY, pZ, pSpeed);
    }

    public void tick() {
        JSAnimalBase animal;
        SmartAnimalBase smartAnimalBase;
        if (!this.mob.isInWater() && this.mob instanceof JSAmphibiousBase) {
            super.tick();
            return;
        }
        if (this.forceFloat && this.mob.isInWater() && (smartAnimalBase = this.mob) instanceof JSAnimalBase && !(animal = (JSAnimalBase)smartAnimalBase).isNoGravity()) {
            this.mob.setDeltaMovement(this.mob.getDeltaMovement().add(0.0, 0.005, 0.0));
        }
        if (this.operation == TravelersMoveControl.Operation.MOVE_TO && !this.mob.getNavigationController().isDone()) {
            double dz;
            double dy;
            double dx = this.wantedX - this.mob.getX();
            double distSqr = dx * dx + (dy = this.wantedY - this.mob.getY()) * dy + (dz = this.wantedZ - this.mob.getZ()) * dz;
            if (distSqr < 2.5E-7) {
                this.mob.setZza(0.0f);
            } else {
                float targetYaw = (float)(Mth.atan2((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
                float smoothedYaw = Mth.rotLerp((float)this.TURN_SMOOTH_RATE, (float)this.mob.getYRot(), (float)targetYaw);
                this.mob.setYRot(smoothedYaw);
                this.mob.yBodyRot = smoothedYaw;
                this.mob.yHeadRot = smoothedYaw;
                this.mob.setSpeed(this.mob.getSpeed());
                if (this.mob.isInWater()) {
                    double horizDist = Math.sqrt(dx * dx + dz * dz);
                    if (Math.abs(dy) > 0.05 || horizDist > 1.0E-5) {
                        float targetPitch = -((float)(Mth.atan2((double)dy, (double)horizDist) * 57.29577951308232));
                        float clampedPitch = Mth.clamp((float)Mth.wrapDegrees((float)targetPitch), (float)(-this.MAX_TURN), (float)this.MAX_TURN);
                        float currentPitch = this.mob.getXRot();
                        float smoothedPitch = currentPitch + 0.15f * (clampedPitch - currentPitch);
                        this.mob.setXRot(smoothedPitch);
                    }
                }
            }
        } else {
            this.mob.setSpeed(0.0f);
            this.mob.setXxa(0.0f);
            this.mob.setYya(0.0f);
            this.mob.setZza(0.0f);
        }
    }
}

