/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.tasks;

import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.JSTaskBase;
import jp.jurassicsaga.server.base.animal.entity.util.JSTaskUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class JSOpenDoorTask
extends JSTaskBase {
    protected BlockPos doorPos = BlockPos.ZERO;
    protected boolean hasDoor;
    private boolean passed;
    private float doorOpenDirX;
    private float doorOpenDirZ;
    private int forgetTime;

    public JSOpenDoorTask(JSAnimalBase baseAnimal) {
        super(baseAnimal);
    }

    protected boolean isOpen() {
        if (!this.hasDoor) {
            return false;
        }
        BlockState blockstate = this.animal.level().getBlockState(this.doorPos);
        if (!(blockstate.getBlock() instanceof DoorBlock)) {
            this.hasDoor = false;
            return false;
        }
        return (Boolean)blockstate.getValue((Property)DoorBlock.OPEN);
    }

    protected void setOpen(boolean open) {
        BlockState blockstate;
        if (this.hasDoor && (blockstate = this.animal.level().getBlockState(this.doorPos)).getBlock() instanceof DoorBlock) {
            ((DoorBlock)blockstate.getBlock()).setOpen((Entity)this.animal, this.animal.level(), blockstate, this.doorPos, open);
        }
    }

    public boolean shouldRun() {
        if (this.animal.isDead()) {
            return false;
        }
        if (!JSTaskUtils.hasGroundPathNavigation(this.animal)) {
            return false;
        }
        if (!this.animal.horizontalCollision) {
            return false;
        }
        BlockPos animalPos = this.animal.blockPosition();
        AABB box = this.animal.getBoundingBox().inflate(2.0, 1.0, 2.0);
        BlockPos closestDoor = null;
        double closestDist = Double.MAX_VALUE;
        for (BlockPos pos : BlockPos.betweenClosed((int)((int)Math.floor(box.minX)), (int)((int)Math.floor(box.minY)), (int)((int)Math.floor(box.minZ)), (int)((int)Math.floor(box.maxX)), (int)((int)Math.floor(box.maxY)), (int)((int)Math.floor(box.maxZ)))) {
            double dist;
            if (!DoorBlock.isWoodenDoor((Level)this.animal.level(), (BlockPos)pos) || !((dist = animalPos.distSqr((Vec3i)pos)) < closestDist)) continue;
            closestDist = dist;
            closestDoor = pos.immutable();
        }
        if (closestDoor != null) {
            this.doorPos = closestDoor;
            this.hasDoor = true;
            return true;
        }
        return false;
    }

    public boolean canContinueRunning() {
        return !this.passed && this.forgetTime > 0;
    }

    public void onStart() {
        this.forgetTime = 20;
        this.setOpen(true);
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        float f1;
        --this.forgetTime;
        float f = (float)((double)this.doorPos.getX() + 0.5 - this.animal.getX());
        float f2 = this.doorOpenDirX * f + this.doorOpenDirZ * (f1 = (float)((double)this.doorPos.getZ() + 0.5 - this.animal.getZ()));
        if (f2 < 0.0f) {
            this.passed = true;
        }
    }

    public void onStop() {
        this.hasDoor = false;
        this.doorPos = BlockPos.ZERO;
        this.doorOpenDirX = 0.0f;
        this.doorOpenDirZ = 0.0f;
        this.setOpen(false);
    }
}

