/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat;

import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalGrowthStage;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.JSTaskBase;
import jp.jurassicsaga.server.base.entity.obj.other.IJSLeapingEntity;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import travelers.server.animal.entity.task.TaskPriority;

public class JSCombatLeapTask
extends JSTaskBase {
    private final float yDelta;
    private LivingEntity target;

    public JSCombatLeapTask(JSAnimalBase baseAnimal, float yDelta) {
        super(baseAnimal);
        this.yDelta = yDelta;
        this.setPriority(TaskPriority.LOW);
    }

    public TaskPriority getPriority() {
        if (this.animal.getTarget() == null) {
            return TaskPriority.NONE;
        }
        return TaskPriority.MEDIUM_HIGH;
    }

    public void onStart() {
        Vec3 vec3 = this.animal.getDeltaMovement();
        Vec3 flat = new Vec3(this.target.getX() - this.animal.getX(), 0.0, this.target.getZ() - this.animal.getZ());
        double horizontalDist = Math.sqrt(flat.lengthSqr());
        if (flat.lengthSqr() > 1.0E-7) {
            flat = flat.normalize().scale(1.5);
        }
        double scaledY = Math.max(0.2, horizontalDist * 0.075);
        this.animal.setDeltaMovement(flat.x, scaledY, flat.z);
        this.animal.addDeltaMovement(vec3.scale((double)0.2f));
        LivingEntity target = this.animal.getTarget();
        if (target != null) {
            this.animal.getLookControl().setLookAt((Entity)target);
            this.animal.getNavigationController().stop();
            this.animal.lookAt(EntityAnchorArgument.Anchor.EYES, target.position());
            ((IJSLeapingEntity)((Object)this.animal)).onLeap();
        }
    }

    public boolean shouldRun() {
        if (this.animal.isSleeping() || this.animal.isResting()) {
            return false;
        }
        if (this.animal.isDead()) {
            return false;
        }
        JSAnimalBase jSAnimalBase = this.animal;
        if (!(jSAnimalBase instanceof IJSLeapingEntity)) {
            return false;
        }
        IJSLeapingEntity leapingEntity = (IJSLeapingEntity)((Object)jSAnimalBase);
        if (this.animal.getModules().getGrowthStageModule().getGrowthStage() != AnimalGrowthStage.ADULT) {
            return false;
        }
        if (this.animal.hasControllingPassenger()) {
            return false;
        }
        this.target = this.animal.getTarget();
        if (this.target == null) {
            return false;
        }
        double d0 = this.animal.distanceToSqr(this.target.position());
        if (!(d0 < leapingEntity.maxDistance())) {
            return false;
        }
        return this.animal.onGround() && (double)this.random.nextFloat() > 0.7;
    }

    public boolean canContinueRunning() {
        if (this.animal.isDead()) {
            return false;
        }
        return !this.animal.onGround();
    }

    public void tick() {
    }

    public void onStop() {
    }
}

