/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat;

import java.util.concurrent.CompletableFuture;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.modules.JSHerdModule;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat.JSCombatFollowTask;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class JSHerdCombatFollowTask
extends JSCombatFollowTask {
    private boolean callOut = false;
    private boolean isUsingCallout = false;
    private int callingTicks = 0;
    private int maxCallingTicks = 0;

    public JSHerdCombatFollowTask(JSAnimalBase baseAnimal) {
        super(baseAnimal);
    }

    public JSHerdCombatFollowTask shouldCallout(boolean callOut, int callingTicks) {
        this.callOut = callOut;
        this.callingTicks = callingTicks;
        this.maxCallingTicks = callingTicks;
        return this;
    }

    @Override
    public boolean shouldRun() {
        if (this.animal.isDead()) {
            return false;
        }
        JSHerdModule herdModule = this.animal.getModules().getHerdModule();
        if (herdModule.isFollower() && herdModule.getHerdLeader().getTarget() != null) {
            return true;
        }
        return super.shouldRun();
    }

    @Override
    public void onStart() {
        LivingEntity target;
        JSHerdModule herdModule;
        if (this.animal.isResting() || this.animal.isSleeping()) {
            this.animal.getModules().getMetabolismModule().interrupt(20);
        }
        if ((herdModule = this.animal.getModules().getHerdModule()).isFollower()) {
            this.animal.setTarget(herdModule.getHerdLeader().getTarget());
        }
        if ((target = this.animal.getTarget()) == null || !target.isAlive()) {
            this.animal.setTarget(null);
            this.stop();
            this.onStop();
            return;
        }
        if (!this.callOut || herdModule.getHerdLeader() != null && this.random.nextDouble() > 0.875 && herdModule.getFollowers().isEmpty()) {
            this.isUsingCallout = false;
            super.onStart();
        } else {
            this.isUsingCallout = true;
            this.recomputePathTicks = 0;
        }
    }

    @Override
    public void tick() {
        if (this.animal.isResting() || this.animal.isSleeping()) {
            this.animal.getModules().getMetabolismModule().interrupt(20);
        }
        if (this.isUsingCallout && this.callingTicks > 0) {
            --this.callingTicks;
            this.animal.stopInPlace();
            if (this.random.nextDouble() < (double)0.05f) {
                this.animal.callSounds();
            }
            --this.callingTicks;
            return;
        }
        if (this.animal.getTarget() == null) {
            this.stop();
            return;
        }
        if (this.shouldStalk && this.hasLos(this.animal.getTarget(), (PathfinderMob)this.animal) && !this.triedStalking) {
            this.triedStalking = true;
            this.animal.setStalking(true);
        } else {
            if (this.triedStalking) {
                this.animal.setStalking(false);
            }
            this.animal.setAggressive(true);
        }
        if (this.animal.getNavigationController().isDone() || this.recomputePathTicks == 0) {
            CompletableFuture moveTo = this.animal.getNavigationController().moveTo((Entity)this.animal.getTarget(), 1.0);
            if (moveTo != null) {
                moveTo.thenAccept(travelersPath -> {
                    if (travelersPath == null) {
                        this.recomputePathTicks += 10;
                    } else {
                        travelersPath.advance();
                    }
                });
            } else {
                this.recomputePathTicks += 10;
            }
            this.recomputePathTicks += this.random.nextInt(5, 15);
            if (this.attackCooldown == 0) {
                if (this.animal.getTarget().distanceToSqr((Entity)this.animal) <= (double)this.animal.getAttackReach()) {
                    this.animal.attack(this.animal.getTarget());
                    this.recomputePathTicks += 5;
                    this.attackResetTime = this.attackCooldown;
                }
            } else {
                --this.attackCooldown;
            }
        } else if (this.recomputePathTicks > 0) {
            --this.recomputePathTicks;
        }
    }

    private boolean hasLos(LivingEntity mob, PathfinderMob entity) {
        Vec3 dirToEntity;
        if (entity.level() != mob.level()) {
            return false;
        }
        Vec3 mobEyes = new Vec3(mob.getX(), mob.getEyeY(), mob.getZ());
        Vec3 entityEyes = new Vec3(entity.getX(), entity.getEyeY(), entity.getZ());
        if (entityEyes.distanceTo(mobEyes) > 128.0) {
            return false;
        }
        Vec3 lookVec = mob.getLookAngle().normalize();
        double angle = Math.acos(lookVec.dot(dirToEntity = entityEyes.subtract(mobEyes).normalize())) * 57.29577951308232;
        if (angle > 30.0) {
            return false;
        }
        return mob.level().clip(new ClipContext(mobEyes, entityEyes, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)mob)).getType() == HitResult.Type.MISS;
    }

    @Override
    public void onStop() {
        super.onStop();
        this.callingTicks = this.maxCallingTicks;
    }
}

