/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat;

import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat.JSCombatTaskBase;
import net.minecraft.world.entity.LivingEntity;
import travelers.server.animal.entity.task.TaskPriority;

public class JSRevengeOrRunTask
extends JSCombatTaskBase {
    private LivingEntity target;

    public JSRevengeOrRunTask(JSAnimalBase baseAnimal) {
        super(baseAnimal);
    }

    public boolean shouldRun() {
        if (this.animal.isDead()) {
            return false;
        }
        this.target = this.animal.getLastHurtByMob();
        return this.target != null && this.target.isAlive();
    }

    public boolean canContinueRunning() {
        if (this.animal.isDead()) {
            return false;
        }
        return this.target != null && this.target.isAlive();
    }

    public TaskPriority getPriority() {
        return TaskPriority.HIGH;
    }

    public void onStart() {
        if (this.target == null) {
            return;
        }
        double mySize = this.animal.getBbWidth() + this.animal.getBbHeight();
        double enemySize = this.target.getBbWidth() + this.target.getBbHeight();
        if (enemySize > mySize) {
            this.animal.setFleeTarget(this.target);
        } else {
            this.animal.setTarget(this.target);
        }
    }

    public void tick() {
        if (this.target == null) {
            return;
        }
    }

    public void onStop() {
        this.target = null;
        this.animal.setTarget(null);
        this.animal.setFleeTarget(null);
    }
}

