/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat;

import java.util.List;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat.JSCombatTaskBase;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;

public class JSTargetTask
extends JSCombatTaskBase {
    protected final boolean mustSee;
    protected LivingEntity target;

    public JSTargetTask(JSAnimalBase baseAnimal, boolean mustSee) {
        super(baseAnimal);
        this.mustSee = mustSee;
    }

    protected double getFollowDistance() {
        return this.animal.getAttributeValue((Holder<Attribute>)Attributes.FOLLOW_RANGE);
    }

    public boolean shouldRun() {
        if (this.animal.isDead() || this.animal.isSleeping() || this.animal.isResting()) {
            return false;
        }
        if (this.animal.getTarget() != null) {
            return false;
        }
        this.findTarget();
        return this.target != null;
    }

    public void onStart() {
        this.animal.setTarget(this.target);
    }

    public void tick() {
    }

    public void onStop() {
        this.animal.setTarget(null);
        this.target = null;
    }

    public boolean canContinueRunning() {
        Player player;
        if (this.animal.isDead()) {
            return false;
        }
        LivingEntity livingentity = this.animal.getTarget();
        if (livingentity == null) {
            livingentity = this.target;
        }
        if (livingentity == null) {
            return false;
        }
        if (!this.animal.canAttack(livingentity)) {
            return false;
        }
        if (livingentity instanceof Player && (player = (Player)livingentity).isCreative()) {
            return false;
        }
        double d0 = this.getFollowDistance();
        if (this.animal.distanceToSqr((Entity)livingentity) > d0 * d0) {
            return false;
        }
        this.animal.setTarget(livingentity);
        return true;
    }

    protected AABB getTargetSearchArea(double targetDistance) {
        return this.animal.getBoundingBox().inflate(targetDistance, targetDistance, targetDistance);
    }

    protected void findTarget() {
        AABB tracking = this.getTargetSearchArea(this.animal.getTrackingRange());
        List entities = this.animal.level().getEntitiesOfClass(LivingEntity.class, tracking, mob -> {
            if (mob.is((Entity)this.animal)) {
                return false;
            }
            if (this.mustSee && !this.animal.hasLineOfSight((Entity)mob)) {
                return false;
            }
            return this.animal.getModules().getMetabolismModule().canTarget((LivingEntity)mob);
        });
        this.target = this.animal.level().getNearestEntity(entities, TargetingConditions.DEFAULT.range(this.animal.getTrackingRange()), (LivingEntity)this.animal, this.animal.getX(), this.animal.getEyeY(), this.animal.getZ());
    }
}

