/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.tasks.metabolism;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.JSTaskBase;
import jp.jurassicsaga.server.base.animal.entity.util.JSTaskUtils;
import jp.jurassicsaga.server.base.entity.obj.other.IJSEdibleEntity;
import jp.jurassicsaga.server.base.entity.obj.physics.HaybaleEntity;
import jp.jurassicsaga.server.base.entity.obj.physics.MeatEntity;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import travelers.server.animal.entity.task.TaskGoal;
import travelers.server.animal.entity.task.TaskPriority;

public class JSFindFoodTask
extends JSTaskBase {
    protected volatile Entity targetEntity;
    private volatile boolean shouldMoveToLastKnown;
    protected boolean setTargetTypes = true;
    protected boolean targetMeatCubes;
    protected boolean targetHayCubes;
    private final ThreadLocalRandom rng = ThreadLocalRandom.current();
    private final AtomicInteger pendingPathChecks = new AtomicInteger(0);
    private final int searchIntervalTicks = 20;
    private final int maxCandidatesToConsider = 16;
    private final int maxPathRequestsPerSearch = 3;
    private final int maxConcurrentPathChecks = 4;
    private final int candidateCacheExpiry = 40;
    private final List<Entity> candidateCache = new ArrayList<Entity>(32);
    private int candidateCacheTick = -9999;
    private int ticks = 0;

    public JSFindFoodTask(JSAnimalBase baseAnimal) {
        super(baseAnimal);
        this.getGoals().add(TaskGoal.METABOLISM);
        this.getGoals().add(TaskGoal.MOVEMENT);
    }

    public TaskPriority getPriority() {
        if (this.animal.isDead()) {
            return TaskPriority.NONE;
        }
        double mobHunger = this.animal.getModules().getMetabolismModule().hungerPercentage();
        if (mobHunger > 0.8) {
            return TaskPriority.LOW;
        }
        if (mobHunger > 0.6) {
            return TaskPriority.MEDIUM;
        }
        if (mobHunger > 0.4) {
            return TaskPriority.HIGH;
        }
        if (mobHunger > 0.2) {
            return TaskPriority.VERY_HIGH;
        }
        return TaskPriority.DIRECT;
    }

    public boolean shouldRun() {
        if (this.animal.isDead() || this.animal.getModules().getMetabolismModule().getDiet() == null) {
            return false;
        }
        if (!this.animal.getAnimal().getAnimalAttributes().getMetabolismProperties().isHungerEnabled()) {
            return false;
        }
        if (!this.animal.getModules().getMetabolismModule().isHungry()) {
            return false;
        }
        if (this.setTargetTypes) {
            this.targetMeatCubes = this.animal.getModules().getMetabolismModule().getDiet().isCanEatMeatCube();
            this.targetHayCubes = this.animal.getModules().getMetabolismModule().getDiet().isCanEatHaybale();
            this.setTargetTypes = false;
        }
        if (this.targetEntity != null && !this.targetEntity.isAlive()) {
            this.targetEntity = null;
        }
        if (this.targetEntity == null && this.ticks - this.candidateCacheTick >= 20) {
            this.getTarget(64.0f, null);
            this.candidateCacheTick = this.ticks;
        }
        ++this.ticks;
        return this.targetEntity != null || this.shouldMoveToLastKnown;
    }

    protected boolean extraCheck(Entity e) {
        return true;
    }

    public boolean canInterrupt() {
        return this.targetEntity == null;
    }

    public void onStart() {
        CompletableFuture future;
        if (!this.shouldMoveToLastKnown && this.targetEntity != null && !this.animal.getNavigationController().isLookingForPath() && (future = this.animal.getNavigationController().createPath(this.targetEntity.blockPosition(), 0)) != null) {
            this.pendingPathChecks.incrementAndGet();
            future.thenAccept(jsPath -> {
                this.pendingPathChecks.decrementAndGet();
                if (jsPath != null) {
                    this.animal.getNavigationController().moveTo(jsPath, 1.0);
                } else {
                    this.targetEntity = null;
                }
            });
        }
    }

    public boolean requiresUpdateEveryTick() {
        return this.targetEntity != null || this.shouldMoveToLastKnown;
    }

    public void tick() {
        CompletableFuture future;
        if (this.checkCooldown > 0) {
            --this.checkCooldown;
        }
        if (this.shouldMoveToLastKnown) {
            this.shouldMoveToLastKnown = false;
        }
        boolean extraCheck = true;
        if (this.isCloseToTarget() && extraCheck) {
            this.animal.getNavigationController().stop();
            if (this.animal.curEatTicks == 0) {
                this.animal.curEatTicks = 20;
            }
            if (this.targetEntity != null) {
                this.animal.lookAt(EntityAnchorArgument.Anchor.EYES, this.targetEntity.position());
            }
            if (this.animal.curEatTicks <= 5) {
                Object edible;
                Entity entity = this.targetEntity;
                if (entity instanceof IJSEdibleEntity) {
                    edible = (IJSEdibleEntity)entity;
                    this.animal.getModules().getMetabolismModule().eatEntity((IJSEdibleEntity)edible);
                }
                if ((entity = this.targetEntity) instanceof JSAnimalBase) {
                    edible = (JSAnimalBase)entity;
                    if (this.animal.getModules().getMetabolismModule().canEatCorpse((JSAnimalBase)((Object)edible))) {
                        this.animal.getModules().getMetabolismModule().eatCorpse((JSAnimalBase)((Object)edible));
                    }
                }
                if ((entity = this.targetEntity) instanceof ItemEntity) {
                    ItemEntity e = (ItemEntity)entity;
                    if (this.animal.getContainer().canAddItem(e.getItem())) {
                        this.animal.getContainer().addItem(e.getItem());
                        e.discard();
                    }
                }
                this.targetEntity = null;
            }
            return;
        }
        if (this.targetEntity != null && this.animal.getNavigationController().isDone() && this.checkCooldown <= 0 && this.pendingPathChecks.get() < 4 && (future = this.animal.getNavigationController().createPath(this.targetEntity.blockPosition(), 0)) != null) {
            this.pendingPathChecks.incrementAndGet();
            future.thenAccept(jsPath -> {
                this.pendingPathChecks.decrementAndGet();
                if (jsPath != null) {
                    this.animal.getNavigationController().moveTo(jsPath, 1.0);
                } else {
                    this.targetEntity = null;
                }
            });
            this.checkCooldown = 40;
        }
    }

    public void cleanUp() {
        super.cleanUp();
        this.shouldMoveToLastKnown = false;
        this.pendingPathChecks.set(0);
        this.candidateCache.clear();
    }

    public boolean isCloseToTarget() {
        return this.targetEntity != null && JSTaskUtils.isCloseEnough(this.animal, this.targetEntity.blockPosition().getCenter(), 2.0f);
    }

    public void getTarget(float range, Vec3 pos) {
        if (range <= 1.0f) {
            range = 2.0f;
        }
        Level level = this.animal.level();
        if (this.ticks - this.candidateCacheTick < 40 && !this.candidateCache.isEmpty()) {
            if (this.rng.nextDouble() < 0.15) {
                Collections.shuffle(this.candidateCache, this.rng);
            }
        } else {
            this.candidateCache.clear();
            AABB inflatedHitbox = this.animal.getBoundingBox().inflate((double)range, (double)range / 2.0, (double)range);
            if (pos != null) {
                inflatedHitbox = inflatedHitbox.move(pos);
            }
            if (this.targetMeatCubes) {
                this.candidateCache.addAll(level.getEntitiesOfClass(JSAnimalBase.class, inflatedHitbox, e -> e.isDead() && !this.animal.is((Entity)e)));
                this.candidateCache.addAll(level.getEntitiesOfClass(MeatEntity.class, inflatedHitbox, e -> e.isAlive() && this.extraCheck((Entity)e)));
            }
            if (this.targetHayCubes) {
                this.candidateCache.addAll(level.getEntitiesOfClass(HaybaleEntity.class, inflatedHitbox, e -> e.isAlive() && this.extraCheck((Entity)e)));
            }
            this.candidateCache.addAll(level.getEntitiesOfClass(ItemEntity.class, inflatedHitbox, e -> this.animal.getModules().getMetabolismModule().getDiet().canEatItem(e.getItem()) && this.extraCheck((Entity)e)));
            this.candidateCacheTick = this.ticks;
        }
        if (this.candidateCache.isEmpty()) {
            return;
        }
        int validCount = 0;
        Iterator<Entity> it = this.candidateCache.iterator();
        while (it.hasNext()) {
            Entity e2 = it.next();
            if (e2 == null || !e2.isAlive()) {
                it.remove();
                continue;
            }
            if (!this.cheapCanSee(level, e2)) {
                it.remove();
                continue;
            }
            if (++validCount < 16) continue;
            break;
        }
        if (this.candidateCache.isEmpty()) {
            this.shouldMoveToLastKnown = true;
            return;
        }
        this.candidateCache.sort((o1, o2) -> {
            double d1 = this.animal.position().distanceToSqr(o1.position());
            double d2 = this.animal.position().distanceToSqr(o2.position());
            return Double.compare(d1 *= 1.0 + this.rng.nextDouble() * 0.25, d2 *= 1.0 + this.rng.nextDouble() * 0.25);
        });
        int pathRequests = 0;
        for (Entity targ : new ArrayList<Entity>(this.candidateCache)) {
            CompletableFuture future;
            if (targ == null) continue;
            if (this.targetEntity != null || pathRequests >= 3 || this.pendingPathChecks.get() >= 4) break;
            double distSqr = this.animal.position().distanceToSqr(targ.position());
            if (distSqr > (double)(range * range) * 1.5 || (future = this.animal.getNavigationController().createPath(targ.blockPosition(), 0)) == null) continue;
            this.pendingPathChecks.incrementAndGet();
            ++pathRequests;
            Entity finalTarg = targ;
            future.thenAccept(jsPath -> {
                try {
                    if (jsPath != null && finalTarg.isAlive() && this.cheapCanSee(this.animal.level(), finalTarg)) {
                        if (this.targetEntity == null) {
                            this.targetEntity = finalTarg;
                        } else {
                            double cur = this.animal.position().distanceToSqr(this.targetEntity.position());
                            double newd = this.animal.position().distanceToSqr(finalTarg.position());
                            if (newd + 1.0E-6 < cur && this.rng.nextDouble() < 0.65) {
                                this.targetEntity = finalTarg;
                            }
                        }
                    }
                }
                finally {
                    this.pendingPathChecks.decrementAndGet();
                }
            });
        }
        if (pathRequests == 0 && !this.candidateCache.isEmpty()) {
            this.shouldMoveToLastKnown = true;
        }
    }

    private boolean cheapCanSee(Level level, Entity e) {
        Vec3 to;
        if (e == null) {
            return false;
        }
        Vec3 from = this.animal.getEyePosition();
        BlockHitResult result = level.clip(new ClipContext(from, to = e.getEyePosition(), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.animal));
        return result.getType() != HitResult.Type.BLOCK;
    }

    public void onStop() {
        this.targetEntity = null;
    }
}

