/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.tasks.metabolism;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.JSTaskBase;
import jp.jurassicsaga.server.base.animal.entity.util.JSTaskUtils;
import jp.jurassicsaga.server.base.generic.util.JSUtils;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import travelers.server.animal.entity.task.TaskGoal;
import travelers.server.animal.entity.task.TaskPriority;

public class JSFindWaterTask
extends JSTaskBase {
    protected Vec3 targetPosition;
    protected Vec3 targetWaterPosition;
    protected int drinkingTicks = 0;
    private final ThreadLocalRandom rng = ThreadLocalRandom.current();
    private final AtomicInteger pendingPathChecks = new AtomicInteger(0);
    private final int searchIntervalTicks = 20;
    private final int candidateCacheExpiry = 40;
    private final int maxCandidatesToCollect = 24;
    private final int maxPathRequestsPerSearch = 3;
    private final int maxConcurrentPathChecks = 4;
    private final int scanStep = 1;
    private final List<ShoreCandidate> candidateCache = new ArrayList<ShoreCandidate>(32);
    private int ticks = 0;
    private int lastSearchTick = -9999;

    public JSFindWaterTask(JSAnimalBase baseAnimal) {
        super(baseAnimal);
        this.getGoals().add(TaskGoal.METABOLISM);
        this.getGoals().add(TaskGoal.MOVEMENT);
    }

    public TaskPriority getPriority() {
        if (this.animal.isDead()) {
            return TaskPriority.NONE;
        }
        double mobThirst = this.animal.getModules().getMetabolismModule().thirstPercentage();
        if (mobThirst > 0.8) {
            return TaskPriority.LOW;
        }
        if (mobThirst > 0.6) {
            return TaskPriority.MEDIUM;
        }
        if (mobThirst > 0.4) {
            return TaskPriority.HIGH;
        }
        if (mobThirst > 0.2) {
            return TaskPriority.VERY_HIGH;
        }
        return TaskPriority.DIRECT;
    }

    public boolean shouldRun() {
        if (this.checkCooldown > 0) {
            --this.checkCooldown;
            return false;
        }
        if (this.animal.isDead()) {
            return false;
        }
        if (this.animal.getModules().getMetabolismModule().getDiet() == null) {
            return false;
        }
        if (!this.animal.getAnimal().getAnimalAttributes().getMetabolismProperties().isThirstEnabled()) {
            return false;
        }
        if (!this.animal.getModules().getMetabolismModule().isThirsty()) {
            return false;
        }
        if (this.ticks - this.lastSearchTick >= 20) {
            this.collectShoreCandidates(this.animal.blockPosition(), 32);
            this.lastSearchTick = this.ticks;
        }
        if (this.targetPosition != null && this.targetWaterPosition != null) {
            return true;
        }
        if (!this.candidateCache.isEmpty()) {
            this.requestPathsForCandidates();
        }
        ++this.ticks;
        return this.targetPosition != null && this.targetWaterPosition != null;
    }

    public boolean canContinueRunning() {
        if (this.animal.isDead()) {
            return false;
        }
        if (this.animal.getModules().getMetabolismModule().getDiet() == null) {
            return false;
        }
        if (!this.animal.getModules().getMetabolismModule().isThirstEnabled()) {
            return false;
        }
        if (!(this.animal.getModules().getMetabolismModule().thirstPercentage() < (double)0.8f)) {
            return false;
        }
        return !this.animal.getNavigationController().isDone() || this.targetPosition != null && this.targetWaterPosition != null;
    }

    public boolean canInterrupt() {
        return this.targetPosition == null;
    }

    public void onStart() {
        this.animal.getNavigationController().stop();
        if (this.targetPosition == null) {
            return;
        }
        CompletableFuture future = this.animal.getNavigationController().createPath(new BlockPos((int)this.targetPosition.x, (int)this.targetPosition.y, (int)this.targetPosition.z), 1);
        if (future != null) {
            this.pendingPathChecks.incrementAndGet();
            future.thenAccept(jsPath -> {
                this.pendingPathChecks.decrementAndGet();
                if (jsPath != null) {
                    this.animal.getNavigationController().moveTo(jsPath, (double)1.1f);
                } else {
                    this.targetPosition = null;
                    this.targetWaterPosition = null;
                }
            });
        }
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        CompletableFuture future;
        if (this.checkCooldown > 0) {
            --this.checkCooldown;
        }
        ++this.drinkingTicks;
        if (this.drinkingTicks > 200 && this.animal.getNavigationController().isDone() && this.animal.getNavigationController().isStuck()) {
            this.stop();
            this.checkCooldown = 5;
        }
        if (this.reachedWater()) {
            this.animal.getNavigationController().stop();
            if (this.targetWaterPosition != null) {
                this.animal.lookAt(EntityAnchorArgument.Anchor.FEET, this.targetWaterPosition);
            }
            float repeatTimes = (float)(this.animal.getModules().getMetabolismModule().getMaxThirst() - this.animal.getModules().getMetabolismModule().getThirst()) / JSUtils.toTickMinutes(5.0f);
            int i = 0;
            while ((float)i < repeatTimes) {
                this.animal.getModules().getMetabolismModule().addThirst((int)JSUtils.toTickMinutes(5.0f));
                ++i;
            }
            this.targetPosition = null;
            this.targetWaterPosition = null;
            this.drinkingTicks = 0;
            this.checkCooldown = 10;
            return;
        }
        if (this.targetPosition != null && this.animal.getNavigationController().isDone() && this.checkCooldown <= 0 && this.pendingPathChecks.get() < 4 && (future = this.animal.getNavigationController().createPath(new BlockPos((int)this.targetPosition.x, (int)this.targetPosition.y, (int)this.targetPosition.z), 0)) != null) {
            this.pendingPathChecks.incrementAndGet();
            future.thenAccept(jsPath -> {
                this.pendingPathChecks.decrementAndGet();
                if (jsPath != null) {
                    this.animal.getNavigationController().moveTo(jsPath, (double)1.1f);
                } else {
                    this.targetPosition = null;
                    this.targetWaterPosition = null;
                }
            });
            this.checkCooldown = 40;
        }
        if (this.targetPosition == null && !this.candidateCache.isEmpty() && this.ticks % 20 == 0) {
            this.requestPathsForCandidates();
        }
        ++this.ticks;
    }

    public void onStop() {
    }

    public void cleanUp() {
        this.targetPosition = null;
        this.targetWaterPosition = null;
        this.drinkingTicks = 0;
        this.checkCooldown = 0;
        this.candidateCache.clear();
        this.pendingPathChecks.set(0);
    }

    private boolean reachedWater() {
        return this.targetPosition != null && JSTaskUtils.isCloseEnough(this.animal, this.targetPosition, 3.0f) || this.animal.isInWater();
    }

    private void collectShoreCandidates(BlockPos center, int range) {
        this.candidateCache.clear();
        Level level = this.animal.level();
        BlockPos start = center.offset(-range, -range, -range);
        BlockPos end = center.offset(range, range, range);
        for (int x = start.getX(); x <= end.getX(); ++x) {
            for (int z = start.getZ(); z <= end.getZ(); ++z) {
                for (int y = start.getY(); y <= end.getY() && this.candidateCache.size() < 24; ++y) {
                    BlockPos pos = new BlockPos(x, y, z);
                    if (!level.getFluidState(pos).isSourceOfType((Fluid)Fluids.WATER)) continue;
                    boolean found = false;
                    BlockPos landPos = null;
                    for (int dx = -1; dx <= 1 && !found; ++dx) {
                        for (int dz = -1; dz <= 1 && !found; ++dz) {
                            BlockPos candidate = pos.offset(dx, 0, dz);
                            BlockState below = level.getBlockState(candidate.below());
                            BlockState at = level.getBlockState(candidate);
                            BlockState above = level.getBlockState(candidate.above());
                            if (at.isAir() || !above.isAir() || !below.isSolidRender((BlockGetter)level, candidate.below())) continue;
                            landPos = candidate.above();
                            found = true;
                        }
                    }
                    if (!found) continue;
                    Vec3 landCenter = landPos.getCenter();
                    double distSq = landCenter.distanceToSqr(this.animal.position());
                    this.candidateCache.add(new ShoreCandidate(landPos, pos, distSq));
                }
            }
        }
        Collections.sort(this.candidateCache, (a, b) -> {
            double da = a.distSq * (1.0 + this.rng.nextDouble() * 0.25);
            double db = b.distSq * (1.0 + this.rng.nextDouble() * 0.25);
            return Double.compare(da, db);
        });
        if (this.candidateCache.size() > 24) {
            this.candidateCache.subList(24, this.candidateCache.size()).clear();
        }
    }

    private void requestPathsForCandidates() {
        if (this.candidateCache.isEmpty()) {
            return;
        }
        int requests = 0;
        for (ShoreCandidate c : this.candidateCache) {
            CompletableFuture future;
            if (requests >= 3 || this.pendingPathChecks.get() >= 4 || this.targetPosition != null) break;
            if (c.distSq > 1536.0 || (future = this.animal.getNavigationController().createPath(c.landPos, 0)) == null) continue;
            this.pendingPathChecks.incrementAndGet();
            ++requests;
            ShoreCandidate fc = c;
            future.thenAccept(jsPath -> {
                try {
                    if (jsPath != null) {
                        if (this.targetPosition == null) {
                            this.targetPosition = fc.landPos.getCenter();
                            this.targetWaterPosition = fc.waterPos.getCenter();
                            if (this.animal.getNavigationController().isDone()) {
                                this.animal.getNavigationController().moveTo(jsPath, (double)1.1f);
                            }
                        } else {
                            double cur = this.animal.position().distanceToSqr(this.targetPosition);
                            if (fc.distSq + 1.0E-6 < cur && this.rng.nextDouble() < 0.6) {
                                this.targetPosition = fc.landPos.getCenter();
                                this.targetWaterPosition = fc.waterPos.getCenter();
                            }
                        }
                    }
                }
                finally {
                    this.pendingPathChecks.decrementAndGet();
                }
            });
        }
    }

    private static class ShoreCandidate {
        final BlockPos landPos;
        final BlockPos waterPos;
        final double distSq;

        ShoreCandidate(BlockPos landPos, BlockPos waterPos, double distSq) {
            this.landPos = landPos;
            this.waterPos = waterPos;
            this.distSq = distSq;
        }
    }
}

