/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.tasks.misc;

import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.JSTaskBase;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.obj.animation.TravelersSoundAnimationDefinition;
import travelers.server.packet.obj.TravelersShakeCamera;
import travelers.util.helper.TravelersPacketDistributor;

public class JSRoarTask
extends JSTaskBase {
    private int roarLength = 0;
    private final TravelersSoundAnimationDefinition[] defs;
    private TravelersSoundAnimationDefinition roar;
    private int roarTickOffset = 0;
    private int lastIndex = -1;
    private int roarCooldown = 0;
    private boolean hasEnteredShake;

    public JSRoarTask(JSAnimalBase baseAnimal, TravelersSoundAnimationDefinition ... definitions) {
        super(baseAnimal);
        this.defs = definitions;
    }

    public boolean shouldRun() {
        if (this.roarCooldown > 0) {
            --this.roarCooldown;
            return false;
        }
        if (this.animal.isDead() || this.animal.isInWaterOrBubble() || this.animal.isSleeping() || this.animal.getTarget() != null || this.animal.isSleeping() || this.animal.isResting()) {
            return false;
        }
        if (this.animal.getModules().getHerdModule().isFollower()) {
            return this.animal.isWithinRestriction() && this.animal.getNavigationController().isDone();
        }
        return this.animal.getNavigationController().isDone() && this.random.nextDouble() < (double)0.04f;
    }

    public boolean canContinueRunning() {
        if (this.animal.isDead() || this.animal.isSleeping() || this.animal.isInWaterOrBubble() || this.animal.isResting()) {
            return false;
        }
        return this.roarLength != 0;
    }

    public boolean requiresUpdateEveryTick() {
        if (this.animal.isDead() || this.animal.isSleeping()) {
            return false;
        }
        return this.roarLength > 0;
    }

    public void onStart() {
        int index;
        while ((index = this.random.nextInt(this.defs.length)) == this.lastIndex && this.defs.length > 1) {
        }
        this.lastIndex = index;
        TravelersSoundAnimationDefinition soundAnimDef = this.defs[index];
        this.roarTickOffset = soundAnimDef.length() - soundAnimDef.offset();
        this.roarLength = soundAnimDef.length();
        this.roar = soundAnimDef;
        if (this.roarTickOffset == this.roarLength) {
            this.animal.playSound(soundAnimDef.event(), 2.0f, 1.0f);
        }
        this.tick();
    }

    public void tick() {
        --this.roarLength;
        if (this.roarTickOffset == this.roarLength) {
            this.animal.level().playSound(null, this.animal.blockPosition(), this.roar.event(), SoundSource.HOSTILE, 2.0f, 1.0f);
        }
        if (this.animal.canShake() && !this.hasEnteredShake && this.roar.length() - this.roar.secondaryOffset() > this.roarLength) {
            TravelersPacketDistributor.sendToPlayersTrackingEntity((SmartAnimalBase)this.animal, (CustomPacketPayload)new TravelersShakeCamera(false, this.animal.shakeAmount() * 0.7f, this.roarLength, this.animal.shakeDistance() * 0.7f, this.animal.position().toVector3f()));
            this.hasEnteredShake = true;
        }
        this.animal.freezeAnimator();
        this.animal.stopInPlace();
        this.animal.getNavigationController().setLookingForPath(true);
        if (this.roar != null && this.roarLength > 0) {
            this.roar.def().sendForEntity((Entity)this.animal);
        }
    }

    public void onStop() {
        this.roarCooldown = 26;
        this.roar = null;
        this.roarLength = 0;
        this.hasEnteredShake = false;
        this.animal.getNavigationController().setLookingForPath(false);
    }
}

