/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.tasks.navigation;

import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.JSTaskBase;
import jp.jurassicsaga.server.base.animal.entity.util.JSDefaultRandomPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import travelers.server.animal.entity.task.TaskGoal;
import travelers.server.animal.entity.task.TaskPriority;

public class JSFleeTask
extends JSTaskBase {
    private final int fleeDistance;
    private int ticksToNextPathCalc;
    private LivingEntity currentFleeTarget = null;

    public JSFleeTask(JSAnimalBase baseAnimal, int fleeDistance) {
        super(baseAnimal);
        this.fleeDistance = fleeDistance;
        this.getGoals().add(TaskGoal.MOVEMENT);
        this.setPriority(TaskPriority.VERY_HIGH);
    }

    public boolean shouldRun() {
        if (this.animal.isDead()) {
            return false;
        }
        if (this.animal.getFleeTarget() == null) {
            AABB bb = this.animal.getBoundingBox().inflate((double)this.fleeDistance, 20.0, (double)this.fleeDistance);
            List list = this.level.getEntitiesOfClass(LivingEntity.class, bb, a -> {
                if (a instanceof JSAnimalBase) {
                    JSAnimalBase b = (JSAnimalBase)((Object)a);
                    return !b.isDead() && a.isAlive() && !a.is((Entity)this.animal) && this.animal.getAnimal().getAnimalAttributes().getSocialGroupProperties().isScaredOf((LivingEntity)a);
                }
                return a.isAlive() && !a.is((Entity)this.animal) && this.animal.getAnimal().getAnimalAttributes().getSocialGroupProperties().isScaredOf((LivingEntity)a);
            });
            list.stream().min(Comparator.comparingDouble(e -> e.distanceTo((Entity)this.animal))).ifPresent(this.animal::setFleeTarget);
        }
        return this.animal.getFleeTarget() != null;
    }

    public void onStart() {
        this.animal.getNavigationController().stop();
        this.currentFleeTarget = this.animal.getFleeTarget();
        this.animal.getModules().getMetabolismModule().interrupt(20);
        this.animal.setIsPanicking(true);
    }

    public boolean canContinueRunning() {
        if (this.animal.isDead()) {
            return false;
        }
        return this.currentFleeTarget != null;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        if (this.currentFleeTarget == null) {
            this.stop();
            return;
        }
        if (this.animal.distanceTo((Entity)this.currentFleeTarget) > (float)this.fleeDistance) {
            this.stop();
            return;
        }
        if (this.animal.getNavigationController().isDone() || this.ticksToNextPathCalc <= 0) {
            this.ticksToNextPathCalc = 20 + this.random.nextInt(20);
            Vec3 pos = JSDefaultRandomPos.getPosAway(this.animal, this.fleeDistance + this.fleeDistance, this.fleeDistance, this.currentFleeTarget.position());
            if (pos == null) {
                this.ticksToNextPathCalc = 0;
                return;
            }
            CompletableFuture path = this.animal.getNavigationController().moveTo(pos.x, pos.y, pos.z, 1.0);
            if (path != null) {
                path.thenAccept(jsPath -> {
                    if (jsPath == null) {
                        this.ticksToNextPathCalc += 15;
                    }
                });
            } else {
                this.ticksToNextPathCalc += 15;
            }
        }
        if (this.ticksToNextPathCalc > 0) {
            --this.ticksToNextPathCalc;
        }
    }

    public void onStop() {
        this.currentFleeTarget = null;
        this.animal.setFleeTarget(null);
        this.animal.setIsPanicking(false);
    }
}

